/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.EntitySummaryAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.GetEntityExecutor;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetEntitySummaryExecutor
extends GetEntityExecutor {
    private EntitySummaryAccumulator accumulator;

    public GetEntitySummaryExecutor(String userId, String entityGUID, AuditLog auditLog, String methodName) {
        this(userId, entityGUID, new EntitySummaryAccumulator(auditLog), methodName);
    }

    private GetEntitySummaryExecutor(String userId, String entityGUID, EntitySummaryAccumulator accumulator, String methodName) {
        super(userId, entityGUID, accumulator, methodName);
        this.accumulator = accumulator;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            EntitySummary retrievedEntity = metadataCollection.getEntitySummary(this.userId, this.entityGUID);
            if (retrievedEntity != null) {
                this.accumulator.addEntity(retrievedEntity, metadataCollectionId);
            } else {
                this.getHomeClassifications(metadataCollection);
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public EntitySummary getEntitySummary() throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        EntitySummary latestEntity = this.accumulator.getResult();
        if (latestEntity != null) {
            return latestEntity;
        }
        this.accumulator.throwCapturedEntityNotKnownException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }
}

