/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector;

import java.util.UUID;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryMode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperConnector;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;

public class LocalOMRSConnectorProvider
extends ConnectorProvider {
    private String localMetadataCollectionId = null;
    private LocalRepositoryMode localRepositoryMode = null;
    private Connection localRepositoryRemoteConnection = null;
    private OMRSRepositoryEventMapperConnector realEventMapper = null;
    private OMRSRepositoryEventManager outboundRepositoryEventManager = null;
    private OMRSRepositoryContentManager repositoryContentManager = null;
    private OMRSRepositoryEventExchangeRule saveExchangeRule = null;
    private LocalOMRSRepositoryConnector localRepositoryConnector = null;
    private ConnectorTypeProperties connectorTypeProperties = null;
    private ConnectorType connectorType = null;
    private AuditLog auditLog = null;

    public LocalOMRSConnectorProvider(String localMetadataCollectionId, Connection localRepositoryRemoteConnection, OMRSRepositoryEventMapperConnector realEventMapper, OMRSRepositoryEventManager outboundRepositoryEventManager, OMRSRepositoryContentManager repositoryContentManager, OMRSRepositoryEventExchangeRule saveExchangeRule) {
        this(localMetadataCollectionId, LocalRepositoryMode.PLUGIN_REPOSITORY, localRepositoryRemoteConnection, realEventMapper, outboundRepositoryEventManager, repositoryContentManager, saveExchangeRule, null);
    }

    public LocalOMRSConnectorProvider(String localMetadataCollectionId, LocalRepositoryMode localRepositoryMode, Connection localRepositoryRemoteConnection, OMRSRepositoryEventMapperConnector realEventMapper, OMRSRepositoryEventManager outboundRepositoryEventManager, OMRSRepositoryContentManager repositoryContentManager, OMRSRepositoryEventExchangeRule saveExchangeRule, AuditLog auditLog) {
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.localRepositoryMode = localRepositoryMode;
        this.localRepositoryRemoteConnection = localRepositoryRemoteConnection;
        this.realEventMapper = realEventMapper;
        this.outboundRepositoryEventManager = outboundRepositoryEventManager;
        this.repositoryContentManager = repositoryContentManager;
        this.saveExchangeRule = saveExchangeRule;
        this.auditLog = auditLog;
    }

    public LocalOMRSConnectorProvider() {
    }

    public ConnectorTypeProperties getConnectorTypeProperties() {
        return this.connectorTypeProperties;
    }

    public ConnectorType getConnectorType() {
        return this.connectorType;
    }

    public synchronized Connector getConnector(Connection realLocalConnection) throws ConnectionCheckedException, ConnectorCheckedException {
        return this.getConnector(new ConnectionProperties(realLocalConnection));
    }

    public synchronized Connector getConnector(ConnectionProperties realLocalConnection) throws ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getConnector";
        if (this.localMetadataCollectionId == null) {
            throw new ConnectorCheckedException(OMRSErrorCode.LOCAL_REPOSITORY_CONFIGURATION_ERROR.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        if (this.localRepositoryConnector == null) {
            OMRSRepositoryConnector realLocalConnector;
            ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
            Connector connector = connectorBroker.getConnector(realLocalConnection);
            try {
                realLocalConnector = (OMRSRepositoryConnector)connector;
            }
            catch (Exception error) {
                throw new ConnectionCheckedException(OMRSErrorCode.BAD_LOCAL_REPOSITORY_CONNECTION.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName, (Throwable)error);
            }
            this.localRepositoryConnector = new LocalOMRSRepositoryConnector(realLocalConnector, this.localRepositoryMode, this.realEventMapper, this.outboundRepositoryEventManager, this.repositoryContentManager, this.saveExchangeRule);
            this.localRepositoryConnector.initialize(this.getNewConnectorGUID(), new ConnectionProperties(this.localRepositoryRemoteConnection));
        }
        return this.localRepositoryConnector;
    }

    private String getNewConnectorGUID() {
        UUID newUUID = UUID.randomUUID();
        return newUUID.toString();
    }
}

