/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetRelationshipExecutor
extends RepositoryExecutorBase {
    private final MaintenanceAccumulator accumulator;
    private final String relationshipGUID;
    private Date asOfTime = null;
    private Relationship retrievedRelationship = null;

    public GetRelationshipExecutor(String userId, String relationshipGUID, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.accumulator = new MaintenanceAccumulator(auditLog);
        this.relationshipGUID = relationshipGUID;
    }

    public GetRelationshipExecutor(String userId, String relationshipGUID, Date asOfTime, AuditLog auditLog, String methodName) {
        super(userId, methodName);
        this.accumulator = new MaintenanceAccumulator(auditLog);
        this.relationshipGUID = relationshipGUID;
        this.asOfTime = asOfTime;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        boolean result = false;
        try {
            this.retrievedRelationship = this.asOfTime == null ? metadataCollection.isRelationshipKnown(this.userId, this.relationshipGUID) : metadataCollection.getRelationship(this.userId, this.relationshipGUID, this.asOfTime);
            if (this.retrievedRelationship != null) {
                result = true;
            }
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (RelationshipNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return result;
    }

    public Relationship isRelationshipKnown() throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        if (this.retrievedRelationship != null) {
            return this.retrievedRelationship;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedInvalidParameterException();
        return null;
    }

    public Relationship getRelationship() throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        Relationship relationship = this.isRelationshipKnown();
        if (relationship != null) {
            if (relationship.getStatus() == InstanceStatus.DELETED) {
                throw new RelationshipNotKnownException(OMRSErrorCode.RELATIONSHIP_SOFT_DELETED.getMessageDefinition(new String[]{relationship.getType().getTypeDefName(), relationship.getGUID(), this.methodName, "Enterprise"}), this.getClass().getName(), this.methodName);
            }
            return relationship;
        }
        this.accumulator.throwCapturedRelationshipNotKnownException();
        throw new RelationshipNotKnownException(OMRSErrorCode.RELATIONSHIP_NOT_KNOWN.getMessageDefinition(new String[]{this.relationshipGUID, this.methodName, "Enterprise"}), this.getClass().getName(), this.methodName);
    }

    public Relationship getRelationshipHistory() throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        Relationship relationship = this.getRelationship();
        if (relationship != null) {
            return relationship;
        }
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

