/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.RelationshipsAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PageableRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class FindRelationshipsExecutor
extends PageableRepositoryExecutorBase {
    private final SearchProperties matchProperties;
    private final List<String> instanceSubtypeGUIDs;
    private final RelationshipsAccumulator accumulator;

    public FindRelationshipsExecutor(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator, String methodName) {
        this(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, new RelationshipsAccumulator(localMetadataCollectionId, auditLog, repositoryValidator), methodName);
    }

    private FindRelationshipsExecutor(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, RelationshipsAccumulator accumulator, String methodName) {
        super(userId, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize, asOfTime, accumulator, methodName);
        this.matchProperties = matchProperties;
        this.instanceSubtypeGUIDs = relationshipSubtypeGUIDs;
        this.accumulator = accumulator;
    }

    @Override
    public CloneableRepositoryExecutor getClone() {
        return new FindRelationshipsExecutor(this.userId, this.instanceTypeGUID, this.instanceSubtypeGUIDs, this.matchProperties, this.startingElement, this.limitResultsByStatus, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.pageSize, this.accumulator, this.methodName);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            List results = metadataCollection.findRelationships(this.userId, this.instanceTypeGUID, this.instanceSubtypeGUIDs, this.matchProperties, this.startingElement, this.limitResultsByStatus, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.pageSize);
            this.accumulator.addRelationships(results, metadataCollectionId);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (PropertyErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (TypeErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (PagingErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public List<Relationship> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.accumulator.resultsReturned()) {
            return this.accumulator.getResults(repositoryConnector);
        }
        this.handleCommonPagingRequestExceptions();
        return null;
    }
}

