/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.EntitiesAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PageableRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public abstract class PageableEntityRepositoryExecutorBase
extends PageableRepositoryExecutorBase {
    EntitiesAccumulator accumulator;

    PageableEntityRepositoryExecutorBase(String userId, String entityTypeGUID, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, EntitiesAccumulator accumulator, String methodName) {
        super(userId, entityTypeGUID, fromEntityElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize, asOfTime, accumulator, methodName);
        this.accumulator = accumulator;
    }

    @Override
    public List<String> getResultsForAugmentation() {
        return this.accumulator.getResultsForAugmentation();
    }

    @Override
    public void augmentResultFromRepository(String resultGUID, String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        List<String> contributingMetadataCollections = this.accumulator.getContributingMetadataCollections(resultGUID);
        if (contributingMetadataCollections == null || !contributingMetadataCollections.contains(metadataCollectionId)) {
            try {
                List homeClassifications = metadataCollection.getHomeClassifications(this.userId, resultGUID);
                this.accumulator.saveClassifications(resultGUID, homeClassifications);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public List<EntityDetail> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector, OMRSMetadataCollection metadataCollection) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.accumulator.resultsReturned()) {
            return this.accumulator.getResults(repositoryConnector, metadataCollection);
        }
        this.handleCommonPagingRequestExceptions();
        return null;
    }
}

