/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.EntitiesAccumulator;

public class EntityHistoryAccumulator
extends EntitiesAccumulator {
    private final Map<Long, EntityDetail> accumulatedEntities = new HashMap<Long, EntityDetail>();
    private final Map<String, List<Classification>> accumulatedClassifications = new HashMap<String, List<Classification>>();
    private final Map<String, List<String>> accumulatedEntitySources = new HashMap<String, List<String>>();
    private String entityGUID = null;

    public EntityHistoryAccumulator(String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator) {
        super(localMetadataCollectionId, auditLog, repositoryValidator);
    }

    private void addEntity(EntityDetail incomingEntity, String metadataCollectionId) {
        if (incomingEntity != null && incomingEntity.getGUID() != null && metadataCollectionId != null) {
            this.entityGUID = incomingEntity.getGUID();
            List<String> contributingMetadataCollections = this.accumulatedEntitySources.get(this.entityGUID);
            if (contributingMetadataCollections == null) {
                contributingMetadataCollections = new ArrayList<String>();
            }
            contributingMetadataCollections.add(metadataCollectionId);
            this.accumulatedEntitySources.put(this.entityGUID, contributingMetadataCollections);
            this.accumulatedEntities.put(incomingEntity.getVersion(), incomingEntity);
            if (metadataCollectionId.equals(this.localMetadataCollectionId)) {
                super.captureLocalInstance(this.entityGUID);
            }
            this.saveClassifications(this.entityGUID, incomingEntity.getClassifications());
        }
    }

    @Override
    public synchronized void addEntities(List<EntityDetail> entities, String metadataCollectionId) {
        if (entities != null) {
            for (EntityDetail entity : entities) {
                this.entityGUID = entity.getGUID();
                this.addEntity(entity, metadataCollectionId);
            }
            super.setResultsReturned(metadataCollectionId, entities.size());
        } else {
            super.setResultsReturned(metadataCollectionId, 0);
        }
    }

    @Override
    public synchronized void saveClassifications(String entityGUID, List<Classification> incomingClassifications) {
        List<Classification> currentSavedClassifications = this.accumulatedClassifications.get(entityGUID);
        if (currentSavedClassifications == null) {
            if (incomingClassifications != null) {
                this.accumulatedClassifications.put(entityGUID, incomingClassifications);
            }
        } else if (incomingClassifications != null) {
            HashMap<String, Classification> entityClassificationsMap = new HashMap<String, Classification>();
            for (Classification existingClassification : currentSavedClassifications) {
                if (existingClassification == null) continue;
                entityClassificationsMap.put(existingClassification.getName(), existingClassification);
            }
            for (Classification newClassification : incomingClassifications) {
                Classification existingClassification;
                if (newClassification == null || (existingClassification = (Classification)entityClassificationsMap.get(newClassification.getName())) != null && existingClassification.getVersion() >= newClassification.getVersion()) continue;
                entityClassificationsMap.put(newClassification.getName(), newClassification);
            }
            if (!entityClassificationsMap.isEmpty()) {
                this.accumulatedClassifications.put(entityGUID, new ArrayList(entityClassificationsMap.values()));
            }
        }
    }

    @Override
    public List<String> getContributingMetadataCollections(String entityGUID) {
        return this.accumulatedEntitySources.get(entityGUID);
    }

    @Override
    public List<String> getResultsForAugmentation() {
        if (!this.accumulatedEntities.isEmpty() && this.entityGUID != null) {
            ArrayList<String> guids = new ArrayList<String>();
            guids.add(this.entityGUID);
            return guids;
        }
        return null;
    }

    @Override
    public synchronized List<EntityDetail> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector, OMRSMetadataCollection metadataCollection) {
        if (this.accumulatedEntities.isEmpty()) {
            return null;
        }
        this.makeRefreshRecommendations(repositoryConnector);
        ArrayList<EntityDetail> results = new ArrayList<EntityDetail>();
        if (metadataCollection != null) {
            for (EntityDetail accumulatedEntity : this.accumulatedEntities.values()) {
                if (accumulatedEntity == null) continue;
                EntityDetail resultEntity = new EntityDetail(accumulatedEntity);
                resultEntity.setClassifications(this.accumulatedClassifications.get(accumulatedEntity.getGUID()));
                results.add(resultEntity);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private void makeRefreshRecommendations(EnterpriseOMRSRepositoryConnector repositoryConnector) {
        if (this.localMetadataCollectionId == null || this.accumulatedEntities.isEmpty()) {
            return;
        }
        for (EntityDetail accumulatedEntity : this.accumulatedEntities.values()) {
            String entityGUID;
            if (accumulatedEntity == null || (entityGUID = accumulatedEntity.getGUID()) == null || !super.notLocal(entityGUID)) continue;
            repositoryConnector.requestRefreshOfEntity(accumulatedEntity);
        }
    }
}

