/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Differences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetailDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxyDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummaryDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.RelationshipDifferences;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.ClassificationCondition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities.OMRSRepositoryPropertiesUtilities;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryContentHelper
extends OMRSRepositoryPropertiesUtilities
implements OMRSRepositoryHelper {
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryContentHelper.class);
    private final OMRSRepositoryContentManager repositoryContentManager;

    public OMRSRepositoryContentHelper(OMRSRepositoryContentManager repositoryContentManager) {
        this.repositoryContentManager = repositoryContentManager;
    }

    public TypeDefGallery getActiveTypeDefGallery() {
        String methodName = "getActiveTypeDefGallery";
        this.validateRepositoryContentManager("getActiveTypeDefGallery");
        return this.repositoryContentManager.getActiveTypeDefGallery();
    }

    public List<TypeDef> getActiveTypeDefs() {
        String methodName = "getActiveTypeDefs";
        this.validateRepositoryContentManager("getActiveTypeDefs");
        return this.repositoryContentManager.getActiveTypeDefs();
    }

    public List<TypeDef> getKnownTypeDefs() {
        String methodName = "getKnownTypeDefs";
        this.validateRepositoryContentManager("getKnownTypeDefs");
        return this.repositoryContentManager.getKnownTypeDefs();
    }

    public List<AttributeTypeDef> getActiveAttributeTypeDefs() {
        String methodName = "getActiveAttributeTypeDefs";
        this.validateRepositoryContentManager("getActiveAttributeTypeDefs");
        return this.repositoryContentManager.getActiveAttributeTypeDefs();
    }

    public List<AttributeTypeDef> getKnownAttributeTypeDefs() {
        String methodName = "getKnownAttributeTypeDefs";
        this.validateRepositoryContentManager("getKnownAttributeTypeDefs");
        return this.repositoryContentManager.getKnownAttributeTypeDefs();
    }

    public TypeDefGallery getKnownTypeDefGallery() {
        String methodName = "getKnownTypeDefGallery";
        this.validateRepositoryContentManager("getKnownTypeDefGallery");
        return this.repositoryContentManager.getKnownTypeDefGallery();
    }

    public InstanceProperties getUniqueProperties(String sourceName, String typeName, InstanceProperties allProperties) {
        InstanceProperties uniqueProperties = null;
        if (allProperties != null) {
            uniqueProperties = new InstanceProperties();
            uniqueProperties.setEffectiveFromTime(allProperties.getEffectiveFromTime());
            uniqueProperties.setEffectiveToTime(allProperties.getEffectiveToTime());
            TypeDef typeDef = this.getTypeDefByName(sourceName, typeName);
            if (typeDef != null) {
                List uniquePropertyNames = this.getUniquePropertiesList(typeDef.getPropertiesDefinition(), null);
                TypeDef superType = null;
                if (typeDef.getSuperType() != null) {
                    superType = this.getTypeDefByName(sourceName, typeDef.getSuperType().getName());
                }
                while (superType != null) {
                    uniquePropertyNames = this.getUniquePropertiesList(superType.getPropertiesDefinition(), uniquePropertyNames);
                    if (superType.getSuperType() != null) {
                        superType = this.getTypeDefByName(sourceName, superType.getSuperType().getName());
                        continue;
                    }
                    superType = null;
                }
                if (uniquePropertyNames != null) {
                    Map allInstancePropertiesMap = allProperties.getInstanceProperties();
                    HashMap<String, InstancePropertyValue> uniqueInstancePropertiesMap = new HashMap<String, InstancePropertyValue>();
                    if (allInstancePropertiesMap != null) {
                        for (String propertyName : allInstancePropertiesMap.keySet()) {
                            if (propertyName == null || !uniquePropertyNames.contains(propertyName)) continue;
                            uniqueInstancePropertiesMap.put(propertyName, (InstancePropertyValue)allInstancePropertiesMap.get(propertyName));
                        }
                    }
                    if (!uniqueInstancePropertiesMap.isEmpty()) {
                        uniqueProperties.setInstanceProperties(uniqueInstancePropertiesMap);
                    }
                }
            }
        }
        return uniqueProperties;
    }

    public TypeDef getTypeDefByName(String sourceName, String typeDefName) {
        String methodName = "getTypeDefByName";
        this.validateRepositoryContentManager("getTypeDefByName");
        return this.repositoryContentManager.getTypeDefByName(typeDefName);
    }

    public List<TypeDefLink> getSuperTypes(String sourceName, String typeDefName) {
        String methodName = "getTypeDefByName";
        this.validateRepositoryContentManager("getTypeDefByName");
        return this.repositoryContentManager.getSuperTypes(sourceName, typeDefName, "getTypeDefByName");
    }

    public String getOtherEndName(String sourceName, String anchorEntityGUID, Relationship relationship) {
        if (relationship != null) {
            RelationshipDef relationshipTypeDef = (RelationshipDef)this.getTypeDefByName(sourceName, relationship.getType().getTypeDefName());
            String endOneName = relationshipTypeDef.getEndDef1().getAttributeName();
            String endTwoName = relationshipTypeDef.getEndDef2().getAttributeName();
            EntityProxy entityProxy = relationship.getEntityOneProxy();
            if (entityProxy != null) {
                if (anchorEntityGUID.equals(entityProxy.getGUID())) {
                    return endTwoName;
                }
                return endOneName;
            }
        }
        return null;
    }

    public EntityProxy getOtherEnd(String sourceName, String anchorEntityGUID, Relationship relationship) {
        EntityProxy entityProxy;
        if (relationship != null && (entityProxy = relationship.getEntityOneProxy()) != null) {
            if (anchorEntityGUID.equals(entityProxy.getGUID())) {
                return relationship.getEntityTwoProxy();
            }
            return entityProxy;
        }
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String sourceName, String attributeTypeDefName) {
        String methodName = "getAttributeTypeDefByName";
        this.validateRepositoryContentManager("getAttributeTypeDefByName");
        return this.repositoryContentManager.getAttributeTypeDefByName(attributeTypeDefName);
    }

    public TypeDef getTypeDef(String sourceName, String parameterName, String typeDefGUID, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getTypeDef(sourceName, parameterName, typeDefGUID, methodName);
    }

    public AttributeTypeDef getAttributeTypeDef(String sourceName, String attributeTypeDefGUID, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getAttributeTypeDef(sourceName, attributeTypeDefGUID, methodName);
    }

    public TypeDef getTypeDef(String sourceName, String guidParameterName, String nameParameterName, String typeDefGUID, String typeDefName, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getTypeDef(sourceName, guidParameterName, nameParameterName, typeDefGUID, typeDefName, methodName);
    }

    public AttributeTypeDef getAttributeTypeDef(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getAttributeTypeDef(sourceName, attributeTypeDefGUID, attributeTypeDefName, methodName);
    }

    public InstanceProperties addEnumPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, String enumTypeGUID, String enumTypeName, int ordinal, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.addEnumPropertyToInstance(sourceName, properties, propertyName, enumTypeGUID, enumTypeName, ordinal, methodName);
    }

    public TypeDef applyPatch(String sourceName, TypeDef originalTypeDef, TypeDefPatch typeDefPatch) throws InvalidParameterException, PatchErrorException {
        String methodName = "applyPatch";
        this.validateRepositoryContentManager("applyPatch");
        return this.applyPatch(sourceName, originalTypeDef, typeDefPatch, "applyPatch");
    }

    public List<String> getSubTypesOf(String sourceName, String superTypeName) {
        String methodName = "getSubTypesOf";
        this.validateRepositoryContentManager("getSubTypesOf");
        ArrayList<String> subTypeNames = new ArrayList<String>();
        List<TypeDef> typeDefs = this.repositoryContentManager.getKnownTypeDefs();
        if (typeDefs != null && superTypeName != null) {
            for (TypeDef typeDef : typeDefs) {
                if (typeDef == null || typeDef.getSuperType() == null) continue;
                if (superTypeName.equals(typeDef.getSuperType().getName())) {
                    subTypeNames.add(typeDef.getName());
                    continue;
                }
                List<TypeDefLink> superTypes = this.repositoryContentManager.getSuperTypes(sourceName, typeDef.getSuperType().getName(), "getSubTypesOf");
                if (superTypes == null) continue;
                for (TypeDefLink typeDefLink : superTypes) {
                    if (typeDefLink == null || !superTypeName.equals(typeDefLink.getName())) continue;
                    subTypeNames.add(typeDef.getName());
                }
            }
        }
        if (subTypeNames.isEmpty()) {
            return null;
        }
        return subTypeNames;
    }

    public List<TypeDefAttribute> getAllPropertiesForTypeDef(String sourceName, TypeDef typeDef, String methodName) {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getAllPropertiesForTypeDef(sourceName, typeDef, methodName);
    }

    public Set<String> getAllTypeDefsForProperty(String sourceName, String propertyName, String methodName) {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getAllTypeDefsForProperty(sourceName, propertyName, methodName);
    }

    public boolean isTypeOf(String sourceName, String actualTypeName, String expectedTypeName) {
        String methodName = "isTypeOf";
        this.validateRepositoryContentManager("isTypeOf");
        return this.repositoryContentManager.isTypeOf(sourceName, actualTypeName, expectedTypeName);
    }

    public void registerMetadataCollection(String metadataCollectionId, String metadataCollectionName) {
        String methodName = "registerMetadataCollection";
        this.validateRepositoryContentManager("registerMetadataCollection");
        this.repositoryContentManager.registerMetadataCollection(metadataCollectionId, metadataCollectionName);
    }

    public String getMetadataCollectionName(String metadataCollectionId) {
        String methodName = "getMetadataCollectionName";
        this.validateRepositoryContentManager("getMetadataCollectionName");
        return this.repositoryContentManager.getMetadataCollectionName(metadataCollectionId);
    }

    @Deprecated
    public EntityDetail getSkeletonEntity(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        return this.getSkeletonEntity(sourceName, metadataCollectionId, null, provenanceType, userName, typeName);
    }

    public EntityDetail getSkeletonEntity(String sourceName, String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        String methodName = "getSkeletonEntity";
        this.validateRepositoryContentManager("getSkeletonEntity");
        EntityDetail entity = new EntityDetail();
        this.populateSkeletonEntity((EntitySummary)entity, UUID.randomUUID().toString(), sourceName, metadataCollectionId, metadataCollectionName, provenanceType, userName, typeName, "getSkeletonEntity");
        return entity;
    }

    @Deprecated
    public EntitySummary getSkeletonEntitySummary(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        String methodName = "getSkeletonEntitySummary";
        this.validateRepositoryContentManager("getSkeletonEntitySummary");
        EntitySummary entity = new EntitySummary();
        this.populateSkeletonEntity(entity, UUID.randomUUID().toString(), sourceName, metadataCollectionId, null, provenanceType, userName, typeName, "getSkeletonEntitySummary");
        return entity;
    }

    public EntitySummary getSkeletonEntitySummary(String sourceName, String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        String methodName = "getSkeletonEntitySummary";
        this.validateRepositoryContentManager("getSkeletonEntitySummary");
        EntitySummary entity = new EntitySummary();
        this.populateSkeletonEntity(entity, UUID.randomUUID().toString(), sourceName, metadataCollectionId, metadataCollectionName, provenanceType, userName, typeName, "getSkeletonEntitySummary");
        return entity;
    }

    private void populateSkeletonEntity(EntitySummary entity, String guid, String sourceName, String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String typeName, String methodName) throws TypeErrorException {
        entity.setHeaderVersion(1L);
        entity.setInstanceProvenanceType(provenanceType);
        entity.setMetadataCollectionId(metadataCollectionId);
        entity.setMetadataCollectionName(metadataCollectionName);
        entity.setCreateTime(new Date());
        entity.setGUID(guid);
        entity.setVersion(1L);
        entity.setType(this.repositoryContentManager.getInstanceType(sourceName, TypeDefCategory.ENTITY_DEF, typeName, methodName));
        entity.setStatus(this.repositoryContentManager.getInitialStatus(sourceName, typeName, methodName));
        entity.setCreatedBy(userName);
        entity.setInstanceURL(this.repositoryContentManager.getEntityURL(sourceName, guid));
    }

    public Classification getSkeletonClassification(String sourceName, String userName, String classificationTypeName, String entityTypeName) throws TypeErrorException {
        return this.getSkeletonClassification(sourceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userName, classificationTypeName, entityTypeName);
    }

    public Classification getSkeletonClassification(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String classificationTypeName, String entityTypeName) throws TypeErrorException {
        return this.getSkeletonClassification(sourceName, metadataCollectionId, null, provenanceType, userName, classificationTypeName, entityTypeName);
    }

    public Classification getSkeletonClassification(String sourceName, String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String classificationTypeName, String entityTypeName) throws TypeErrorException {
        String methodName = "getSkeletonClassification";
        this.validateRepositoryContentManager("getSkeletonClassification");
        if (this.repositoryContentManager.isValidTypeCategory(sourceName, TypeDefCategory.CLASSIFICATION_DEF, classificationTypeName, "getSkeletonClassification")) {
            if (this.repositoryContentManager.isValidClassificationForEntity(sourceName, classificationTypeName, entityTypeName, "getSkeletonClassification")) {
                Classification classification = new Classification();
                classification.setHeaderVersion(1L);
                classification.setInstanceProvenanceType(provenanceType);
                classification.setMetadataCollectionId(metadataCollectionId);
                classification.setMetadataCollectionName(metadataCollectionName);
                classification.setName(classificationTypeName);
                classification.setCreateTime(new Date());
                classification.setCreatedBy(userName);
                classification.setVersion(1L);
                classification.setType(this.repositoryContentManager.getInstanceType(sourceName, TypeDefCategory.CLASSIFICATION_DEF, classificationTypeName, "getSkeletonClassification"));
                classification.setStatus(this.repositoryContentManager.getInitialStatus(sourceName, classificationTypeName, "getSkeletonClassification"));
                return classification;
            }
            throw new TypeErrorException(OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY.getMessageDefinition(new String[]{classificationTypeName, entityTypeName}), ((Object)((Object)this)).getClass().getName(), "getSkeletonClassification");
        }
        throw new TypeErrorException(OMRSErrorCode.UNKNOWN_CLASSIFICATION.getMessageDefinition(new String[]{classificationTypeName}), ((Object)((Object)this)).getClass().getName(), "getSkeletonClassification");
    }

    public Relationship getSkeletonRelationship(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        return this.getSkeletonRelationship(sourceName, metadataCollectionId, null, provenanceType, userName, typeName);
    }

    public Relationship getSkeletonRelationship(String sourceName, String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        String methodName = "getSkeletonRelationship";
        this.validateRepositoryContentManager("getSkeletonRelationship");
        Relationship relationship = new Relationship();
        String guid = UUID.randomUUID().toString();
        relationship.setHeaderVersion(1L);
        relationship.setInstanceProvenanceType(provenanceType);
        relationship.setMetadataCollectionId(metadataCollectionId);
        relationship.setMetadataCollectionName(metadataCollectionName);
        relationship.setCreateTime(new Date());
        relationship.setGUID(guid);
        relationship.setVersion(1L);
        relationship.setType(this.repositoryContentManager.getInstanceType(sourceName, TypeDefCategory.RELATIONSHIP_DEF, typeName, "getSkeletonRelationship"));
        relationship.setStatus(this.repositoryContentManager.getInitialStatus(sourceName, typeName, "getSkeletonRelationship"));
        relationship.setCreatedBy(userName);
        relationship.setInstanceURL(this.repositoryContentManager.getRelationshipURL(sourceName, guid));
        return relationship;
    }

    public InstanceType getNewInstanceType(String sourceName, TypeDefSummary typeDefSummary) throws TypeErrorException {
        String methodName = "getNewInstanceType";
        this.validateRepositoryContentManager("getNewInstanceType");
        return this.repositoryContentManager.getInstanceType(sourceName, typeDefSummary.getCategory(), typeDefSummary.getName(), "getNewInstanceType");
    }

    public EntityDetail getNewEntity(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName, InstanceProperties properties, List<Classification> classifications) throws TypeErrorException {
        return this.getNewEntity(sourceName, metadataCollectionId, null, provenanceType, userName, typeName, properties, classifications);
    }

    public EntityDetail getNewEntity(String sourceName, String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String typeName, InstanceProperties properties, List<Classification> classifications) throws TypeErrorException {
        EntityDetail entity = this.getSkeletonEntity(sourceName, metadataCollectionId, metadataCollectionName, provenanceType, userName, typeName);
        entity.setProperties(properties);
        entity.setClassifications(classifications);
        return entity;
    }

    public Relationship getNewRelationship(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName, InstanceProperties properties) throws TypeErrorException {
        return this.getNewRelationship(sourceName, metadataCollectionId, null, provenanceType, userName, typeName, properties);
    }

    public Relationship getNewRelationship(String sourceName, String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String typeName, InstanceProperties properties) throws TypeErrorException {
        Relationship relationship = this.getSkeletonRelationship(sourceName, metadataCollectionId, metadataCollectionName, provenanceType, userName, typeName);
        relationship.setProperties(properties);
        return relationship;
    }

    public Classification getNewClassification(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName, String entityTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws TypeErrorException {
        return this.getNewClassification(sourceName, metadataCollectionId, null, provenanceType, userName, typeName, entityTypeName, classificationOrigin, classificationOriginGUID, properties);
    }

    @Deprecated
    public Classification getNewClassification(String sourceName, String userName, String typeName, String entityTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws TypeErrorException {
        Classification classification = this.getSkeletonClassification(sourceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userName, typeName, entityTypeName);
        classification.setClassificationOrigin(classificationOrigin);
        classification.setClassificationOriginGUID(classificationOriginGUID);
        classification.setProperties(properties);
        return classification;
    }

    public Classification getNewClassification(String sourceName, String metadataCollectionId, String metadataCollectionName, InstanceProvenanceType provenanceType, String userName, String typeName, String entityTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws TypeErrorException {
        Classification classification = this.getSkeletonClassification(sourceName, metadataCollectionId, metadataCollectionName, provenanceType, userName, typeName, entityTypeName);
        classification.setClassificationOrigin(classificationOrigin);
        classification.setClassificationOriginGUID(classificationOriginGUID);
        classification.setProperties(properties);
        return classification;
    }

    @Deprecated
    public void checkEntityNotClassifiedEntity(String sourceName, EntitySummary entity, String classificationName, String methodName) throws ClassificationErrorException {
        String thisMethodName = "checkEntityNotClassifiedEntity";
        if (entity == null || classificationName == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, "checkEntityNotClassifiedEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        List entityClassifications = entity.getClassifications();
        if (entityClassifications != null) {
            for (Classification entityClassification : entityClassifications) {
                if (!classificationName.equals(entityClassification.getName())) continue;
                throw new ClassificationErrorException(OMRSErrorCode.ENTITY_ALREADY_CLASSIFIED.getMessageDefinition(new String[]{methodName, sourceName, classificationName, entity.getGUID()}), ((Object)((Object)this)).getClass().getName(), methodName);
            }
        }
    }

    public Classification checkEntityNotClassifiedEntity(String sourceName, EntitySummary entity, String classificationName, InstanceProperties classificationProperties, AuditLog auditLog, String methodName) throws ClassificationErrorException {
        String thisMethodName = "checkEntityNotClassifiedEntity";
        if (entity == null || classificationName == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, "checkEntityNotClassifiedEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        List entityClassifications = entity.getClassifications();
        if (entityClassifications != null) {
            for (Classification entityClassification : entityClassifications) {
                if (!classificationName.equals(entityClassification.getName())) continue;
                if (classificationProperties == null && entityClassification.getProperties() == null || classificationProperties != null && classificationProperties.equals((Object)entityClassification.getProperties())) {
                    if (auditLog != null) {
                        auditLog.logMessage(methodName, OMRSAuditCode.IGNORING_DUPLICATE_CLASSIFICATION.getMessageDefinition(new String[]{entity.getType().getTypeDefName(), entity.getGUID(), classificationName, sourceName}));
                    }
                    return entityClassification;
                }
                throw new ClassificationErrorException(OMRSErrorCode.ENTITY_ALREADY_CLASSIFIED.getMessageDefinition(new String[]{methodName, sourceName, classificationName, entity.getGUID()}), ((Object)((Object)this)).getClass().getName(), methodName);
            }
        }
        return null;
    }

    public List<Classification> addClassificationToList(String sourceName, List<Classification> classificationList, Classification newClassification, String methodName) {
        if (newClassification != null) {
            Classification existingClassification;
            HashMap<String, Classification> entityClassificationsMap = new HashMap<String, Classification>();
            if (classificationList != null) {
                for (Classification existingClassification2 : classificationList) {
                    if (existingClassification2 == null) continue;
                    entityClassificationsMap.put(existingClassification2.getName(), existingClassification2);
                }
            }
            if ((existingClassification = (Classification)entityClassificationsMap.get(newClassification.getName())) == null || existingClassification.getVersion() < newClassification.getVersion()) {
                entityClassificationsMap.put(newClassification.getName(), newClassification);
            }
            if (entityClassificationsMap.isEmpty()) {
                return null;
            }
            return new ArrayList<Classification>(entityClassificationsMap.values());
        }
        String thisMethodName = "addClassificationToList";
        throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CLASSIFICATION_CREATED.getMessageDefinition(new String[]{sourceName, "addClassificationToList", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public EntityDetail addClassificationToEntity(String sourceName, EntityDetail entity, Classification newClassification, String methodName) {
        String thisMethodName = "addClassificationToEntity";
        if (newClassification != null) {
            if (entity != null) {
                EntityDetail updatedEntity = new EntityDetail(entity);
                updatedEntity.setClassifications(this.addClassificationToList(sourceName, entity.getClassifications(), newClassification, methodName));
                return updatedEntity;
            }
            throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, "addClassificationToEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CLASSIFICATION_CREATED.getMessageDefinition(new String[]{sourceName, "addClassificationToEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public EntityProxy addClassificationToEntity(String sourceName, EntityProxy entity, Classification newClassification, String methodName) {
        String thisMethodName = "addClassificationToEntity(Proxy)";
        if (newClassification != null) {
            if (entity != null) {
                EntityProxy updatedEntity = new EntityProxy(entity);
                updatedEntity.setClassifications(this.addClassificationToList(sourceName, entity.getClassifications(), newClassification, methodName));
                return updatedEntity;
            }
            throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, "addClassificationToEntity(Proxy)", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CLASSIFICATION_CREATED.getMessageDefinition(new String[]{sourceName, "addClassificationToEntity(Proxy)", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public InstanceProperties getClassificationProperties(String sourceName, List<Classification> classifications, String classificationName, String methodName) {
        String thisMethodName = "getClassificationProperties";
        if (classificationName == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, "getClassificationProperties", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        if (classifications != null) {
            for (Classification classification : classifications) {
                if (!classificationName.equals(classification.getName())) continue;
                return classification.getProperties();
            }
        }
        return null;
    }

    public Classification getClassificationFromEntity(String sourceName, EntitySummary entity, String classificationName, String methodName) throws ClassificationErrorException {
        String thisMethodName = "getClassificationFromEntity";
        if (entity == null || classificationName == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, "getClassificationFromEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        List entityClassifications = entity.getClassifications();
        if (entityClassifications != null) {
            for (Classification entityClassification : entityClassifications) {
                if (!classificationName.equals(entityClassification.getName())) continue;
                return entityClassification;
            }
        }
        throw new ClassificationErrorException(OMRSErrorCode.ENTITY_NOT_CLASSIFIED.getMessageDefinition(new String[]{methodName, sourceName, classificationName, entity.getGUID()}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public List<Classification> getHomeClassificationsFromEntity(String sourceName, EntityDetail entity, String metadataCollectionId, String methodName) {
        String thisMethodName = "getHomeClassificationsFromEntity";
        if (entity == null || metadataCollectionId == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, "getHomeClassificationsFromEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
        List entityClassifications = entity.getClassifications();
        ArrayList<Classification> homeClassifications = new ArrayList<Classification>();
        if (entityClassifications != null) {
            for (Classification entityClassification : entityClassifications) {
                if (metadataCollectionId.equals(entityClassification.getMetadataCollectionId())) {
                    homeClassifications.add(entityClassification);
                    continue;
                }
                if (entityClassification.getMetadataCollectionId() != null) continue;
                homeClassifications.add(entityClassification);
            }
        }
        if (homeClassifications.isEmpty()) {
            return null;
        }
        return homeClassifications;
    }

    public EntityDetail updateClassificationInEntity(String sourceName, String userName, EntityDetail entity, Classification newClassification, String methodName) {
        if (newClassification != null) {
            Classification updatedClassification = new Classification(newClassification);
            updatedClassification = this.incrementVersion(userName, (InstanceAuditHeader)newClassification, updatedClassification);
            return this.addClassificationToEntity(sourceName, entity, updatedClassification, methodName);
        }
        String thisMethodName = "updateClassificationInEntity";
        throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CLASSIFICATION_CREATED.getMessageDefinition(new String[]{sourceName, "updateClassificationInEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public EntityProxy updateClassificationInEntity(String sourceName, String userName, EntityProxy entity, Classification newClassification, String methodName) {
        if (newClassification != null) {
            Classification updatedClassification = new Classification(newClassification);
            updatedClassification = this.incrementVersion(userName, (InstanceAuditHeader)newClassification, updatedClassification);
            return this.addClassificationToEntity(sourceName, entity, updatedClassification, methodName);
        }
        String thisMethodName = "updateClassificationInEntity";
        throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CLASSIFICATION_CREATED.getMessageDefinition(new String[]{sourceName, "updateClassificationInEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public EntityDetail deleteClassificationFromEntity(String sourceName, EntityDetail entity, String oldClassificationName, String methodName) throws ClassificationErrorException {
        EntityDetail updatedEntity = new EntityDetail(entity);
        if (oldClassificationName != null) {
            Classification oldClassification;
            HashMap<String, Classification> entityClassificationsMap = new HashMap<String, Classification>();
            ArrayList entityClassifications = updatedEntity.getClassifications();
            if (entityClassifications != null) {
                for (Classification existingClassification : entityClassifications) {
                    if (existingClassification == null) continue;
                    entityClassificationsMap.put(existingClassification.getName(), existingClassification);
                }
            }
            if ((oldClassification = (Classification)entityClassificationsMap.remove(oldClassificationName)) == null) {
                throw new ClassificationErrorException(OMRSErrorCode.ENTITY_NOT_CLASSIFIED.getMessageDefinition(new String[]{methodName, sourceName, oldClassificationName, entity.getGUID()}), ((Object)((Object)this)).getClass().getName(), methodName);
            }
            if (entityClassificationsMap.isEmpty()) {
                updatedEntity.setClassifications(null);
            } else {
                entityClassifications = new ArrayList(entityClassificationsMap.values());
                updatedEntity.setClassifications(entityClassifications);
            }
            return updatedEntity;
        }
        String thisMethodName = "deleteClassificationFromEntity";
        throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CLASSIFICATION_NAME.getMessageDefinition(new String[]{sourceName, "deleteClassificationFromEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public EntityProxy deleteClassificationFromEntity(String sourceName, EntityProxy entity, String oldClassificationName, String methodName) throws ClassificationErrorException {
        EntityProxy updatedEntity = new EntityProxy(entity);
        if (oldClassificationName != null) {
            Classification oldClassification;
            HashMap<String, Classification> entityClassificationsMap = new HashMap<String, Classification>();
            ArrayList entityClassifications = updatedEntity.getClassifications();
            if (entityClassifications != null) {
                for (Classification existingClassification : entityClassifications) {
                    if (existingClassification == null) continue;
                    entityClassificationsMap.put(existingClassification.getName(), existingClassification);
                }
            }
            if ((oldClassification = (Classification)entityClassificationsMap.remove(oldClassificationName)) == null) {
                throw new ClassificationErrorException(OMRSErrorCode.ENTITY_NOT_CLASSIFIED.getMessageDefinition(new String[]{methodName, sourceName, oldClassificationName, entity.getGUID()}), ((Object)((Object)this)).getClass().getName(), methodName);
            }
            if (entityClassificationsMap.isEmpty()) {
                updatedEntity.setClassifications(null);
            } else {
                entityClassifications = new ArrayList(entityClassificationsMap.values());
                updatedEntity.setClassifications(entityClassifications);
            }
            return updatedEntity;
        }
        String thisMethodName = "deleteClassificationFromEntity";
        throw new OMRSLogicErrorException(OMRSErrorCode.NULL_CLASSIFICATION_NAME.getMessageDefinition(new String[]{sourceName, "deleteClassificationFromEntity", methodName}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public InstanceProperties mergeInstanceProperties(String sourceName, InstanceProperties existingProperties, InstanceProperties newProperties) {
        InstanceProperties mergedProperties;
        if (existingProperties == null) {
            mergedProperties = newProperties;
        } else {
            mergedProperties = existingProperties;
            if (newProperties != null) {
                Iterator newPropertyNames = newProperties.getPropertyNames();
                while (newPropertyNames.hasNext()) {
                    String newPropertyName = (String)newPropertyNames.next();
                    mergedProperties.setProperty(newPropertyName, newProperties.getPropertyValue(newPropertyName));
                }
            }
        }
        return mergedProperties;
    }

    public Relationship incrementVersion(String userId, InstanceAuditHeader originalInstance, Relationship updatedInstance) {
        updatedInstance.setUpdatedBy(userId);
        updatedInstance.setUpdateTime(new Date());
        long currentVersion = originalInstance.getVersion();
        updatedInstance.setVersion(currentVersion + 1L);
        ArrayList<String> maintainedBy = originalInstance.getMaintainedBy();
        if (maintainedBy == null) {
            maintainedBy = new ArrayList<String>();
        }
        if (!maintainedBy.contains(userId)) {
            maintainedBy.add(userId);
            updatedInstance.setMaintainedBy(maintainedBy);
        }
        return updatedInstance;
    }

    public Classification incrementVersion(String userId, InstanceAuditHeader originalInstance, Classification updatedInstance) {
        updatedInstance.setUpdatedBy(userId);
        updatedInstance.setUpdateTime(new Date());
        long currentVersion = originalInstance.getVersion();
        updatedInstance.setVersion(currentVersion + 1L);
        ArrayList<String> maintainedBy = originalInstance.getMaintainedBy();
        if (maintainedBy == null) {
            maintainedBy = new ArrayList<String>();
        }
        if (!maintainedBy.contains(userId)) {
            maintainedBy.add(userId);
            updatedInstance.setMaintainedBy(maintainedBy);
        }
        return updatedInstance;
    }

    public EntityDetail incrementVersion(String userId, InstanceAuditHeader originalInstance, EntityDetail updatedInstance) {
        updatedInstance.setUpdatedBy(userId);
        updatedInstance.setUpdateTime(new Date());
        long currentVersion = originalInstance.getVersion();
        updatedInstance.setVersion(currentVersion + 1L);
        ArrayList<String> maintainedBy = originalInstance.getMaintainedBy();
        if (maintainedBy == null) {
            maintainedBy = new ArrayList<String>();
        }
        if (!maintainedBy.contains(userId)) {
            maintainedBy.add(userId);
            updatedInstance.setMaintainedBy(maintainedBy);
        }
        return updatedInstance;
    }

    public EntityProxy getNewEntityProxy(String sourceName, EntityDetail entity) throws RepositoryErrorException {
        InstanceType type;
        String methodName = "getNewEntityProxy";
        String parameterName = "entity";
        this.validateRepositoryContentManager("getNewEntityProxy");
        if (entity != null && (type = entity.getType()) != null) {
            try {
                TypeDef typeDef = this.repositoryContentManager.getTypeDef(sourceName, "entity", "entity", type.getTypeDefGUID(), type.getTypeDefName(), "getNewEntityProxy");
                EntityProxy entityProxy = new EntityProxy((EntitySummary)entity);
                InstanceProperties entityProperties = entity.getProperties();
                if (entityProperties != null) {
                    List<TypeDefAttribute> propertiesDefinition = this.repositoryContentManager.getAllPropertiesForTypeDef(sourceName, typeDef, "getNewEntityProxy");
                    InstanceProperties uniqueAttributes = new InstanceProperties();
                    uniqueAttributes.setEffectiveFromTime(entityProperties.getEffectiveFromTime());
                    uniqueAttributes.setEffectiveToTime(entityProperties.getEffectiveToTime());
                    if (propertiesDefinition != null) {
                        for (TypeDefAttribute typeDefAttribute : propertiesDefinition) {
                            InstancePropertyValue propertyValue;
                            if (typeDefAttribute == null) continue;
                            String propertyName = typeDefAttribute.getAttributeName();
                            if (!typeDefAttribute.isUnique() || propertyName == null || (propertyValue = entityProperties.getPropertyValue(propertyName)) == null) continue;
                            uniqueAttributes.setProperty(propertyName, propertyValue);
                        }
                    }
                    if (uniqueAttributes.getPropertyCount() > 0 || uniqueAttributes.getEffectiveFromTime() != null || uniqueAttributes.getEffectiveToTime() != null) {
                        entityProxy.setUniqueProperties(uniqueAttributes);
                    }
                }
                return entityProxy;
            }
            catch (TypeErrorException error) {
                throw new RepositoryErrorException(OMRSErrorCode.REPOSITORY_LOGIC_ERROR.getMessageDefinition(new String[]{sourceName, "getNewEntityProxy", error.getReportedErrorMessage()}), ((Object)((Object)this)).getClass().getName(), "getNewEntityProxy");
            }
        }
        return null;
    }

    public EntityProxy getNewEntityProxy(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName, InstanceProperties properties, List<Classification> classifications) throws TypeErrorException {
        EntityProxy entity = this.getSkeletonEntityProxy(sourceName, metadataCollectionId, provenanceType, userName, typeName);
        entity.setUniqueProperties(properties);
        entity.setClassifications(classifications);
        return entity;
    }

    private EntityProxy getSkeletonEntityProxy(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        String methodName = "getSkeletonEntityProxy";
        this.validateRepositoryContentManager("getSkeletonEntityProxy");
        EntityProxy entity = new EntityProxy();
        String guid = UUID.randomUUID().toString();
        entity.setInstanceProvenanceType(provenanceType);
        entity.setMetadataCollectionId(metadataCollectionId);
        entity.setCreateTime(new Date());
        entity.setGUID(guid);
        entity.setVersion(1L);
        entity.setType(this.repositoryContentManager.getInstanceType(sourceName, TypeDefCategory.ENTITY_DEF, typeName, "getSkeletonEntityProxy"));
        entity.setStatus(this.repositoryContentManager.getInitialStatus(sourceName, typeName, "getSkeletonEntityProxy"));
        entity.setCreatedBy(userName);
        entity.setInstanceURL(this.repositoryContentManager.getEntityURL(sourceName, guid));
        return entity;
    }

    public boolean relatedEntity(String sourceName, String entityGUID, Relationship relationship) {
        if (relationship != null) {
            EntityProxy entityOneProxy = relationship.getEntityOneProxy();
            EntityProxy entityTwoProxy = relationship.getEntityTwoProxy();
            if (entityOneProxy != null && entityGUID.equals(entityOneProxy.getGUID())) {
                return true;
            }
            if (entityTwoProxy != null) {
                return entityGUID.equals(entityTwoProxy.getGUID());
            }
        }
        return false;
    }

    public String getTypeName(InstanceAuditHeader instance) throws RepositoryErrorException, InvalidParameterException {
        String methodName = "getTypeName";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null && type.getTypeDefName() != null) {
                return type.getTypeDefName();
            }
            this.throwRepositoryContentError("getTypeName", instance);
        }
        this.throwParameterError("getTypeName");
        return null;
    }

    public String getEnd1EntityGUID(Relationship relationship) {
        EntityProxy entityProxy;
        if (relationship != null && (entityProxy = relationship.getEntityOneProxy()) != null && entityProxy.getGUID() != null) {
            return entityProxy.getGUID();
        }
        return null;
    }

    public String getEnd2EntityGUID(Relationship relationship) {
        EntityProxy entityProxy;
        if (relationship != null && (entityProxy = relationship.getEntityTwoProxy()) != null && entityProxy.getGUID() != null) {
            return entityProxy.getGUID();
        }
        return null;
    }

    public List<EntityDetail> formatEntityResults(List<EntityDetail> fullResults, int fromElement, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws PagingErrorException, PropertyErrorException {
        if (fullResults == null) {
            return null;
        }
        if (fullResults.isEmpty()) {
            return null;
        }
        if (pageSize == 0) {
            return fullResults;
        }
        int fullResultsSize = fullResults.size();
        if (fromElement >= fullResultsSize) {
            return null;
        }
        if (sequencingOrder != null && !sequencingOrder.equals((Object)SequencingOrder.ANY)) {
            if (sequencingOrder.equals((Object)SequencingOrder.PROPERTY_ASCENDING) || sequencingOrder.equals((Object)SequencingOrder.PROPERTY_DESCENDING)) {
                fullResults.sort((one, two) -> OMRSRepositoryContentHelper.compareProperties(one.getProperties(), two.getProperties(), sequencingProperty, sequencingOrder));
            } else {
                fullResults.sort((one, two) -> OMRSRepositoryContentHelper.compareInstances((InstanceHeader)one, (InstanceHeader)two, sequencingOrder));
            }
        }
        if (fromElement == 0 && pageSize > fullResultsSize) {
            return fullResults;
        }
        int toIndex = this.getToIndex(fromElement, pageSize, fullResultsSize);
        return new ArrayList<EntityDetail>(fullResults.subList(fromElement, toIndex));
    }

    public List<Relationship> formatRelationshipResults(List<Relationship> fullResults, int fromElement, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws PagingErrorException, PropertyErrorException {
        if (fullResults == null) {
            return null;
        }
        if (fullResults.isEmpty()) {
            return null;
        }
        int fullResultsSize = fullResults.size();
        if (fromElement >= fullResultsSize) {
            return null;
        }
        if (sequencingOrder != null && !sequencingOrder.equals((Object)SequencingOrder.ANY)) {
            if (sequencingOrder.equals((Object)SequencingOrder.PROPERTY_ASCENDING) || sequencingOrder.equals((Object)SequencingOrder.PROPERTY_DESCENDING)) {
                fullResults.sort((one, two) -> OMRSRepositoryContentHelper.compareProperties(one.getProperties(), two.getProperties(), sequencingProperty, sequencingOrder));
            } else {
                fullResults.sort((one, two) -> OMRSRepositoryContentHelper.compareInstances((InstanceHeader)one, (InstanceHeader)two, sequencingOrder));
            }
        }
        if (fromElement == 0 && (pageSize == 0 || pageSize > fullResultsSize)) {
            return fullResults;
        }
        int toIndex = fullResultsSize;
        if (pageSize != 0) {
            toIndex = this.getToIndex(fromElement, pageSize, fullResultsSize);
        }
        return new ArrayList<Relationship>(fullResults.subList(fromElement, toIndex));
    }

    private static int compareInstances(InstanceHeader one, InstanceHeader two, SequencingOrder sequencingOrder) {
        int sortResult;
        if (one == null && two == null) {
            sortResult = 0;
        } else if (one != null && two == null) {
            sortResult = 1;
        } else if (one == null) {
            sortResult = -1;
        } else {
            switch (sequencingOrder) {
                case GUID: {
                    String guidOne = one.getGUID();
                    String guidTwo = two.getGUID();
                    if (guidOne == null && guidTwo == null) {
                        sortResult = 0;
                        break;
                    }
                    if (guidOne != null && guidTwo == null) {
                        sortResult = 1;
                        break;
                    }
                    if (guidOne == null) {
                        sortResult = -1;
                        break;
                    }
                    sortResult = guidOne.compareTo(guidTwo);
                    break;
                }
                case LAST_UPDATE_RECENT: 
                case LAST_UPDATE_OLDEST: {
                    Date updateOne = one.getUpdateTime();
                    Date updateTwo = two.getUpdateTime();
                    sortResult = updateOne == null && updateTwo == null ? 0 : (updateOne != null && updateTwo == null ? 1 : (updateOne == null ? -1 : updateOne.compareTo(updateTwo)));
                    if (!sequencingOrder.equals((Object)SequencingOrder.LAST_UPDATE_RECENT)) break;
                    sortResult = -sortResult;
                    break;
                }
                case CREATION_DATE_RECENT: 
                case CREATION_DATE_OLDEST: {
                    Date createOne = one.getCreateTime();
                    Date createTwo = two.getCreateTime();
                    sortResult = createOne == null && createTwo == null ? 0 : (createOne != null && createTwo == null ? 1 : (createOne == null ? -1 : createOne.compareTo(createTwo)));
                    if (!sequencingOrder.equals((Object)SequencingOrder.CREATION_DATE_RECENT)) break;
                    sortResult = -sortResult;
                    break;
                }
                default: {
                    sortResult = 0;
                }
            }
        }
        return sortResult;
    }

    private static int compareProperties(InstanceProperties instance1Properties, InstanceProperties instance2Properties, String propertyName, SequencingOrder sequencingOrder) {
        InstancePropertyCategory o2PropCat;
        InstancePropertyValue o2PropValue;
        InstancePropertyCategory o1PropCat;
        InstancePropertyValue o1PropValue;
        String o1PropertyTypeName = null;
        String o2PropertyTypeName = null;
        Object o1PropertyValue = null;
        Object o2PropertyValue = null;
        if (instance1Properties != null && (o1PropValue = instance1Properties.getPropertyValue(propertyName)) != null && (o1PropCat = o1PropValue.getInstancePropertyCategory()) == InstancePropertyCategory.PRIMITIVE) {
            o1PropertyTypeName = o1PropValue.getTypeName();
            o1PropertyValue = ((PrimitivePropertyValue)o1PropValue).getPrimitiveValue();
        }
        if (instance2Properties != null && (o2PropValue = instance2Properties.getPropertyValue(propertyName)) != null && (o2PropCat = o2PropValue.getInstancePropertyCategory()) == InstancePropertyCategory.PRIMITIVE) {
            o2PropertyTypeName = o2PropValue.getTypeName();
            o2PropertyValue = ((PrimitivePropertyValue)o2PropValue).getPrimitiveValue();
        }
        int sortResult = o1PropertyTypeName == null && o2PropertyTypeName == null ? 0 : (o1PropertyTypeName != null && o2PropertyTypeName == null ? 1 : (o1PropertyTypeName == null ? -1 : (!o1PropertyTypeName.equals(o2PropertyTypeName) ? 0 : OMRSRepositoryContentHelper.typeSpecificCompare(o1PropertyTypeName, o1PropertyValue, o2PropertyValue))));
        if (sequencingOrder == SequencingOrder.PROPERTY_DESCENDING) {
            sortResult *= -1;
        }
        return sortResult;
    }

    private static int typeSpecificCompare(String typeName, Object v1, Object v2) {
        return switch (typeName) {
            case "boolean" -> ((Boolean)v1).compareTo((Boolean)v2);
            case "byte" -> ((Byte)v1).compareTo((Byte)v2);
            case "char" -> ((Character)v1).compareTo((Character)v2);
            case "short" -> ((Short)v1).compareTo((Short)v2);
            case "integer" -> ((Integer)v1).compareTo((Integer)v2);
            case "long" -> ((Long)v1).compareTo((Long)v2);
            case "float" -> ((Float)v1).compareTo((Float)v2);
            case "double" -> ((Double)v1).compareTo((Double)v2);
            case "biginteger" -> ((BigInteger)v1).compareTo((BigInteger)v2);
            case "bigdecimal" -> ((BigDecimal)v1).compareTo((BigDecimal)v2);
            case "string" -> ((String)v1).compareTo((String)v2);
            case "date" -> ((Date)v1).compareTo((Date)v2);
            default -> {
                log.debug("Property type not catered for in compare function");
                yield 0;
            }
        };
    }

    private String setInsensitive(String searchString, boolean insensitive) {
        return insensitive ? "(?i)" + searchString : searchString;
    }

    public String getExactMatchRegex(String searchString) {
        return this.getExactMatchRegex(searchString, false);
    }

    public String getExactMatchRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(Pattern.quote(searchString), insensitive);
    }

    private boolean isCaseSensitiveExactMatchRegex(String searchString) {
        return searchString == null || searchString.startsWith("\\Q") && searchString.endsWith("\\E") && searchString.indexOf("\\E") == searchString.length() - 2;
    }

    private boolean isCaseInsensitiveExactMatchRegex(String searchString) {
        return searchString == null || this.isCaseInsensitiveRegex(searchString) && this.isCaseSensitiveExactMatchRegex(searchString.substring(4));
    }

    public boolean isExactMatchRegex(String searchString) {
        return this.isCaseSensitiveExactMatchRegex(searchString) || this.isCaseInsensitiveExactMatchRegex(searchString);
    }

    public boolean isExactMatchRegex(String searchString, boolean insensitive) {
        return insensitive ? this.isCaseInsensitiveExactMatchRegex(searchString) : this.isCaseSensitiveExactMatchRegex(searchString);
    }

    public String getContainsRegex(String searchString) {
        return this.getContainsRegex(searchString, false);
    }

    public String getContainsRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(".*" + this.getExactMatchRegex(searchString) + ".*", insensitive);
    }

    private boolean isCaseSensitiveContainsRegex(String searchString) {
        return searchString != null && searchString.length() > 4 && searchString.startsWith(".*") && searchString.endsWith(".*") && this.isCaseSensitiveExactMatchRegex(searchString.substring(2, searchString.length() - 2));
    }

    private boolean isCaseInsensitiveContainsRegex(String searchString) {
        return searchString != null && this.isCaseInsensitiveRegex(searchString) && this.isCaseSensitiveContainsRegex(searchString.substring(4));
    }

    public boolean isContainsRegex(String searchString) {
        return this.isCaseSensitiveContainsRegex(searchString) || this.isCaseInsensitiveContainsRegex(searchString);
    }

    public boolean isContainsRegex(String searchString, boolean insensitive) {
        return insensitive ? this.isCaseInsensitiveContainsRegex(searchString) : this.isCaseSensitiveContainsRegex(searchString);
    }

    public String getStartsWithRegex(String searchString) {
        return this.getStartsWithRegex(searchString, false);
    }

    public String getStartsWithRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(this.getExactMatchRegex(searchString) + ".*", insensitive);
    }

    private boolean isCaseSensitiveStartsWithRegex(String searchString) {
        return searchString != null && searchString.endsWith(".*") && this.isCaseSensitiveExactMatchRegex(searchString.substring(0, searchString.length() - 2));
    }

    private boolean isCaseInsensitiveStartsWithRegex(String searchString) {
        return searchString != null && this.isCaseInsensitiveRegex(searchString) && this.isCaseSensitiveStartsWithRegex(searchString.substring(4));
    }

    public boolean isStartsWithRegex(String searchString) {
        return this.isCaseSensitiveStartsWithRegex(searchString) || this.isCaseInsensitiveStartsWithRegex(searchString);
    }

    public boolean isStartsWithRegex(String searchString, boolean insensitive) {
        return insensitive ? this.isCaseInsensitiveStartsWithRegex(searchString) : this.isCaseSensitiveStartsWithRegex(searchString);
    }

    public String getEndsWithRegex(String searchString) {
        return this.getEndsWithRegex(searchString, false);
    }

    public String getEndsWithRegex(String searchString, boolean insensitive) {
        return searchString == null ? null : this.setInsensitive(".*" + this.getExactMatchRegex(searchString), insensitive);
    }

    private boolean isCaseSensitiveEndsWithRegex(String searchString) {
        return searchString != null && searchString.startsWith(".*") && this.isCaseSensitiveExactMatchRegex(searchString.substring(2));
    }

    private boolean isCaseInsensitiveEndsWithRegex(String searchString) {
        return searchString != null && this.isCaseInsensitiveRegex(searchString) && this.isCaseSensitiveEndsWithRegex(searchString.substring(4));
    }

    public boolean isEndsWithRegex(String searchString) {
        return this.isCaseSensitiveEndsWithRegex(searchString) || this.isCaseInsensitiveEndsWithRegex(searchString);
    }

    public boolean isEndsWithRegex(String searchString, boolean insensitive) {
        return insensitive ? this.isCaseInsensitiveEndsWithRegex(searchString) : this.isCaseSensitiveEndsWithRegex(searchString);
    }

    public String getUnqualifiedLiteralString(String searchString) {
        if (searchString == null) {
            return null;
        }
        String limited = searchString;
        if (this.isCaseInsensitiveRegex(searchString)) {
            limited = searchString.substring(4);
        }
        if (this.isCaseSensitiveExactMatchRegex(limited)) {
            return limited.substring(2, limited.length() - 2);
        }
        if (this.isCaseSensitiveStartsWithRegex(limited)) {
            return limited.substring(2, limited.length() - 4);
        }
        if (this.isCaseSensitiveEndsWithRegex(limited)) {
            return limited.substring(4, limited.length() - 2);
        }
        if (this.isCaseSensitiveContainsRegex(limited)) {
            return limited.substring(4, limited.length() - 4);
        }
        return limited;
    }

    public boolean isCaseInsensitiveRegex(String searchString) {
        return searchString != null && searchString.startsWith("(?i)");
    }

    public RelationshipDifferences getRelationshipDifferences(Relationship left, Relationship right, boolean ignoreModificationStamps) {
        RelationshipDifferences differences = new RelationshipDifferences();
        this.getInstanceHeaderDifferences((Differences)differences, (InstanceHeader)left, (InstanceHeader)right, ignoreModificationStamps);
        Differences.SidePresent present = this.checkDifferenceNulls((InstanceAuditHeader)left, (InstanceAuditHeader)right);
        EntityProxyDifferences one = null;
        EntityProxyDifferences two = null;
        if (present.equals((Object)Differences.SidePresent.BOTH) && !left.equals((Object)right)) {
            differences.checkInstanceProperties(left.getProperties(), right.getProperties());
            one = this.getEntityProxyDifferences(left.getEntityOneProxy(), right.getEntityOneProxy(), ignoreModificationStamps);
            two = this.getEntityProxyDifferences(left.getEntityTwoProxy(), right.getEntityTwoProxy(), ignoreModificationStamps);
        } else if (present.equals((Object)Differences.SidePresent.LEFT_ONLY)) {
            differences.checkInstanceProperties(left.getProperties(), null);
            one = this.getEntityProxyDifferences(left.getEntityOneProxy(), null, ignoreModificationStamps);
            two = this.getEntityProxyDifferences(left.getEntityTwoProxy(), null, ignoreModificationStamps);
        } else if (present.equals((Object)Differences.SidePresent.RIGHT_ONLY)) {
            differences.checkInstanceProperties(null, right.getProperties());
            one = this.getEntityProxyDifferences(null, right.getEntityOneProxy(), ignoreModificationStamps);
            two = this.getEntityProxyDifferences(null, right.getEntityTwoProxy(), ignoreModificationStamps);
        }
        differences.setEntityProxyOneDifferences(one);
        differences.setEntityProxyTwoDifferences(two);
        return differences;
    }

    public EntityDetailDifferences getEntityDetailDifferences(EntityDetail left, EntityDetail right, boolean ignoreModificationStamps) {
        EntityDetailDifferences differences = new EntityDetailDifferences();
        this.getEntitySummaryDifferences((EntitySummaryDifferences)differences, (EntitySummary)left, (EntitySummary)right, ignoreModificationStamps);
        Differences.SidePresent present = this.checkDifferenceNulls((InstanceAuditHeader)left, (InstanceAuditHeader)right);
        if (present.equals((Object)Differences.SidePresent.BOTH) && !left.equals((Object)right)) {
            differences.checkInstanceProperties(left.getProperties(), right.getProperties());
        } else if (present.equals((Object)Differences.SidePresent.LEFT_ONLY)) {
            differences.checkInstanceProperties(left.getProperties(), null);
        } else if (present.equals((Object)Differences.SidePresent.RIGHT_ONLY)) {
            differences.checkInstanceProperties(null, right.getProperties());
        }
        return differences;
    }

    public EntityProxyDifferences getEntityProxyDifferences(EntityProxy left, EntityProxy right, boolean ignoreModificationStamps) {
        EntityProxyDifferences differences = new EntityProxyDifferences();
        this.getEntitySummaryDifferences((EntitySummaryDifferences)differences, (EntitySummary)left, (EntitySummary)right, ignoreModificationStamps);
        Differences.SidePresent present = this.checkDifferenceNulls((InstanceAuditHeader)left, (InstanceAuditHeader)right);
        if (present.equals((Object)Differences.SidePresent.BOTH) && !left.equals((Object)right)) {
            differences.checkUniqueProperties(left.getUniqueProperties(), right.getUniqueProperties());
        } else if (present.equals((Object)Differences.SidePresent.LEFT_ONLY)) {
            differences.checkUniqueProperties(left.getUniqueProperties(), null);
        } else if (present.equals((Object)Differences.SidePresent.RIGHT_ONLY)) {
            differences.checkUniqueProperties(null, right.getUniqueProperties());
        }
        return differences;
    }

    public EntitySummaryDifferences getEntitySummaryDifferences(EntitySummary left, EntitySummary right, boolean ignoreModificationStamps) {
        EntitySummaryDifferences differences = new EntitySummaryDifferences();
        this.getEntitySummaryDifferences(differences, left, right, ignoreModificationStamps);
        return differences;
    }

    public SearchClassifications getSearchClassificationsFromList(List<String> classificationNames) {
        SearchClassifications sc = null;
        if (classificationNames != null) {
            sc = new SearchClassifications();
            sc.setMatchCriteria(MatchCriteria.ALL);
            ArrayList<ClassificationCondition> conditions = new ArrayList<ClassificationCondition>();
            for (String classificationName : classificationNames) {
                ClassificationCondition cc = new ClassificationCondition();
                cc.setName(classificationName);
                conditions.add(cc);
            }
            sc.setConditions(conditions);
        }
        return sc;
    }

    private void getEntitySummaryDifferences(EntitySummaryDifferences differences, EntitySummary left, EntitySummary right, boolean ignoreModificationStamps) {
        this.getInstanceHeaderDifferences((Differences)differences, (InstanceHeader)left, (InstanceHeader)right, ignoreModificationStamps);
        differences.checkClassifications(left, right);
    }

    private void getInstanceHeaderDifferences(Differences differences, InstanceHeader left, InstanceHeader right, boolean ignoreModificationStamps) {
        this.getInstanceAuditHeaderDifferences(differences, (InstanceAuditHeader)left, (InstanceAuditHeader)right, ignoreModificationStamps);
        Differences.SidePresent present = this.checkDifferenceNulls((InstanceAuditHeader)left, (InstanceAuditHeader)right);
        if (present.equals((Object)Differences.SidePresent.BOTH) && !left.equals((Object)right)) {
            differences.check("GUID", (Object)left.getGUID(), (Object)right.getGUID());
            differences.check("InstanceURL", (Object)left.getInstanceURL(), (Object)right.getInstanceURL());
        } else if (!present.equals((Object)Differences.SidePresent.NEITHER) && !present.equals((Object)Differences.SidePresent.BOTH)) {
            InstanceHeader sideWithValues = present.equals((Object)Differences.SidePresent.LEFT_ONLY) ? left : right;
            differences.addOnlyOnOneSide(present, "GUID", (Object)sideWithValues.getGUID());
            differences.addOnlyOnOneSide(present, "Type", (Object)sideWithValues.getInstanceURL());
        }
    }

    private void getInstanceAuditHeaderDifferences(Differences differences, InstanceAuditHeader left, InstanceAuditHeader right, boolean ignoreModificationStamps) {
        Differences.SidePresent present = this.checkDifferenceNulls(left, right);
        if (present.equals((Object)Differences.SidePresent.BOTH) && !left.equals((Object)right)) {
            if (!ignoreModificationStamps) {
                differences.check("Version", (Object)left.getVersion(), (Object)right.getVersion());
                differences.check("UpdatedBy", (Object)left.getUpdatedBy(), (Object)right.getUpdatedBy());
                differences.check("UpdateTime", (Object)left.getUpdateTime(), (Object)right.getUpdateTime());
            }
            differences.check("Type", (Object)left.getType(), (Object)right.getType());
            differences.check("InstanceProvenanceType", (Object)left.getInstanceProvenanceType(), (Object)right.getInstanceProvenanceType());
            differences.check("MetadataCollectionId", (Object)left.getMetadataCollectionId(), (Object)right.getMetadataCollectionId());
            differences.check("ReplicatedBy", (Object)left.getReplicatedBy(), (Object)right.getReplicatedBy());
            differences.check("InstanceLicense", (Object)left.getInstanceLicense(), (Object)right.getInstanceLicense());
            differences.check("CreatedBy", (Object)left.getCreatedBy(), (Object)right.getCreatedBy());
            differences.check("MaintainedBy", (Object)left.getMaintainedBy(), (Object)right.getMaintainedBy());
            differences.check("CreateTime", (Object)left.getCreateTime(), (Object)right.getCreateTime());
            differences.check("Status", (Object)left.getStatus(), (Object)right.getStatus());
            differences.check("StatusOnDelete", (Object)left.getStatusOnDelete(), (Object)right.getStatusOnDelete());
            differences.check("MappingProperties", (Object)left.getMappingProperties(), (Object)right.getMappingProperties());
        } else if (!present.equals((Object)Differences.SidePresent.NEITHER) && !present.equals((Object)Differences.SidePresent.BOTH)) {
            InstanceAuditHeader sideWithValues = present.equals((Object)Differences.SidePresent.LEFT_ONLY) ? left : right;
            if (!ignoreModificationStamps) {
                differences.addOnlyOnOneSide(present, "Version", (Object)sideWithValues.getVersion());
                differences.addOnlyOnOneSide(present, "UpdatedBy", (Object)sideWithValues.getUpdatedBy());
                differences.addOnlyOnOneSide(present, "UpdateTime", (Object)sideWithValues.getUpdateTime());
            }
            differences.addOnlyOnOneSide(present, "Type", (Object)sideWithValues.getType());
            differences.addOnlyOnOneSide(present, "InstanceProvenanceType", (Object)sideWithValues.getInstanceProvenanceType());
            differences.addOnlyOnOneSide(present, "MetadataCollectionId", (Object)sideWithValues.getMetadataCollectionId());
            differences.addOnlyOnOneSide(present, "ReplicatedBy", (Object)sideWithValues.getReplicatedBy());
            differences.addOnlyOnOneSide(present, "InstanceLicense", (Object)sideWithValues.getInstanceLicense());
            differences.addOnlyOnOneSide(present, "CreatedBy", (Object)sideWithValues.getCreatedBy());
            differences.addOnlyOnOneSide(present, "MaintainedBy", (Object)sideWithValues.getMaintainedBy());
            differences.addOnlyOnOneSide(present, "CreateTime", (Object)sideWithValues.getCreateTime());
            differences.addOnlyOnOneSide(present, "Status", (Object)sideWithValues.getStatus());
            differences.addOnlyOnOneSide(present, "StatusOnDelete", (Object)sideWithValues.getStatusOnDelete());
            differences.addOnlyOnOneSide(present, "MappingProperties", (Object)sideWithValues.getMappingProperties());
        }
    }

    private Differences.SidePresent checkDifferenceNulls(InstanceAuditHeader left, InstanceAuditHeader right) {
        Differences.SidePresent present = left == null && right == null ? Differences.SidePresent.NEITHER : (right == null ? Differences.SidePresent.LEFT_ONLY : (left == null ? Differences.SidePresent.RIGHT_ONLY : Differences.SidePresent.BOTH));
        return present;
    }

    private int getToIndex(int fromIndex, int pageSize, int totalSize) {
        int toIndex = totalSize < fromIndex + pageSize ? totalSize : fromIndex + pageSize;
        return toIndex;
    }

    private void throwParameterError(String methodName) throws InvalidParameterException {
        throw new InvalidParameterException(OMRSErrorCode.NULL_PARAMETER.getMessageDefinition(new String[]{methodName}), ((Object)((Object)this)).getClass().getName(), methodName, "instance");
    }

    private void throwRepositoryContentError(String methodName, InstanceAuditHeader instance) throws RepositoryErrorException {
        throw new RepositoryErrorException(OMRSErrorCode.INVALID_INSTANCE.getMessageDefinition(new String[]{methodName, instance.toString()}), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    private void validateRepositoryContentManager(String methodName) {
        if (this.repositoryContentManager == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.LOCAL_REPOSITORY_CONFIGURATION_ERROR.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), methodName);
        }
    }
}

