/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorConsumer;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorManager;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.OMRSInstanceRetrievalEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseOMRSRepositoryConnector
extends OMRSRepositoryConnector
implements OMRSConnectorConsumer {
    private final OMRSConnectorManager connectorManager;
    private String connectorConsumerId;
    private LocalOMRSRepositoryConnector localConnector = null;
    private OMRSInstanceRetrievalEventProcessor localEventProcessor = null;
    private String localMetadataCollectionId = null;
    private List<FederatedConnector> remoteCohortConnectors = new ArrayList<FederatedConnector>();
    private String callingServiceName = null;
    private static final Logger log = LoggerFactory.getLogger(EnterpriseOMRSRepositoryConnector.class);

    EnterpriseOMRSRepositoryConnector(OMRSConnectorManager connectorManager) {
        this.connectorManager = connectorManager;
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
        if (metadataCollectionId != null) {
            this.metadataCollection = new EnterpriseOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, metadataCollectionId, this.localMetadataCollectionId, this.auditLog);
        }
    }

    public void setLocalMetadataCollectionId(String localMetadataCollectionId) {
        this.localMetadataCollectionId = localMetadataCollectionId;
    }

    public void setCallingServiceName(String callingServiceName) {
        this.callingServiceName = callingServiceName;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        if (this.auditLog != null) {
            String actionDescription = "start";
            this.auditLog.logMessage("start", OMRSAuditCode.STARTING_ENTERPRISE_CONNECTOR.getMessageDefinition(new String[]{this.callingServiceName}));
        }
        if (this.connectorManager == null) {
            String methodName = "start";
            throw new OMRSRuntimeException(OMRSErrorCode.INVALID_COHORT_CONFIG.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        this.connectorConsumerId = this.connectorManager.registerConnectorConsumer(this);
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        if (this.auditLog != null) {
            String actionDescription = "disconnect";
            this.auditLog.logMessage("disconnect", OMRSAuditCode.DISCONNECTING_ENTERPRISE_CONNECTOR.getMessageDefinition(new String[]{this.callingServiceName}));
        }
        if (this.connectorManager != null && this.connectorConsumerId != null) {
            this.connectorManager.unregisterConnectorConsumer(this.connectorConsumerId);
        }
        this.localConnector = null;
        this.remoteCohortConnectors = new ArrayList<FederatedConnector>();
    }

    synchronized OMRSMetadataCollection getHomeMetadataCollection(Classification instance, String methodName) throws RepositoryErrorException {
        OMRSRepositoryConnector repositoryConnector = this.getHomeConnector(instance, methodName);
        if (repositoryConnector != null) {
            return repositoryConnector.getMetadataCollection();
        }
        throw new RepositoryErrorException(OMRSErrorCode.NO_HOME_FOR_CLASSIFICATION.getMessageDefinition(new String[]{methodName, instance.getName(), instance.getMetadataCollectionId()}), this.getClass().getName(), methodName);
    }

    synchronized OMRSMetadataCollection getHomeMetadataCollection(InstanceHeader instance, String methodName) throws RepositoryErrorException {
        OMRSRepositoryConnector repositoryConnector = this.getHomeConnector(instance, methodName);
        if (repositoryConnector != null) {
            return repositoryConnector.getMetadataCollection();
        }
        throw new RepositoryErrorException(OMRSErrorCode.NO_HOME_FOR_INSTANCE.getMessageDefinition(new String[]{methodName, instance.getGUID(), instance.getMetadataCollectionId()}), this.getClass().getName(), methodName);
    }

    private OMRSRepositoryConnector getHomeConnector(Classification classification, String methodName) throws RepositoryErrorException {
        this.validateRepositoryIsActive(methodName);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, classification, methodName);
        String instanceMetadataCollectionId = classification.getMetadataCollectionId();
        if (this.localMetadataCollectionId != null) {
            if (this.localMetadataCollectionId.equals(instanceMetadataCollectionId)) {
                return this.localConnector;
            }
            if (classification.getReplicatedBy() != null && this.localMetadataCollectionId.equals(classification.getReplicatedBy())) {
                return this.localConnector;
            }
        }
        for (FederatedConnector remoteCohortConnector : this.remoteCohortConnectors) {
            String remoteMetadataCollectionId;
            if (remoteCohortConnector == null || (remoteMetadataCollectionId = remoteCohortConnector.getMetadataCollectionId()) == null) continue;
            if (remoteMetadataCollectionId.equals(instanceMetadataCollectionId)) {
                return remoteCohortConnector.getConnector();
            }
            if (!remoteMetadataCollectionId.equals(classification.getReplicatedBy())) continue;
            return remoteCohortConnector.getConnector();
        }
        throw new RepositoryErrorException(OMRSErrorCode.NO_HOME_FOR_INSTANCE.getMessageDefinition(new String[]{methodName, classification.getName(), instanceMetadataCollectionId}), this.getClass().getName(), methodName);
    }

    private OMRSRepositoryConnector getHomeConnector(InstanceHeader instance, String methodName) throws RepositoryErrorException {
        this.validateRepositoryIsActive(methodName);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, instance, methodName);
        String instanceMetadataCollectionId = instance.getMetadataCollectionId();
        if (this.localMetadataCollectionId != null) {
            if (this.localMetadataCollectionId.equals(instanceMetadataCollectionId)) {
                return this.localConnector;
            }
            if (instance.getReplicatedBy() != null && this.localMetadataCollectionId.equals(instance.getReplicatedBy())) {
                return this.localConnector;
            }
        }
        for (FederatedConnector remoteCohortConnector : this.remoteCohortConnectors) {
            String remoteMetadataCollectionId;
            if (remoteCohortConnector == null || (remoteMetadataCollectionId = remoteCohortConnector.getMetadataCollectionId()) == null) continue;
            if (remoteMetadataCollectionId.equals(instanceMetadataCollectionId)) {
                return remoteCohortConnector.getConnector();
            }
            if (!remoteMetadataCollectionId.equals(instance.getReplicatedBy())) continue;
            return remoteCohortConnector.getConnector();
        }
        throw new RepositoryErrorException(OMRSErrorCode.NO_HOME_FOR_INSTANCE.getMessageDefinition(new String[]{methodName, instance.getGUID(), instanceMetadataCollectionId}), this.getClass().getName(), methodName);
    }

    synchronized List<OMRSRepositoryConnector> getHomeLocalRemoteConnectors(InstanceHeader instance, String methodName) throws RepositoryErrorException {
        this.validateRepositoryIsActive(methodName);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, instance, methodName);
        String instanceMetadataCollectionId = instance.getMetadataCollectionId();
        ArrayList<OMRSRepositoryConnector> remoteHomeRepository = new ArrayList<OMRSRepositoryConnector>();
        ArrayList<OMRSRepositoryConnector> otherRemoteRepositories = new ArrayList<OMRSRepositoryConnector>();
        for (FederatedConnector remoteCohortConnector : this.remoteCohortConnectors) {
            String remoteMetadataCollectionId;
            if (remoteCohortConnector == null || (remoteMetadataCollectionId = remoteCohortConnector.getMetadataCollectionId()) == null) continue;
            if (remoteMetadataCollectionId.equals(instanceMetadataCollectionId)) {
                remoteHomeRepository.add(remoteCohortConnector.getConnector());
                continue;
            }
            if (remoteMetadataCollectionId.equals(instance.getReplicatedBy())) {
                remoteHomeRepository.add(remoteCohortConnector.getConnector());
                continue;
            }
            otherRemoteRepositories.add(remoteCohortConnector.getConnector());
        }
        ArrayList<OMRSRepositoryConnector> resultList = remoteHomeRepository;
        if (this.localMetadataCollectionId != null) {
            resultList.add(this.localConnector);
        }
        resultList.addAll(otherRemoteRepositories);
        if (!resultList.isEmpty()) {
            return resultList;
        }
        throw new RepositoryErrorException(OMRSErrorCode.NO_REPOSITORIES.getMessageDefinition(new String[]{this.callingServiceName}), this.getClass().getName(), methodName);
    }

    private FederatedConnector getFederatedConnector(String metadataCollectionId) {
        for (FederatedConnector remoteCohortConnector : this.remoteCohortConnectors) {
            String remoteMetadataCollectionId;
            if (remoteCohortConnector == null || (remoteMetadataCollectionId = remoteCohortConnector.getMetadataCollectionId()) == null || !remoteMetadataCollectionId.equals(metadataCollectionId)) continue;
            return remoteCohortConnector;
        }
        return null;
    }

    synchronized List<OMRSRepositoryConnector> getCohortConnectors(String methodName) throws RepositoryErrorException {
        this.validateRepositoryIsActive(methodName);
        ArrayList<OMRSRepositoryConnector> cohortConnectors = new ArrayList<OMRSRepositoryConnector>();
        if (this.localConnector != null) {
            cohortConnectors.add(this.localConnector);
        }
        for (FederatedConnector federatedConnector : this.remoteCohortConnectors) {
            cohortConnectors.add(federatedConnector.getConnector());
        }
        if (!cohortConnectors.isEmpty()) {
            return cohortConnectors;
        }
        throw new RepositoryErrorException(OMRSErrorCode.NO_REPOSITORIES.getMessageDefinition(new String[]{this.callingServiceName}), this.getClass().getName(), methodName);
    }

    public void requestRefreshOfEntity(EntityDetail entity) {
        if (this.localEventProcessor != null && entity != null && !this.localMetadataCollectionId.equals(entity.getMetadataCollectionId())) {
            this.localEventProcessor.processRetrievedEntityDetail(this.repositoryName, this.localMetadataCollectionId, entity);
        }
    }

    public void requestRefreshOfRelationship(Relationship relationship) {
        if (this.localEventProcessor != null && relationship != null) {
            this.localEventProcessor.processRetrievedRelationship(this.repositoryName, this.localMetadataCollectionId, relationship);
        }
    }

    @Override
    public synchronized void setLocalConnector(String metadataCollectionId, LocalOMRSRepositoryConnector localConnector) {
        this.localMetadataCollectionId = metadataCollectionId;
        this.localConnector = localConnector;
        if (localConnector != null) {
            this.localEventProcessor = localConnector.getIncomingInstanceRetrievalEventProcessor();
        }
    }

    @Override
    public synchronized void addRemoteConnector(String metadataCollectionId, OMRSRepositoryConnector remoteConnector) {
        if (remoteConnector != null) {
            FederatedConnector federatedConnector = this.getFederatedConnector(metadataCollectionId);
            if (federatedConnector == null) {
                this.remoteCohortConnectors.add(new FederatedConnector(metadataCollectionId, remoteConnector));
                if (this.auditLog != null) {
                    String actionDescription = "Processing incoming registration request from remote cohort member";
                    this.auditLog.logMessage("Processing incoming registration request from remote cohort member", OMRSAuditCode.NEW_REMOTE_MEMBER_DEPLOYED.getMessageDefinition(new String[]{remoteConnector.getServerName(), metadataCollectionId, this.callingServiceName}));
                }
            } else {
                federatedConnector.refresh(metadataCollectionId, remoteConnector);
                if (this.auditLog != null) {
                    String actionDescription = "Processing incoming registration request from remote cohort member";
                    this.auditLog.logMessage("Processing incoming registration request from remote cohort member", OMRSAuditCode.REMOTE_MEMBER_DEPLOY_REFRESH.getMessageDefinition(new String[]{remoteConnector.getServerName(), metadataCollectionId, this.callingServiceName}));
                }
            }
        }
    }

    @Override
    public synchronized void removeRemoteConnector(String metadataCollectionId) {
        Iterator<FederatedConnector> iterator = this.remoteCohortConnectors.iterator();
        while (iterator.hasNext()) {
            FederatedConnector registeredConnector = iterator.next();
            if (!registeredConnector.getMetadataCollectionId().equals(metadataCollectionId)) continue;
            this.disconnectConnector(registeredConnector);
            iterator.remove();
        }
        if (this.auditLog != null) {
            String actionDescription = "Processing incoming registration request from remote cohort member";
            this.auditLog.logMessage("Processing incoming registration request from remote cohort member", OMRSAuditCode.REMOTE_MEMBER_UNDEPLOYED.getMessageDefinition(new String[]{metadataCollectionId, this.callingServiceName}));
        }
    }

    @Override
    public synchronized void disconnectAllConnectors() {
        try {
            super.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.remoteCohortConnectors != null) {
            for (FederatedConnector remoteConnector : this.remoteCohortConnectors) {
                if (remoteConnector == null) continue;
                this.disconnectConnector(remoteConnector);
            }
        }
    }

    private void disconnectConnector(OMRSRepositoryConnector connector) {
        if (connector != null) {
            try {
                connector.disconnect();
            }
            catch (Exception error) {
                log.error("Exception from disconnect of connector to metadata collection:" + connector.getMetadataCollectionId() + "  Error message was: " + error.getMessage());
            }
        }
    }

    private void disconnectConnector(FederatedConnector federatedConnector) {
        OMRSRepositoryConnector connector = null;
        if (federatedConnector != null) {
            connector = federatedConnector.getConnector();
        }
        if (connector != null) {
            this.disconnectConnector(connector);
        }
    }

    private static class FederatedConnector {
        private String metadataCollectionId;
        private OMRSRepositoryConnector connector;

        FederatedConnector(String metadataCollectionId, OMRSRepositoryConnector connector) {
            this.metadataCollectionId = metadataCollectionId;
            this.connector = connector;
        }

        void refresh(String metadataCollectionId, OMRSRepositoryConnector connector) {
            this.metadataCollectionId = metadataCollectionId;
            this.connector = connector;
        }

        public String getMetadataCollectionId() {
            return this.metadataCollectionId;
        }

        public OMRSRepositoryConnector getConnector() {
            return this.connector;
        }

        public OMRSMetadataCollection getMetadataCollection() {
            if (this.connector != null) {
                try {
                    return this.connector.getMetadataCollection();
                }
                catch (Exception error) {
                    return null;
                }
            }
            return null;
        }
    }
}

