/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.RelationshipHistoryAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PageableRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetRelationshipHistoryExecutor
extends PageableRepositoryExecutorBase {
    private final String guid;
    private final Date fromTime;
    private final Date toTime;
    private final HistorySequencingOrder historySequencingOrder;
    private RelationshipHistoryAccumulator historyAccumulator;

    public GetRelationshipHistoryExecutor(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder, String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator, String methodName) {
        this(userId, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder, new RelationshipHistoryAccumulator(localMetadataCollectionId, auditLog, repositoryValidator), methodName);
    }

    private GetRelationshipHistoryExecutor(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder, RelationshipHistoryAccumulator accumulator, String methodName) {
        super(userId, null, startFromElement, null, null, null, pageSize, null, accumulator, methodName);
        this.guid = guid;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.historySequencingOrder = sequencingOrder;
        this.historyAccumulator = accumulator;
    }

    @Override
    public CloneableRepositoryExecutor getClone() {
        return new GetRelationshipHistoryExecutor(this.userId, this.guid, this.fromTime, this.toTime, this.startingElement, this.pageSize, this.historySequencingOrder, this.historyAccumulator, this.methodName);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            List results = metadataCollection.getRelationshipHistory(this.userId, this.guid, this.fromTime, this.toTime, this.startingElement, this.pageSize, this.historySequencingOrder);
            this.historyAccumulator.addRelationships(results, metadataCollectionId);
        }
        catch (InvalidParameterException error) {
            this.historyAccumulator.captureException(metadataCollectionId, error);
        }
        catch (FunctionNotSupportedException error) {
            this.historyAccumulator.captureException(metadataCollectionId, error);
        }
        catch (RepositoryErrorException error) {
            this.historyAccumulator.captureException(metadataCollectionId, error);
        }
        catch (UserNotAuthorizedException error) {
            this.historyAccumulator.captureException(metadataCollectionId, error);
        }
        catch (RelationshipNotKnownException error) {
            this.historyAccumulator.captureException(metadataCollectionId, error);
        }
        catch (Exception error) {
            this.historyAccumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public List<Relationship> getHistoryResults(EnterpriseOMRSRepositoryConnector repositoryConnector) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.historyAccumulator.resultsReturned()) {
            return this.historyAccumulator.getResults(repositoryConnector);
        }
        this.historyAccumulator.throwCapturedUserNotAuthorizedException();
        this.historyAccumulator.throwCapturedRepositoryErrorException();
        this.historyAccumulator.throwCapturedRelationshipNotKnownException();
        this.historyAccumulator.throwCapturedGenericException(this.methodName);
        this.historyAccumulator.throwCapturedInvalidParameterException();
        this.historyAccumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

