/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.ClassificationAccumulator;

public class EntitySummaryAccumulator
extends ClassificationAccumulator {
    private volatile EntitySummary currentSavedEntity = null;

    public EntitySummaryAccumulator(AuditLog auditLog) {
        super(auditLog);
    }

    public synchronized void addEntity(EntitySummary incomingEntity, String metadataCollectionId) {
        if (incomingEntity != null && incomingEntity.getGUID() != null) {
            if (metadataCollectionId.equals(incomingEntity.getMetadataCollectionId())) {
                this.currentSavedEntity = incomingEntity;
                super.setInPhaseOne(false);
            } else if (this.currentSavedEntity == null) {
                this.currentSavedEntity = incomingEntity;
            } else if (!super.currentInstanceIsBest((InstanceAuditHeader)this.currentSavedEntity, (InstanceAuditHeader)incomingEntity)) {
                this.currentSavedEntity = incomingEntity;
            }
            super.saveClassifications(incomingEntity.getClassifications());
        }
    }

    @Override
    public List<String> getResultsForAugmentation() {
        if (this.currentSavedEntity != null) {
            ArrayList<String> resultsArray = new ArrayList<String>();
            resultsArray.add(this.currentSavedEntity.getGUID());
            return resultsArray;
        }
        return null;
    }

    public EntitySummary getResult() {
        if (this.currentSavedEntity != null) {
            this.currentSavedEntity.setClassifications(super.getClassifications(false));
            return this.currentSavedEntity;
        }
        return null;
    }
}

