/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.EntityHistoryAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PageableEntityRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class GetEntityDetailHistoryExecutor
extends PageableEntityRepositoryExecutorBase {
    private final String guid;
    private final Date fromTime;
    private final Date toTime;
    private final HistorySequencingOrder historySequencingOrder;
    private EntityHistoryAccumulator historyAccumulator;

    public GetEntityDetailHistoryExecutor(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder, String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator, String methodName) {
        this(userId, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder, new EntityHistoryAccumulator(localMetadataCollectionId, auditLog, repositoryValidator), methodName);
    }

    private GetEntityDetailHistoryExecutor(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder, EntityHistoryAccumulator accumulator, String methodName) {
        super(userId, null, startFromElement, null, null, null, null, pageSize, accumulator, methodName);
        this.guid = guid;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.historySequencingOrder = sequencingOrder;
        this.historyAccumulator = accumulator;
    }

    @Override
    public CloneableRepositoryExecutor getClone() {
        return new GetEntityDetailHistoryExecutor(this.userId, this.guid, this.fromTime, this.toTime, this.startingElement, this.pageSize, this.historySequencingOrder, this.historyAccumulator, this.methodName);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            List results = metadataCollection.getEntityDetailHistory(this.userId, this.guid, this.fromTime, this.toTime, this.startingElement, this.pageSize, this.historySequencingOrder);
            this.accumulator.addEntities(results, metadataCollectionId);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (EntityNotKnownException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (EntityProxyOnlyException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (Exception error) {
            this.accumulator.captureGenericException(this.methodName, metadataCollectionId, error);
        }
        return false;
    }

    public List<EntityDetail> getHistoryResults(EnterpriseOMRSRepositoryConnector repositoryConnector, OMRSMetadataCollection metadataCollection) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.accumulator.resultsReturned()) {
            return this.accumulator.getResults(repositoryConnector, metadataCollection);
        }
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedEntityNotKnownException();
        this.accumulator.throwCapturedEntityProxyOnlyException();
        this.accumulator.throwCapturedGenericException(this.methodName);
        this.accumulator.throwCapturedInvalidParameterException();
        this.accumulator.throwCapturedFunctionNotSupportedException();
        return null;
    }
}

