/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.RelationshipsAccumulator;

public class RelationshipHistoryAccumulator
extends RelationshipsAccumulator {
    private final Map<Long, Relationship> accumulatedRelationships = new HashMap<Long, Relationship>();
    private final Map<String, List<String>> accumulatedRelationshipSources = new HashMap<String, List<String>>();
    private String relationshipGUID = null;

    public RelationshipHistoryAccumulator(String localMetadataCollectionId, AuditLog auditLog, OMRSRepositoryValidator repositoryValidator) {
        super(localMetadataCollectionId, auditLog, repositoryValidator);
    }

    private void addRelationship(Relationship incomingRelationship, String metadataCollectionId) {
        if (incomingRelationship != null && incomingRelationship.getGUID() != null && metadataCollectionId != null) {
            this.relationshipGUID = incomingRelationship.getGUID();
            List<String> contributingMetadataCollections = this.accumulatedRelationshipSources.get(this.relationshipGUID);
            if (contributingMetadataCollections == null) {
                contributingMetadataCollections = new ArrayList<String>();
            }
            contributingMetadataCollections.add(metadataCollectionId);
            this.accumulatedRelationshipSources.put(this.relationshipGUID, contributingMetadataCollections);
            this.accumulatedRelationships.put(incomingRelationship.getVersion(), incomingRelationship);
            if (metadataCollectionId.equals(this.localMetadataCollectionId)) {
                super.captureLocalInstance(this.relationshipGUID);
            }
        }
    }

    @Override
    public synchronized void addRelationships(List<Relationship> relationships, String metadataCollectionId) {
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                this.relationshipGUID = relationship.getGUID();
                this.addRelationship(relationship, metadataCollectionId);
            }
            super.setResultsReturned(metadataCollectionId, relationships.size());
        } else {
            super.setResultsReturned(metadataCollectionId, 0);
        }
    }

    @Override
    public synchronized List<Relationship> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector) {
        if (this.accumulatedRelationships == null || this.accumulatedRelationships.isEmpty()) {
            return null;
        }
        this.makeRefreshRecommendations(repositoryConnector);
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        for (Relationship accumulatedRelationship : this.accumulatedRelationships.values()) {
            if (accumulatedRelationship == null) continue;
            Relationship resultRelationship = new Relationship(accumulatedRelationship);
            results.add(resultRelationship);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private void makeRefreshRecommendations(EnterpriseOMRSRepositoryConnector repositoryConnector) {
        if (this.localMetadataCollectionId == null || this.accumulatedRelationships.isEmpty()) {
            return;
        }
        for (Relationship accumulatedRelationship : this.accumulatedRelationships.values()) {
            String relationshipGUID;
            if (accumulatedRelationship == null || (relationshipGUID = accumulatedRelationship.getGUID()) == null || !super.notLocal(relationshipGUID)) continue;
            repositoryConnector.requestRefreshOfRelationship(accumulatedRelationship);
        }
    }
}

