/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.eventmanagement;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessorInterface;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventProcessorInterface;
import org.odpi.openmetadata.repositoryservices.events.OpenMetadataEventsSecurity;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSEventListener
implements OMRSTopicListener {
    private final String cohortName;
    private final String localMetadataCollectionId;
    private OpenMetadataEventsSecurity securityVerifier;
    private final OMRSRegistryEventProcessor registryEventProcessor;
    private final OMRSTypeDefEventProcessorInterface typeDefEventProcessor;
    private final OMRSInstanceEventProcessorInterface instanceEventProcessor;
    private static final Logger log = LoggerFactory.getLogger(OMRSEventListener.class);

    public OMRSEventListener(String cohortName, String localMetadataCollectionId, OMRSRegistryEventProcessor registryEventProcessor, OMRSRepositoryEventProcessor repositoryEventProcessor, OpenMetadataEventsSecurity securityVerifier, AuditLog auditLog) {
        this.cohortName = cohortName;
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.registryEventProcessor = registryEventProcessor;
        this.typeDefEventProcessor = repositoryEventProcessor;
        this.instanceEventProcessor = repositoryEventProcessor;
        if (securityVerifier != null) {
            this.securityVerifier = securityVerifier;
        }
        String actionDescription = "Initialize OMRS Event Listener";
        log.debug("Initialize OMRS Event Listener");
        auditLog.logMessage("Initialize OMRS Event Listener", OMRSAuditCode.OMRS_LISTENER_INITIALIZING.getMessageDefinition(new String[]{cohortName}));
    }

    public void processRegistryEvent(OMRSRegistryEvent registryEvent) {
        log.debug("Processing registry event: " + String.valueOf(registryEvent));
        if (registryEvent == null) {
            log.debug("Null registry event; ignoring event");
        } else if (this.localMetadataCollectionId != null && this.localMetadataCollectionId.equals(registryEvent.getEventOriginator().getMetadataCollectionId())) {
            log.debug("Ignoring event that this server originated");
        } else if (this.registryEventProcessor == null) {
            log.debug("No registry event processor; ignoring event ");
        } else {
            OMRSRegistryEventType registryEventType = registryEvent.getRegistryEventType();
            OMRSEventOriginator registryEventOriginator = registryEvent.getEventOriginator();
            if (registryEventType != null && registryEventOriginator != null) {
                block0 : switch (registryEventType) {
                    case REGISTRATION_EVENT: {
                        this.registryEventProcessor.processRegistrationEvent(this.cohortName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName(), registryEvent.getRegistrationTimestamp(), registryEvent.getRemoteConnection());
                        break;
                    }
                    case RE_REGISTRATION_EVENT: {
                        this.registryEventProcessor.processReRegistrationEvent(this.cohortName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName(), registryEvent.getRegistrationTimestamp(), registryEvent.getRemoteConnection());
                        break;
                    }
                    case REFRESH_REGISTRATION_REQUEST: {
                        this.registryEventProcessor.processRegistrationRefreshRequest(this.cohortName, registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName());
                        break;
                    }
                    case UN_REGISTRATION_EVENT: {
                        this.registryEventProcessor.processUnRegistrationEvent(this.cohortName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName());
                        break;
                    }
                    case REGISTRATION_ERROR_EVENT: {
                        OMRSRegistryEventErrorCode errorCode = registryEvent.getErrorCode();
                        if (errorCode != null) {
                            switch (errorCode) {
                                case BAD_REMOTE_CONNECTION: {
                                    this.registryEventProcessor.processBadConnectionEvent(this.cohortName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName(), registryEvent.getTargetMetadataCollectionId(), registryEvent.getTargetRemoteConnection(), registryEvent.getErrorMessage());
                                    break block0;
                                }
                                case CONFLICTING_COLLECTION_ID: {
                                    this.registryEventProcessor.processConflictingCollectionIdEvent(this.cohortName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName(), registryEvent.getTargetMetadataCollectionId(), registryEvent.getErrorMessage());
                                    break block0;
                                }
                            }
                            log.debug("Unknown registry event error code; ignoring event");
                            break;
                        }
                        log.debug("Null registry event error code, ignoring event");
                        break;
                    }
                    default: {
                        log.debug("Unknown registry event: " + String.valueOf(registryEvent));
                        break;
                    }
                }
            } else {
                log.debug("Ignored registry event: " + String.valueOf(registryEvent));
            }
        }
    }

    public void processTypeDefEvent(OMRSTypeDefEvent typeDefEvent) {
        if (typeDefEvent == null) {
            log.debug("Null TypeDef event; ignoring event");
        } else if (this.localMetadataCollectionId != null && this.localMetadataCollectionId.equals(typeDefEvent.getEventOriginator().getMetadataCollectionId())) {
            log.debug("Ignoring event that this server originated");
        } else if (this.typeDefEventProcessor == null) {
            log.debug("No TypeDef event processor; ignoring event");
        } else {
            this.typeDefEventProcessor.sendTypeDefEvent(this.cohortName, typeDefEvent);
        }
    }

    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        log.debug("Processing instance event: " + String.valueOf(instanceEvent));
        if (instanceEvent == null) {
            log.debug("Null instance event ignoring event");
        } else if (this.localMetadataCollectionId != null && this.localMetadataCollectionId.equals(instanceEvent.getEventOriginator().getMetadataCollectionId())) {
            log.debug("Ignoring event that this server originated");
        } else if (this.instanceEventProcessor == null) {
            log.debug("Ignoring event as have not processor");
        } else {
            OMRSInstanceEvent verifiedEvent = this.securityVerifier.validateInboundEvent(this.cohortName, instanceEvent);
            if (verifiedEvent != null) {
                this.instanceEventProcessor.sendInstanceEvent(this.cohortName, instanceEvent);
            }
        }
    }
}

