/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.eventmanagement;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventType;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRegistryEventPublisher
extends OMRSRegistryEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(OMRSRegistryEventPublisher.class);
    private final String publisherName;
    private final List<OMRSTopicConnector> omrsTopicConnectors;
    private final AuditLog auditLog;

    public OMRSRegistryEventPublisher(String publisherName, List<OMRSTopicConnector> topicConnectors, AuditLog auditLog) {
        String actionDescription = "Initialize event publisher";
        this.auditLog = auditLog;
        this.publisherName = publisherName;
        if (topicConnectors == null || topicConnectors.isEmpty()) {
            log.debug("Null topic connector");
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_TOPIC_CONNECTOR.getMessageDefinition(new String[]{publisherName}), ((Object)((Object)this)).getClass().getName(), actionDescription);
        }
        this.omrsTopicConnectors = topicConnectors;
        log.debug("New Event Publisher: " + publisherName);
    }

    private boolean sendRegistryEvent(OMRSRegistryEvent registryEvent) {
        String actionDescription = "Send Registry Event";
        boolean successFlag = false;
        log.debug("Sending registryEvent for cohort: " + this.publisherName);
        log.debug("registryEvent: " + String.valueOf(registryEvent));
        log.debug("localEventOriginator: " + String.valueOf(registryEvent.getEventOriginator()));
        try {
            ArrayList<CompletableFuture> results = new ArrayList<CompletableFuture>();
            for (OMRSTopicConnector omrsTopicConnector : this.omrsTopicConnectors) {
                log.debug("topicConnector: " + String.valueOf(omrsTopicConnector));
                results.add(omrsTopicConnector.sendRegistryEvent(registryEvent));
            }
            successFlag = results.stream().map(CompletableFuture::join).reduce(true, (r1, r2) -> r1 != false && r2 != false);
        }
        catch (CompletionException exception) {
            this.auditLog.logException("Send Registry Event", OMRSAuditCode.SEND_REGISTRY_EVENT_ERROR.getMessageDefinition(new String[]{this.publisherName}), "registryEvent : " + String.valueOf(registryEvent), exception.getCause());
            log.debug("Exception: " + String.valueOf(exception.getCause()) + "; Registry Event: " + String.valueOf(registryEvent));
        }
        catch (Exception error) {
            this.auditLog.logException("Send Registry Event", OMRSAuditCode.SEND_REGISTRY_EVENT_ERROR.getMessageDefinition(new String[]{this.publisherName}), "registryEvent : " + String.valueOf(registryEvent), (Throwable)error);
            log.debug("Exception: " + String.valueOf(error) + "; Registry Event: " + String.valueOf(registryEvent));
        }
        return successFlag;
    }

    public boolean processRegistrationEvent(String sourceName, String metadataCollectionId, String metadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(metadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSRegistryEvent registryEvent = new OMRSRegistryEvent(OMRSRegistryEventType.REGISTRATION_EVENT, registrationTimestamp, metadataCollectionName, remoteConnection);
        registryEvent.setEventOriginator(eventOriginator);
        return this.sendRegistryEvent(registryEvent);
    }

    public boolean processRegistrationRefreshRequest(String sourceName, String originatorServerName, String originatorServerType, String originatorOrganizationName) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSRegistryEvent registryEvent = new OMRSRegistryEvent(OMRSRegistryEventType.REFRESH_REGISTRATION_REQUEST);
        registryEvent.setEventOriginator(eventOriginator);
        return this.sendRegistryEvent(registryEvent);
    }

    public boolean processReRegistrationEvent(String sourceName, String metadataCollectionId, String metadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(metadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSRegistryEvent registryEvent = new OMRSRegistryEvent(OMRSRegistryEventType.RE_REGISTRATION_EVENT, registrationTimestamp, metadataCollectionName, remoteConnection);
        registryEvent.setEventOriginator(eventOriginator);
        return this.sendRegistryEvent(registryEvent);
    }

    public boolean processUnRegistrationEvent(String sourceName, String metadataCollectionId, String metadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(metadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSRegistryEvent registryEvent = new OMRSRegistryEvent(OMRSRegistryEventType.UN_REGISTRATION_EVENT);
        registryEvent.setEventOriginator(eventOriginator);
        return this.sendRegistryEvent(registryEvent);
    }

    public void processConflictingCollectionIdEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, String conflictingMetadataCollectionId, String errorMessage) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSRegistryEvent registryEvent = new OMRSRegistryEvent(OMRSRegistryEventErrorCode.CONFLICTING_COLLECTION_ID, errorMessage, conflictingMetadataCollectionId, null);
        registryEvent.setEventOriginator(eventOriginator);
        this.sendRegistryEvent(registryEvent);
    }

    public void processBadConnectionEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, Connection remoteConnection, String errorMessage) {
        OMRSEventOriginator eventOriginator = new OMRSEventOriginator();
        eventOriginator.setMetadataCollectionId(originatorMetadataCollectionId);
        eventOriginator.setServerName(originatorServerName);
        eventOriginator.setServerType(originatorServerType);
        eventOriginator.setOrganizationName(originatorOrganizationName);
        OMRSRegistryEvent registryEvent = new OMRSRegistryEvent(OMRSRegistryEventErrorCode.CONFLICTING_COLLECTION_ID, errorMessage, targetMetadataCollectionId, remoteConnection);
        registryEvent.setEventOriginator(eventOriginator);
        this.sendRegistryEvent(registryEvent);
    }
}

