/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector;

import java.util.UUID;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.OMRSInstanceRetrievalEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalOMRSInstanceEventProcessor
extends OMRSInstanceEventProcessor
implements OMRSInstanceRetrievalEventProcessor {
    private static final String localOMRSInstanceEventProcessorName = "Local Repository Inbound Instance Events";
    private static final MessageFormatter messageFormatter = new MessageFormatter();
    private final String localMetadataCollectionId;
    private final String localServerName;
    private final OMRSRepositoryConnector localRepositoryConnector;
    private final OMRSRepositoryHelper repositoryHelper;
    private final OMRSRepositoryValidator repositoryValidator;
    private final OMRSRepositoryEventExchangeRule saveExchangeRule;
    private final boolean produceRefreshEvents;
    private final OMRSRepositoryEventProcessor outboundRepositoryEventProcessor;
    private OMRSMetadataCollection localMetadataCollection = null;
    private final AuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(LocalOMRSInstanceEventProcessor.class);

    LocalOMRSInstanceEventProcessor(String localMetadataCollectionId, String localServerName, OMRSRepositoryConnector localConnector, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, OMRSRepositoryEventExchangeRule saveExchangeRule, boolean produceRefreshEvents, OMRSRepositoryEventProcessor outboundRepositoryEventProcessor, AuditLog auditLog) {
        super(localOMRSInstanceEventProcessorName);
        String methodName = "LocalOMRSInstanceEventProcessor constructor";
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.localServerName = localServerName;
        this.localRepositoryConnector = localConnector;
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.saveExchangeRule = saveExchangeRule;
        this.produceRefreshEvents = produceRefreshEvents;
        this.outboundRepositoryEventProcessor = outboundRepositoryEventProcessor;
        this.auditLog = auditLog;
        if (localConnector != null) {
            try {
                this.localMetadataCollection = localConnector.getMetadataCollection();
            }
            catch (Exception error) {
                this.localMetadataCollection = null;
            }
        }
        this.verifyEventProcessor("LocalOMRSInstanceEventProcessor constructor");
    }

    private void logIncomingEvent(OMRSInstanceEventType instanceEventType, InstanceHeader instanceHeader, OMRSEventOriginator instanceEventOriginator, OMRSInstanceEvent instanceEvent, String methodName) {
        String instanceGUID = "<unknown GUID>";
        if (instanceHeader != null) {
            instanceGUID = instanceHeader.getGUID();
        }
        this.logIncomingEvent(instanceEventType, instanceGUID, instanceEventOriginator, instanceEvent, methodName);
    }

    private void logIncomingEvent(OMRSInstanceEventType instanceEventType, String instanceGUID, OMRSEventOriginator instanceEventOriginator, OMRSInstanceEvent instanceEvent, String methodName) {
        this.auditLog.logMessage(methodName, OMRSAuditCode.PROCESS_INCOMING_EVENT.getMessageDefinition(new String[]{instanceEventType.getName(), instanceGUID, instanceEventOriginator.toString()}), instanceEvent.toString());
    }

    public void sendInstanceEvent(String cohortName, OMRSInstanceEvent instanceEvent) {
        String methodName = "sendInstanceEvent";
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        if (instanceEventType != null && instanceEventOriginator != null) {
            block0 : switch (instanceEventType) {
                case NEW_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(NewEntity)");
                    this.processNewEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case UPDATED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(UpdatedEntity)");
                    this.processUpdatedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalEntity(), instanceEvent.getEntity());
                    break;
                }
                case CLASSIFIED_ENTITY_EVENT: {
                    if (instanceEvent.getEntityProxy() != null) {
                        this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntityProxy(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(ClassifiedEntityProxy)");
                        this.processClassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntityProxy(), instanceEvent.getClassification());
                        break;
                    }
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(ClassifiedEntity)");
                    this.processClassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getClassification());
                    break;
                }
                case RECLASSIFIED_ENTITY_EVENT: {
                    if (instanceEvent.getEntityProxy() != null) {
                        this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntityProxy(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(ReclassifiedEntityProxy)");
                        this.processReclassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntityProxy(), instanceEvent.getOriginalClassification(), instanceEvent.getClassification());
                        break;
                    }
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(ReclassifiedEntity)");
                    this.processReclassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getOriginalClassification(), instanceEvent.getClassification());
                    break;
                }
                case DECLASSIFIED_ENTITY_EVENT: {
                    if (instanceEvent.getEntityProxy() != null) {
                        this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntityProxy(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(DeclassifiedEntityProxy)");
                        this.processDeclassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntityProxy(), instanceEvent.getOriginalClassification());
                        break;
                    }
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(DeclassifiedEntity)");
                    this.processDeclassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getOriginalClassification());
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(DeletedEntity)");
                    this.processDeletedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case PURGED_ENTITY_EVENT: {
                    if (instanceEvent.getEntity() == null) {
                        this.logIncomingEvent(instanceEventType, instanceEvent.getInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(PurgedEntity)");
                        this.processPurgedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID());
                        break;
                    }
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(PurgedEntityInstance)");
                    this.processPurgedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case DELETE_PURGED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(DeletePurgeEntity)");
                    this.processDeletePurgedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case UNDONE_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(UndoneUpdateToEntity)");
                    this.processUndoneEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case RESTORED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RestoredEntity)");
                    this.processRestoredEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case REFRESH_ENTITY_REQUEST: {
                    this.logIncomingEvent(instanceEventType, instanceEvent.getInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RefreshEntityRequest)");
                    this.processRefreshEntityRequested(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID(), instanceEvent.getHomeMetadataCollectionId());
                    break;
                }
                case REFRESHED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RefreshedEntity)");
                    this.processRefreshEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case RE_HOMED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RehomedEntity)");
                    this.processReHomedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalHomeMetadataCollectionId(), instanceEvent.getEntity());
                    break;
                }
                case RETYPED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RetypedEntity)");
                    this.processReTypedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalTypeDefSummary(), instanceEvent.getEntity());
                    break;
                }
                case RE_IDENTIFIED_ENTITY_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getEntity(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(ReidentifiedEntity)");
                    this.processReIdentifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalInstanceGUID(), instanceEvent.getEntity());
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(NewRelationship)");
                    this.processNewRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case UPDATED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(UpdatedRelationship)");
                    this.processUpdatedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalRelationship(), instanceEvent.getRelationship());
                    break;
                }
                case UNDONE_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(UndoneUpdateToRelationship)");
                    this.processUndoneRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case DELETED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(DeletedRelationship)");
                    this.processDeletedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case PURGED_RELATIONSHIP_EVENT: {
                    if (instanceEvent.getRelationship() == null) {
                        this.logIncomingEvent(instanceEventType, instanceEvent.getInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(PurgedRelationship)");
                        this.processPurgedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID());
                        break;
                    }
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(PurgedRelationshipInstance)");
                    this.processPurgedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case DELETE_PURGED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(DeletePurgedRelationship)");
                    this.processDeletePurgedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case RESTORED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RestoredRelationship)");
                    this.processRestoredRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case REFRESH_RELATIONSHIP_REQUEST: {
                    this.logIncomingEvent(instanceEventType, instanceEvent.getInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RefreshRelationshipRequest)");
                    this.processRefreshRelationshipRequest(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID(), instanceEvent.getHomeMetadataCollectionId());
                    break;
                }
                case REFRESHED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RefreshedRelationship)");
                    this.processRefreshRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case RE_IDENTIFIED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(ReidentifiedRelationship)");
                    this.processReIdentifiedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalInstanceGUID(), instanceEvent.getRelationship());
                    break;
                }
                case RE_HOMED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RehomedRelationship)");
                    this.processReHomedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalHomeMetadataCollectionId(), instanceEvent.getRelationship());
                    break;
                }
                case RETYPED_RELATIONSHIP_EVENT: {
                    this.logIncomingEvent(instanceEventType, (InstanceHeader)instanceEvent.getRelationship(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(RetypedRelationship)");
                    this.processReTypedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalTypeDefSummary(), instanceEvent.getRelationship());
                    break;
                }
                case BATCH_INSTANCES_EVENT: {
                    this.logIncomingEvent(instanceEventType, "<multiple>", instanceEventOriginator, instanceEvent, "sendInstanceEvent(BatchedInstance)");
                    this.processInstanceBatchEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getInstanceBatch());
                    break;
                }
                case INSTANCE_ERROR_EVENT: {
                    OMRSInstanceEventErrorCode errorCode = instanceEvent.getErrorCode();
                    if (errorCode != null) {
                        switch (errorCode) {
                            case CONFLICTING_INSTANCES: {
                                this.logIncomingEvent(instanceEventType, instanceEvent.getTargetInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(ConflictingInstances)");
                                this.processConflictingInstancesEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTargetMetadataCollectionId(), instanceEvent.getTargetTypeDefSummary(), instanceEvent.getTargetInstanceGUID(), instanceEvent.getOtherMetadataCollectionId(), instanceEvent.getOtherOrigin(), instanceEvent.getOtherTypeDefSummary(), instanceEvent.getOtherInstanceGUID(), instanceEvent.getErrorMessage());
                                break block0;
                            }
                            case CONFLICTING_TYPE: {
                                this.logIncomingEvent(instanceEventType, instanceEvent.getTargetInstanceGUID(), instanceEventOriginator, instanceEvent, "sendInstanceEvent(ConflictingType)");
                                this.processConflictingTypeEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTargetMetadataCollectionId(), instanceEvent.getTargetTypeDefSummary(), instanceEvent.getTargetInstanceGUID(), instanceEvent.getOtherTypeDefSummary(), instanceEvent.getErrorMessage());
                                break block0;
                            }
                        }
                        log.debug("Unknown instance event error code, ignoring event");
                        break;
                    }
                    log.debug("Ignored Instance event, null error code");
                    break;
                }
                default: {
                    log.debug("Ignored Instance event, unknown type");
                    break;
                }
            }
        } else {
            log.debug("Ignored instance event, null type");
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        if (this.updateReferenceEntity(sourceName, "processNewEntityEvent", originatorMetadataCollectionId, originatorServerName, entity, OMRSInstanceEventType.NEW_ENTITY_EVENT) && entity.getReplicatedBy() != null && entity.getReplicatedBy().equals(this.localMetadataCollectionId)) {
            this.outboundRepositoryEventProcessor.processNewEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
        }
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        if (this.updateReferenceEntity(sourceName, "processUpdatedEntityEvent", originatorMetadataCollectionId, originatorServerName, newEntity, OMRSInstanceEventType.UPDATED_ENTITY_EVENT) && newEntity.getReplicatedBy() != null && newEntity.getReplicatedBy().equals(this.localMetadataCollectionId)) {
            this.outboundRepositoryEventProcessor.processNewEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newEntity);
        }
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        this.updateReferenceEntity(sourceName, "processUndoneEntityEvent", originatorMetadataCollectionId, originatorServerName, entity, OMRSInstanceEventType.UNDONE_ENTITY_EVENT);
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent(detail)";
        try {
            this.verifyEventProcessor("processClassifiedEntityEvent(detail)");
            this.localMetadataCollection.saveClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, classification);
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processClassifiedEntityEvent(detail)", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        String methodName = "processClassifiedEntityEvent(proxy)";
        try {
            this.verifyEventProcessor("processClassifiedEntityEvent(proxy)");
            this.localMetadataCollection.saveClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, classification);
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processClassifiedEntityEvent(proxy)", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent(detail)";
        try {
            this.verifyEventProcessor("processDeclassifiedEntityEvent(detail)");
            this.localMetadataCollection.purgeClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, originalClassification);
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processDeclassifiedEntityEvent(detail)", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        String methodName = "processDeclassifiedEntityEvent(proxy)";
        try {
            this.verifyEventProcessor("processDeclassifiedEntityEvent(proxy)");
            this.localMetadataCollection.purgeClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, originalClassification);
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processDeclassifiedEntityEvent(proxy)", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent(detail)";
        try {
            this.verifyEventProcessor("processReclassifiedEntityEvent(detail)");
            this.localMetadataCollection.saveClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, classification);
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processReclassifiedEntityEvent(detail)", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        String methodName = "processReclassifiedEntityEvent(proxy)";
        try {
            this.verifyEventProcessor("processReclassifiedEntityEvent(proxy)");
            this.localMetadataCollection.saveClassificationReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity, classification);
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processReclassifiedEntityEvent(proxy)", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        String entityParameterName = "entity";
        try {
            this.verifyEventProcessor("processDeletedEntityEvent");
            this.repositoryValidator.validateReferenceInstanceHeader(sourceName, this.localMetadataCollectionId, "entity", (InstanceHeader)entity, this.auditLog, "processDeletedEntityEvent");
            EntityDetail storedEntity = this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), entity.getGUID());
            if (this.compareAndValidateReferenceInstance(originatorServerName, (InstanceHeader)entity, (InstanceHeader)storedEntity, OMRSInstanceEventType.DELETED_ENTITY_EVENT, "processDeletedEntityEvent")) {
                this.localMetadataCollection.deleteEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity);
            }
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processDeletedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processPurgedEntityEvent";
        String entityParameterName = "entity";
        try {
            this.verifyEventProcessor("processPurgedEntityEvent");
            this.repositoryValidator.validateReferenceInstanceHeader(sourceName, this.localMetadataCollectionId, "entity", (InstanceHeader)entity, this.auditLog, "processPurgedEntityEvent");
            EntityDetail storedEntity = this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), entity.getGUID());
            if (this.compareAndValidateReferenceInstance(originatorServerName, (InstanceHeader)entity, (InstanceHeader)storedEntity, OMRSInstanceEventType.DELETE_PURGED_ENTITY_EVENT, "processPurgedEntityEvent")) {
                this.localMetadataCollection.purgeEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity);
            }
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processPurgedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        String methodName = "processPurgedEntityEvent";
        try {
            this.verifyEventProcessor("processPurgedEntityEvent");
            EntityDetail storedEntity = this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), instanceGUID);
            if (storedEntity != null && originatorMetadataCollectionId.equals(storedEntity.getMetadataCollectionId())) {
                this.localMetadataCollection.purgeEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), instanceGUID, typeDefGUID, typeDefName, originatorMetadataCollectionId);
            }
        }
        catch (EntityNotKnownException storedEntity) {
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processPurgedEntityEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        this.updateReferenceEntity(sourceName, "processRestoredEntityEvent", originatorMetadataCollectionId, originatorServerName, entity, OMRSInstanceEventType.RESTORED_ENTITY_EVENT);
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        this.updateReferenceEntity(sourceName, "processReIdentifiedEntityEvent", originatorMetadataCollectionId, originatorServerName, entity, OMRSInstanceEventType.RE_IDENTIFIED_ENTITY_EVENT);
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        this.updateReferenceEntity(sourceName, "processReTypedEntityEvent", originatorMetadataCollectionId, originatorServerName, entity, OMRSInstanceEventType.RETYPED_ENTITY_EVENT);
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        this.updateReferenceEntity(sourceName, "processReHomedEntityEvent", originatorMetadataCollectionId, originatorServerName, entity, OMRSInstanceEventType.RE_HOMED_ENTITY_EVENT);
    }

    public void processRefreshEntityRequested(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        String methodName = "processRefreshEntityRequested";
        try {
            EntityDetail entity;
            this.verifyEventProcessor("processRefreshEntityRequested");
            if (this.produceRefreshEvents && this.localMetadataCollectionId.equals(homeMetadataCollectionId) && (entity = this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), instanceGUID)) != null) {
                this.outboundRepositoryEventProcessor.processRefreshEntityEvent(this.localRepositoryConnector.getRepositoryName(), this.localMetadataCollectionId, this.localRepositoryConnector.getServerName(), this.localRepositoryConnector.getServerType(), this.localRepositoryConnector.getOrganizationName(), entity);
            }
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processRefreshEntityRequested", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRefreshEntityEvent";
        this.updateReferenceEntity(sourceName, "processRefreshEntityEvent", originatorMetadataCollectionId, originatorServerName, entity, OMRSInstanceEventType.REFRESHED_ENTITY_EVENT);
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        if (this.updateReferenceRelationship(sourceName, "processNewRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship, OMRSInstanceEventType.NEW_RELATIONSHIP_EVENT) && relationship.getReplicatedBy() != null && relationship.getReplicatedBy().equals(this.localMetadataCollectionId)) {
            this.outboundRepositoryEventProcessor.processNewRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
        }
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        if (this.updateReferenceRelationship(sourceName, "processUpdatedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, newRelationship, OMRSInstanceEventType.UPDATED_RELATIONSHIP_EVENT) && newRelationship.getReplicatedBy() != null && newRelationship.getReplicatedBy().equals(this.localMetadataCollectionId)) {
            this.outboundRepositoryEventProcessor.processNewRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newRelationship);
        }
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processUndoneRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship, OMRSInstanceEventType.UNDONE_RELATIONSHIP_EVENT);
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        String relationshipParameterName = "relationship";
        try {
            this.verifyEventProcessor("processDeletedRelationshipEvent");
            this.repositoryValidator.validateReferenceInstanceHeader(sourceName, this.localMetadataCollectionId, "relationship", (InstanceHeader)relationship, this.auditLog, "processDeletedRelationshipEvent");
            Relationship storedRelationship = this.localMetadataCollection.isRelationshipKnown(this.localRepositoryConnector.getServerUserId(), relationship.getGUID());
            if (this.compareAndValidateReferenceInstance(originatorServerName, (InstanceHeader)relationship, (InstanceHeader)storedRelationship, OMRSInstanceEventType.DELETED_RELATIONSHIP_EVENT, "processDeletedRelationshipEvent")) {
                this.localMetadataCollection.deleteRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), relationship);
            }
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processDeletedRelationshipEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processPurgedRelationshipEvent";
        String relationshipParameterName = "relationship";
        try {
            this.verifyEventProcessor("processPurgedRelationshipEvent");
            this.repositoryValidator.validateReferenceInstanceHeader(sourceName, this.localMetadataCollectionId, "relationship", (InstanceHeader)relationship, this.auditLog, "processPurgedRelationshipEvent");
            Relationship storedRelationship = this.localMetadataCollection.isRelationshipKnown(this.localRepositoryConnector.getServerUserId(), relationship.getGUID());
            if (this.compareAndValidateReferenceInstance(originatorServerName, (InstanceHeader)relationship, (InstanceHeader)storedRelationship, OMRSInstanceEventType.DELETE_PURGED_RELATIONSHIP_EVENT, "processPurgedRelationshipEvent")) {
                this.localMetadataCollection.purgeRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), relationship);
            }
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processPurgedRelationshipEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        String methodName = "processPurgedRelationshipEvent";
        try {
            this.verifyEventProcessor("processPurgedRelationshipEvent");
            Relationship storedRelationship = this.localMetadataCollection.isRelationshipKnown(this.localRepositoryConnector.getServerUserId(), instanceGUID);
            if (storedRelationship != null && originatorMetadataCollectionId.equals(storedRelationship.getMetadataCollectionId())) {
                this.localMetadataCollection.purgeRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), instanceGUID, typeDefGUID, typeDefName, originatorMetadataCollectionId);
            }
        }
        catch (RelationshipNotKnownException storedRelationship) {
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processPurgedRelationshipEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processRestoredRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship, OMRSInstanceEventType.RESTORED_RELATIONSHIP_EVENT);
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processReIdentifiedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship, OMRSInstanceEventType.RE_IDENTIFIED_RELATIONSHIP_EVENT);
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processReTypedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship, OMRSInstanceEventType.RETYPED_RELATIONSHIP_EVENT);
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processReHomedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship, OMRSInstanceEventType.RE_HOMED_RELATIONSHIP_EVENT);
    }

    public void processRefreshRelationshipRequest(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        String methodName = "processRefreshRelationshipRequest";
        try {
            Relationship relationship;
            this.verifyEventProcessor("processRefreshRelationshipRequest");
            if (this.produceRefreshEvents && this.localMetadataCollectionId.equals(homeMetadataCollectionId) && (relationship = this.localMetadataCollection.isRelationshipKnown(this.localRepositoryConnector.getServerUserId(), instanceGUID)) != null) {
                this.outboundRepositoryEventProcessor.processRefreshRelationshipEvent(this.localRepositoryConnector.getRepositoryName(), this.localMetadataCollectionId, this.localRepositoryConnector.getServerName(), this.localRepositoryConnector.getServerType(), this.localRepositoryConnector.getOrganizationName(), relationship);
            }
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processRefreshRelationshipRequest", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRefreshRelationshipEvent";
        this.updateReferenceRelationship(sourceName, "processRefreshRelationshipEvent", originatorMetadataCollectionId, originatorServerName, relationship, OMRSInstanceEventType.REFRESH_RELATIONSHIP_REQUEST);
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
        String methodName = "processInstanceBatchEvent";
        try {
            this.verifyEventProcessor("processInstanceBatchEvent");
            this.localMetadataCollection.saveInstanceReferenceCopies(this.localRepositoryConnector.getServerUserId(), instances);
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, "processInstanceBatchEvent", originatorServerName, originatorMetadataCollectionId);
        }
    }

    public void processConflictingInstancesEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDefSummary, String otherInstanceGUID, String errorMessage) {
        String methodName = "processConflictingInstancesEvent";
        this.auditLog.logMessage("processConflictingInstancesEvent", OMRSAuditCode.DUPLICATE_INSTANCES_FOR_GUID.getMessageDefinition(new String[]{originatorServerName, originatorMetadataCollectionId, otherInstanceGUID, otherMetadataCollectionId, otherTypeDefSummary.toString(), otherOrigin.getName(), targetMetadataCollectionId, targetTypeDefSummary.toString(), errorMessage}), sourceName);
        if (this.localMetadataCollectionId.equals(targetMetadataCollectionId)) {
            try {
                String newGUID = UUID.randomUUID().toString();
                if (targetTypeDefSummary.getCategory() == TypeDefCategory.ENTITY_DEF) {
                    this.localMetadataCollection.reIdentifyEntity(this.localRepositoryConnector.getServerUserId(), targetTypeDefSummary.getGUID(), targetTypeDefSummary.getName(), targetInstanceGUID, newGUID);
                } else {
                    this.localMetadataCollection.reIdentifyRelationship(this.localRepositoryConnector.getServerUserId(), targetTypeDefSummary.getGUID(), targetTypeDefSummary.getName(), targetInstanceGUID, newGUID);
                }
                this.auditLog.logMessage("processConflictingInstancesEvent", OMRSAuditCode.INSTANCE_SUCCESSFULLY_REIDENTIFIED.getMessageDefinition(new String[]{this.localServerName, this.localMetadataCollectionId, otherTypeDefSummary.getName(), targetInstanceGUID, newGUID}));
            }
            catch (Exception error) {
                this.auditLog.logMessage("processConflictingInstancesEvent", OMRSAuditCode.UNABLE_TO_RE_IDENTIFY_INSTANCE.getMessageDefinition(new String[]{this.localServerName, this.localMetadataCollectionId, otherTypeDefSummary.getName(), targetInstanceGUID, error.getClass().getName(), error.getMessage()}));
            }
        } else {
            this.removeReferenceCopyOfInstance(targetTypeDefSummary, targetInstanceGUID, targetMetadataCollectionId, "processConflictingInstancesEvent");
        }
    }

    public void processConflictingTypeEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, TypeDefSummary otherTypeDefSummary, String errorMessage) {
        String methodName = "processConflictingTypeEvent";
        if (this.localMetadataCollectionId.equals(targetMetadataCollectionId)) {
            this.auditLog.logMessage("processConflictingTypeEvent", OMRSAuditCode.LOCAL_INSTANCE_WITH_CONFLICTING_TYPES.getMessageDefinition(new String[]{originatorServerName, originatorMetadataCollectionId, targetInstanceGUID, otherTypeDefSummary.toString(), targetMetadataCollectionId, targetTypeDefSummary.toString(), errorMessage}));
        } else {
            this.auditLog.logMessage("processConflictingTypeEvent", OMRSAuditCode.INSTANCES_WITH_CONFLICTING_TYPES.getMessageDefinition(new String[]{originatorServerName, originatorMetadataCollectionId, targetInstanceGUID, otherTypeDefSummary.toString(), targetMetadataCollectionId, targetTypeDefSummary.toString(), errorMessage}));
            this.removeReferenceCopyOfInstance(targetTypeDefSummary, targetInstanceGUID, targetMetadataCollectionId, "processConflictingTypeEvent");
        }
    }

    private void refreshRetrievedEntity(String sourceName, String metadataCollectionId, String processedEntityGUID, InstanceType processedEntityType) {
        try {
            if (this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), processedEntityGUID) == null && processedEntityType != null) {
                this.localMetadataCollection.refreshEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), processedEntityGUID, processedEntityType.getTypeDefGUID(), processedEntityType.getTypeDefName(), metadataCollectionId);
            }
        }
        catch (Exception error) {
            String methodName = "processRetrievedEntity";
            this.handleUnexpectedErrorFromEvent(error, "processRetrievedEntity", sourceName, metadataCollectionId);
        }
    }

    private void refreshRetrievedRelationship(String sourceName, String metadataCollectionId, String processedRelationshipGUID, InstanceType processedRelationshipType) {
        try {
            if (this.localMetadataCollection.isRelationshipKnown(this.localRepositoryConnector.getServerUserId(), processedRelationshipGUID) == null && processedRelationshipType != null) {
                this.localMetadataCollection.refreshRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), processedRelationshipGUID, processedRelationshipType.getTypeDefGUID(), processedRelationshipType.getTypeDefName(), metadataCollectionId);
            }
        }
        catch (Exception error) {
            String methodName = "processRetrievedRelationship";
            this.handleUnexpectedErrorFromEvent(error, "processRetrievedRelationship", sourceName, metadataCollectionId);
        }
    }

    @Override
    public void processRetrievedEntitySummary(String sourceName, String metadataCollectionId, EntitySummary processedEntity) {
        if (this.verifyWhetherToRequestRefresh(sourceName, (InstanceHeader)processedEntity)) {
            this.refreshRetrievedEntity(sourceName, processedEntity.getMetadataCollectionId(), processedEntity.getGUID(), processedEntity.getType());
        }
    }

    @Override
    public void processRetrievedEntityDetail(String sourceName, String metadataCollectionId, EntityDetail processedEntity) {
        if (this.verifyWhetherToRequestRefresh(sourceName, (InstanceHeader)processedEntity)) {
            this.refreshRetrievedEntity(sourceName, processedEntity.getMetadataCollectionId(), processedEntity.getGUID(), processedEntity.getType());
        }
    }

    @Override
    public void processRetrievedRelationship(String sourceName, String metadataCollectionId, Relationship processedRelationship) {
        if (this.verifyWhetherToRequestRefresh(sourceName, (InstanceHeader)processedRelationship)) {
            this.refreshRetrievedRelationship(sourceName, processedRelationship.getMetadataCollectionId(), processedRelationship.getGUID(), processedRelationship.getType());
        }
    }

    private void removeReferenceCopyOfInstance(TypeDefSummary typeDefSummary, String instanceGUID, String homeMetadataCollectionId, String methodName) {
        try {
            if (typeDefSummary.getCategory() == TypeDefCategory.ENTITY_DEF) {
                this.localMetadataCollection.purgeEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), instanceGUID, typeDefSummary.getGUID(), typeDefSummary.getName(), homeMetadataCollectionId);
            } else {
                this.localMetadataCollection.purgeRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), instanceGUID, typeDefSummary.getGUID(), typeDefSummary.getName(), homeMetadataCollectionId);
            }
        }
        catch (Exception error) {
            this.auditLog.logMessage(methodName, OMRSAuditCode.UNABLE_TO_REMOVE_REFERENCE_COPY.getMessageDefinition(new String[]{this.localServerName, this.localMetadataCollectionId, typeDefSummary.getName(), instanceGUID, error.getClass().getName(), error.getMessage()}), error.toString());
        }
    }

    private boolean updateReferenceEntity(String sourceName, String methodName, String originatorMetadataCollectionId, String originatorServerName, EntityDetail entity, OMRSInstanceEventType eventType) {
        boolean validEntity = false;
        try {
            String entityParameterName = "entity";
            this.verifyEventProcessor(methodName);
            this.repositoryValidator.validateReferenceInstanceHeader(sourceName, this.localMetadataCollectionId, "entity", (InstanceHeader)entity, this.auditLog, methodName);
            EntityDetail storedEntity = this.localMetadataCollection.isEntityKnown(this.localRepositoryConnector.getServerUserId(), entity.getGUID());
            validEntity = this.compareAndValidateReferenceInstance(originatorServerName, (InstanceHeader)entity, (InstanceHeader)storedEntity, eventType, methodName);
            if (validEntity && (this.verifyEventToSave(sourceName, (InstanceHeader)entity) || this.verifyEventToLearn(sourceName, (InstanceHeader)entity))) {
                this.localMetadataCollection.saveEntityReferenceCopy(this.localRepositoryConnector.getServerUserId(), entity);
            }
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, methodName, originatorServerName, originatorMetadataCollectionId);
        }
        return validEntity;
    }

    private boolean compareAndValidateReferenceInstance(String originatorServerName, InstanceHeader incomingInstance, InstanceHeader storedInstance, OMRSInstanceEventType eventType, String methodName) {
        if (storedInstance == null) {
            return true;
        }
        InstanceType storedInstanceType = storedInstance.getType();
        InstanceType incomingInstanceType = incomingInstance.getType();
        if (storedInstanceType != null && incomingInstanceType != null) {
            if (incomingInstance.getCreateTime().equals(storedInstance.getCreateTime())) {
                if (storedInstance.getVersion() < incomingInstance.getVersion()) {
                    if (storedInstanceType.getTypeDefVersion() <= incomingInstanceType.getTypeDefVersion()) {
                        if (!incomingInstance.getMetadataCollectionId().equals(storedInstance.getMetadataCollectionId())) {
                            if (eventType == OMRSInstanceEventType.RE_HOMED_ENTITY_EVENT || eventType == OMRSInstanceEventType.RE_HOMED_RELATIONSHIP_EVENT) {
                                this.auditLog.logMessage(methodName, OMRSAuditCode.NEW_HOME_INFORMATION.getMessageDefinition(new String[]{Long.toString(incomingInstance.getVersion()), incomingInstance.getGUID(), originatorServerName, incomingInstance.getMetadataCollectionId(), storedInstance.getMetadataCollectionId()}), incomingInstance.toString());
                            } else {
                                this.processGUIDConflict(originatorServerName, incomingInstance, incomingInstanceType, storedInstance, storedInstanceType);
                                return false;
                            }
                        }
                        if (!incomingInstanceType.getTypeDefName().equals(storedInstanceType.getTypeDefName())) {
                            this.auditLog.logMessage(methodName, OMRSAuditCode.NEW_TYPE_INFORMATION.getMessageDefinition(new String[]{Long.toString(incomingInstance.getVersion()), incomingInstance.getGUID(), originatorServerName, incomingInstance.getMetadataCollectionId(), incomingInstanceType.getTypeDefName(), incomingInstanceType.getTypeDefGUID(), storedInstanceType.getTypeDefName(), storedInstanceType.getTypeDefGUID()}), incomingInstance.toString());
                        }
                        return true;
                    }
                    try {
                        AuditLogMessageDefinition messageDefinition = OMRSAuditCode.PROCESS_INSTANCE_TYPE_CONFLICT.getMessageDefinition(new String[]{storedInstance.getGUID(), originatorServerName, storedInstance.getMetadataCollectionId(), storedInstanceType.getTypeDefName(), storedInstanceType.toString(), incomingInstanceType.toString()});
                        this.auditLog.logMessage(methodName, messageDefinition);
                        this.outboundRepositoryEventProcessor.processConflictingTypeEvent(this.localServerName, this.localMetadataCollectionId, this.localRepositoryConnector.getServerName(), this.localRepositoryConnector.getServerType(), this.localRepositoryConnector.getOrganizationName(), incomingInstance.getMetadataCollectionId(), (TypeDefSummary)this.repositoryHelper.getTypeDef(this.localServerName, "incomingInstanceType", incomingInstanceType.getTypeDefGUID(), methodName), incomingInstance.getGUID(), (TypeDefSummary)this.repositoryHelper.getTypeDef(this.localServerName, "storedInstanceType", storedInstanceType.getTypeDefGUID(), methodName), messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
                    }
                    catch (Exception error) {
                        String localMethodName = "compareAndValidateReferenceInstance";
                        this.handleUnexpectedErrorFromEvent(error, "compareAndValidateReferenceInstance", originatorServerName, incomingInstance.getMetadataCollectionId());
                    }
                }
            } else {
                this.processGUIDConflict(originatorServerName, incomingInstance, incomingInstanceType, storedInstance, storedInstanceType);
            }
        }
        return false;
    }

    private void processGUIDConflict(String originatorServerName, InstanceHeader incomingInstance, InstanceType incomingInstanceType, InstanceHeader storedInstance, InstanceType storedInstanceType) {
        String methodName = "processGUIDConflict";
        try {
            TypeDef incomingInstanceTypeDef = this.repositoryHelper.getTypeDef(this.localServerName, "incomingInstanceType", incomingInstanceType.getTypeDefGUID(), "processGUIDConflict");
            TypeDef storedInstanceTypeDef = this.repositoryHelper.getTypeDef(this.localServerName, "storedInstanceType", storedInstanceType.getTypeDefGUID(), "processGUIDConflict");
            AuditLogMessageDefinition messageDefinition = OMRSAuditCode.PROCESS_INSTANCE_GUID_CONFLICT.getMessageDefinition(new String[]{incomingInstanceType.getTypeDefName(), incomingInstanceType.getTypeDefName(), originatorServerName, incomingInstance.getMetadataCollectionId(), storedInstance.getGUID(), storedInstanceType.getTypeDefName(), storedInstanceType.getTypeDefGUID()});
            this.outboundRepositoryEventProcessor.processConflictingInstancesEvent(this.localServerName, this.localMetadataCollectionId, this.localRepositoryConnector.getServerName(), this.localRepositoryConnector.getServerType(), this.localRepositoryConnector.getOrganizationName(), incomingInstance.getMetadataCollectionId(), (TypeDefSummary)incomingInstanceTypeDef, incomingInstance.getGUID(), this.localMetadataCollectionId, storedInstance.getInstanceProvenanceType(), (TypeDefSummary)storedInstanceTypeDef, storedInstance.getGUID(), messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition));
        }
        catch (Exception error) {
            String localMethodName = "compareAndValidateReferenceInstance";
            this.handleUnexpectedErrorFromEvent(error, "compareAndValidateReferenceInstance", originatorServerName, incomingInstance.getMetadataCollectionId());
        }
    }

    private boolean updateReferenceRelationship(String sourceName, String methodName, String originatorMetadataCollectionId, String originatorServerName, Relationship relationship, OMRSInstanceEventType eventType) {
        boolean validRelationship = false;
        try {
            String relationshipParameterName = "relationship";
            this.verifyEventProcessor(methodName);
            this.repositoryValidator.validateReferenceInstanceHeader(sourceName, this.localMetadataCollectionId, "relationship", (InstanceHeader)relationship, this.auditLog, methodName);
            Relationship storedRelationship = this.localMetadataCollection.isRelationshipKnown(this.localRepositoryConnector.getServerUserId(), relationship.getGUID());
            validRelationship = this.compareAndValidateReferenceInstance(originatorServerName, (InstanceHeader)relationship, (InstanceHeader)storedRelationship, eventType, methodName);
            if (validRelationship && (this.verifyEventToSave(sourceName, (InstanceHeader)relationship) || this.verifyEventToLearn(sourceName, (InstanceHeader)relationship))) {
                this.localMetadataCollection.saveRelationshipReferenceCopy(this.localRepositoryConnector.getServerUserId(), relationship);
            }
        }
        catch (Exception error) {
            this.handleUnexpectedErrorFromEvent(error, methodName, originatorServerName, originatorMetadataCollectionId);
        }
        return validRelationship;
    }

    private void verifyEventProcessor(String methodName) {
        if (this.localMetadataCollectionId == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_LOCAL_METADATA_COLLECTION.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        if (this.localRepositoryConnector == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NO_LOCAL_REPOSITORY.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        if (this.repositoryHelper == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_REPOSITORY_HELPER.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        if (this.repositoryValidator == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_REPOSITORY_VALIDATOR.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        if (this.saveExchangeRule == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_EXCHANGE_RULE.getMessageDefinition(new String[]{methodName}), this.getClass().getName(), methodName);
        }
        if (this.localMetadataCollection == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION.getMessageDefinition(new String[]{this.localServerName}), this.getClass().getName(), methodName);
        }
    }

    private void handleUnexpectedErrorFromEvent(Exception error, String methodName, String originatorServerName, String originatorMetadataCollectionId) {
        this.auditLog.logException(methodName, OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT.getMessageDefinition(new String[]{methodName, originatorServerName, originatorMetadataCollectionId, error.getClass().getName(), error.getMessage()}), (Throwable)error);
    }

    private boolean verifyEventToSave(String source, InstanceHeader instance) {
        InstanceType instanceType = instance.getType();
        return this.saveExchangeRule.processInstanceEvent(instance) && this.repositoryValidator.isActiveType(source, instanceType.getTypeDefGUID(), instanceType.getTypeDefName());
    }

    private boolean verifyEventToLearn(String source, InstanceHeader instance) {
        InstanceType instanceType = instance.getType();
        return this.saveExchangeRule.learnInstanceEvent(instance) && this.repositoryValidator.isActiveType(source, instanceType.getTypeDefGUID(), instanceType.getTypeDefName());
    }

    private boolean verifyWhetherToRequestRefresh(String source, InstanceHeader instance) {
        boolean shouldProcess;
        InstanceType instanceType = instance.getType();
        this.saveExchangeRule.learnInstanceEvent(instance);
        boolean bl = shouldProcess = this.saveExchangeRule.processInstanceEvent(instance) || this.saveExchangeRule.learnInstanceEvent(instance);
        if (shouldProcess) {
            return this.repositoryValidator.isActiveType(source, instanceType.getTypeDefGUID(), instanceType.getTypeDefName());
        }
        return false;
    }
}

