/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server.spring;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.BooleanResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityDetailResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntitySummaryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.HistoryRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstancePropertiesRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.MetadataCollectionIdResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefChangeRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefGalleryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefReIdentifyRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefValidationForRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.VoidResponse;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSRepositoryRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/repository-services/users/{userId}"})
public class LocalRepositoryServicesResource {
    private OMRSRepositoryRESTServices restAPI = new OMRSRepositoryRESTServices(true);

    @RequestMapping(method={RequestMethod.GET}, path={"/metadata-collection-id"})
    public MetadataCollectionIdResponse getMetadataCollectionId(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getMetadataCollectionId(serverName, userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/all"})
    public TypeDefGalleryResponse getAllTypes(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getAllTypes(serverName, userId);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/by-name"})
    public TypeDefGalleryResponse findTypesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam String name) {
        return this.restAPI.findTypesByName(serverName, userId, name);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/typedefs/by-category"})
    public TypeDefListResponse findTypeDefsByCategory(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypeDefCategory category) {
        return this.restAPI.findTypeDefsByCategory(serverName, userId, category);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/attribute-typedefs/by-category"})
    public AttributeTypeDefListResponse findAttributeTypeDefsByCategory(@PathVariable String serverName, @PathVariable String userId, @RequestBody AttributeTypeDefCategory category) {
        return this.restAPI.findAttributeTypeDefsByCategory(serverName, userId, category);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/typedefs/by-property"})
    public TypeDefListResponse findTypeDefsByProperty(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypeDefProperties matchCriteria) {
        return this.restAPI.findTypeDefsByProperty(serverName, userId, matchCriteria);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/typedefs/by-external-id"})
    public TypeDefListResponse findTypesByExternalID(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false) String standard, @RequestParam(required=false) String organization, @RequestParam(required=false) String identifier) {
        return this.restAPI.findTypesByExternalID(serverName, userId, standard, organization, identifier);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/typedefs/by-property-value"})
    public TypeDefListResponse searchForTypeDefs(@PathVariable String serverName, @PathVariable String userId, @RequestParam String searchCriteria) {
        return this.restAPI.searchForTypeDefs(serverName, userId, searchCriteria);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/typedef/{guid}"})
    public TypeDefResponse getTypeDefByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getTypeDefByGUID(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/attribute-typedef/{guid}"})
    public AttributeTypeDefResponse getAttributeTypeDefByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getAttributeTypeDefByGUID(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/typedef/name/{name}"})
    public TypeDefResponse getTypeDefByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getTypeDefByName(serverName, userId, name);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/types/attribute-typedef/name/{name}"})
    public AttributeTypeDefResponse getAttributeTypeDefByName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getAttributeTypeDefByName(serverName, userId, name);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types"})
    public VoidResponse addTypeDefGallery(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypeDefGallery newTypes) {
        return this.restAPI.addTypeDefGallery(serverName, userId, newTypes);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/typedef"})
    public VoidResponse addTypeDef(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypeDef newTypeDef) {
        return this.restAPI.addTypeDef(serverName, userId, newTypeDef);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/attribute-typedef"})
    public VoidResponse addAttributeTypeDef(@PathVariable String serverName, @PathVariable String userId, @RequestBody AttributeTypeDef newAttributeTypeDef) {
        return this.restAPI.addAttributeTypeDef(serverName, userId, newAttributeTypeDef);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/typedef/compatibility"})
    public BooleanResponse verifyTypeDef(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypeDef typeDef) {
        return this.restAPI.verifyTypeDef(serverName, userId, typeDef);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/attribute-typedef/compatibility"})
    public BooleanResponse verifyAttributeTypeDef(@PathVariable String serverName, @PathVariable String userId, @RequestBody AttributeTypeDef attributeTypeDef) {
        return this.restAPI.verifyAttributeTypeDef(serverName, userId, attributeTypeDef);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/typedef/update"})
    public TypeDefResponse updateTypeDef(@PathVariable String serverName, @PathVariable String userId, @RequestBody TypeDefPatch typeDefPatch) {
        return this.restAPI.updateTypeDef(serverName, userId, typeDefPatch);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/typedef/{guid}/delete"})
    public VoidResponse deleteTypeDef(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam String name) {
        return this.restAPI.deleteTypeDef(serverName, userId, guid, name);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/attribute-typedef/{guid}/delete"})
    public VoidResponse deleteAttributeTypeDef(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestParam String name) {
        return this.restAPI.deleteAttributeTypeDef(serverName, userId, guid, name);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/typedef/{originalTypeDefGUID}/identifier"})
    public TypeDefResponse reIdentifyTypeDef(@PathVariable String serverName, @PathVariable String userId, @PathVariable String originalTypeDefGUID, @RequestBody TypeDefReIdentifyRequest requestParameters) {
        return this.restAPI.reIdentifyTypeDef(serverName, userId, originalTypeDefGUID, requestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/types/attribute-typedef/{originalAttributeTypeDefGUID}/identifier"})
    public AttributeTypeDefResponse reIdentifyAttributeTypeDef(@PathVariable String serverName, @PathVariable String userId, @PathVariable String originalAttributeTypeDefGUID, @RequestBody TypeDefReIdentifyRequest requestParameters) {
        return this.restAPI.reIdentifyAttributeTypeDef(serverName, userId, originalAttributeTypeDefGUID, requestParameters);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/entity/{guid}/existence"})
    public EntityDetailResponse isEntityKnown(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.isEntityKnown(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/entity/{guid}/summary"})
    public EntitySummaryResponse getEntitySummary(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getEntitySummary(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/entity/{guid}"})
    public EntityDetailResponse getEntityDetail(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getEntityDetail(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{guid}/history"})
    public EntityDetailResponse getEntityDetail(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody HistoryRequest asOfTime) {
        return this.restAPI.getEntityDetail(serverName, userId, guid, asOfTime);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/relationships"})
    public RelationshipListResponse getRelationshipsForEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestBody TypeLimitedFindRequest findRequestParameters) {
        return this.restAPI.getRelationshipsForEntity(serverName, userId, entityGUID, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/relationships/history"})
    public RelationshipListResponse getRelationshipsForEntityHistory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestBody TypeLimitedHistoricalFindRequest findRequestParameters) {
        return this.restAPI.getRelationshipsForEntityHistory(serverName, userId, entityGUID, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/by-property"})
    public EntityListResponse findEntitiesByProperty(@PathVariable String serverName, @PathVariable String userId, @RequestBody EntityPropertyFindRequest findRequestParameters) {
        return this.restAPI.findEntitiesByProperty(serverName, userId, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/by-property/history"})
    public EntityListResponse findEntitiesByPropertyHistory(@PathVariable String serverName, @PathVariable String userId, @RequestBody EntityPropertyHistoricalFindRequest findRequestParameters) {
        return this.restAPI.findEntitiesByPropertyHistory(serverName, userId, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/by-classification/{classificationName}"})
    public EntityListResponse findEntitiesByClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String classificationName, @RequestBody PropertyMatchFindRequest findRequestParameters) {
        return this.restAPI.findEntitiesByClassification(serverName, userId, classificationName, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/by-classification/{classificationName}/history"})
    public EntityListResponse findEntitiesByClassificationHistory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String classificationName, @RequestBody PropertyMatchHistoricalFindRequest findRequestParameters) {
        return this.restAPI.findEntitiesByClassificationHistory(serverName, userId, classificationName, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/by-property-value"})
    public EntityListResponse findEntitiesByPropertyValue(@PathVariable String serverName, @PathVariable String userId, @RequestParam String searchCriteria, @RequestBody EntityPropertyFindRequest findRequestParameters) {
        return this.restAPI.findEntitiesByPropertyValue(serverName, userId, searchCriteria, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/by-property-value/history"})
    public EntityListResponse findEntitiesByPropertyValueHistory(@PathVariable String serverName, @PathVariable String userId, @RequestParam String searchCriteria, @RequestBody EntityPropertyHistoricalFindRequest findRequestParameters) {
        return this.restAPI.findEntitiesByPropertyValueHistory(serverName, userId, searchCriteria, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/relationship/{guid}/existence"})
    public RelationshipResponse isRelationshipKnown(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.isRelationshipKnown(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/relationship/{guid}"})
    public RelationshipResponse getRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getRelationship(serverName, userId, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/relationship/{guid}/history"})
    public RelationshipResponse getRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String guid, @RequestBody HistoryRequest asOfTime) {
        return this.restAPI.getRelationship(serverName, userId, guid, asOfTime);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationships/by-property"})
    public RelationshipListResponse findRelationshipsByProperty(@PathVariable String serverName, @PathVariable String userId, @RequestBody PropertyMatchFindRequest findRequestParameters) {
        return this.restAPI.findRelationshipsByProperty(serverName, userId, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationships/by-property/history"})
    public RelationshipListResponse findRelationshipsByPropertyHistory(@PathVariable String serverName, @PathVariable String userId, @RequestBody PropertyMatchHistoricalFindRequest findRequestParameters) {
        return this.restAPI.findRelationshipsByPropertyHistory(serverName, userId, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationships/by-property-value"})
    public RelationshipListResponse findRelationshipsByPropertyValue(@PathVariable String serverName, @PathVariable String userId, @RequestParam String searchCriteria, @RequestBody TypeLimitedFindRequest findRequestParameters) {
        return this.restAPI.findRelationshipsByPropertyValue(serverName, userId, searchCriteria, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationships/by-property-value/history"})
    public RelationshipListResponse findRelationshipsByPropertyValueHistory(@PathVariable String serverName, @PathVariable String userId, @RequestParam String searchCriteria, @RequestBody TypeLimitedHistoricalFindRequest findRequestParameters) {
        return this.restAPI.findRelationshipsByPropertyValueHistory(serverName, userId, searchCriteria, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/from-entity/{startEntityGUID}/by-linkage"})
    public InstanceGraphResponse getLinkingEntities(@PathVariable String serverName, @PathVariable String userId, @PathVariable String startEntityGUID, @RequestParam String endEntityGUID, @RequestBody OMRSAPIFindRequest findRequestParameters) {
        return this.restAPI.getLinkingEntities(serverName, userId, startEntityGUID, endEntityGUID, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/from-entity/{startEntityGUID}/by-linkage/history"})
    public InstanceGraphResponse getLinkingEntitiesHistory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String startEntityGUID, @RequestParam String endEntityGUID, @RequestBody OMRSAPIHistoricalFindRequest findRequestParameters) {
        return this.restAPI.getLinkingEntitiesHistory(serverName, userId, startEntityGUID, endEntityGUID, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/from-entity/{entityGUID}/by-neighborhood"})
    public InstanceGraphResponse getEntityNeighborhood(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestParam int level, @RequestBody EntityNeighborhoodFindRequest findRequestParameters) {
        return this.restAPI.getEntityNeighborhood(serverName, userId, entityGUID, level, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/from-entity/{entityGUID}/by-neighborhood/history"})
    public InstanceGraphResponse getEntityNeighborhoodHistory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestParam int level, @RequestBody EntityNeighborhoodHistoricalFindRequest findRequestParameters) {
        return this.restAPI.getEntityNeighborhoodHistory(serverName, userId, entityGUID, level, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/from-entity/{startEntityGUID}/by-relationship"})
    public EntityListResponse getRelatedEntities(@PathVariable String serverName, @PathVariable String userId, @PathVariable String startEntityGUID, @RequestBody RelatedEntitiesFindRequest findRequestParameters) {
        return this.restAPI.getRelatedEntities(serverName, userId, startEntityGUID, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/from-entity/{startEntityGUID}/by-relationship/history"})
    public EntityListResponse getRelatedEntitiesHistory(@PathVariable String serverName, @PathVariable String userId, @PathVariable String startEntityGUID, @RequestBody RelatedEntitiesHistoricalFindRequest findRequestParameters) {
        return this.restAPI.getRelatedEntitiesHistory(serverName, userId, startEntityGUID, findRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity"})
    public EntityDetailResponse addEntity(@PathVariable String serverName, @PathVariable String userId, @RequestBody EntityCreateRequest requestBody) {
        return this.restAPI.addEntity(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/external"})
    public EntityDetailResponse addExternalEntity(@PathVariable String serverName, @PathVariable String userId, @RequestBody EntityCreateRequest requestBody) {
        return this.restAPI.addExternalEntity(serverName, userId, requestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity-proxy"})
    public VoidResponse addEntityProxy(@PathVariable String serverName, @PathVariable String userId, @RequestBody EntityProxy entityProxy) {
        return this.restAPI.addEntityProxy(serverName, userId, entityProxy);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/status"})
    public EntityDetailResponse updateEntityStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestBody InstanceStatus newStatus) {
        return this.restAPI.updateEntityStatus(serverName, userId, entityGUID, newStatus);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/properties"})
    public EntityDetailResponse updateEntityProperties(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestBody InstancePropertiesRequest propertiesRequestBody) {
        return this.restAPI.updateEntityProperties(serverName, userId, entityGUID, propertiesRequestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/entity/{entityGUID}/previous"})
    public EntityDetailResponse undoEntityUpdate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID) {
        return this.restAPI.undoEntityUpdate(serverName, userId, entityGUID);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{obsoleteEntityGUID}/delete"})
    public EntityDetailResponse deleteEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String obsoleteEntityGUID, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.deleteEntity(serverName, userId, obsoleteEntityGUID, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{deletedEntityGUID}/purge"})
    public VoidResponse purgeEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String deletedEntityGUID, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.purgeEntity(serverName, userId, deletedEntityGUID, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/entity/{deletedEntityGUID}/restore"})
    public EntityDetailResponse restoreEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String deletedEntityGUID) {
        return this.restAPI.restoreEntity(serverName, userId, deletedEntityGUID);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/classification/{classificationName}"})
    public EntityDetailResponse classifyEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @PathVariable String classificationName, @RequestBody InstancePropertiesRequest propertiesRequestBody) {
        return this.restAPI.classifyEntity(serverName, userId, entityGUID, classificationName, propertiesRequestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/classification/{classificationName}/delete"})
    public EntityDetailResponse declassifyEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @PathVariable String classificationName, @RequestBody OMRSAPIRequest requestBody) {
        return this.restAPI.declassifyEntity(serverName, userId, entityGUID, classificationName);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/classification/{classificationName}/properties"})
    public EntityDetailResponse updateEntityClassification(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @PathVariable String classificationName, @RequestBody InstancePropertiesRequest propertiesRequestBody) {
        return this.restAPI.updateEntityClassification(serverName, userId, entityGUID, classificationName, propertiesRequestBody);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship"})
    public RelationshipResponse addRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelationshipCreateRequest createRequestParameters) {
        return this.restAPI.addRelationship(serverName, userId, createRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship/external"})
    public RelationshipResponse addExternalRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody RelationshipCreateRequest createRequestParameters) {
        return this.restAPI.addExternalRelationship(serverName, userId, createRequestParameters);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship/{relationshipGUID}/status"})
    public RelationshipResponse updateRelationshipStatus(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody InstanceStatus newStatus) {
        return this.restAPI.updateRelationshipStatus(serverName, userId, relationshipGUID, newStatus);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship/{relationshipGUID}/properties"})
    public RelationshipResponse updateRelationshipProperties(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody InstancePropertiesRequest propertiesRequestBody) {
        return this.restAPI.updateRelationshipProperties(serverName, userId, relationshipGUID, propertiesRequestBody);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/relationship/{relationshipGUID}/previous"})
    public RelationshipResponse undoRelationshipUpdate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID) {
        return this.restAPI.undoRelationshipUpdate(serverName, userId, relationshipGUID);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship/{obsoleteRelationshipGUID}/delete"})
    public RelationshipResponse deleteRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String obsoleteRelationshipGUID, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.deleteRelationship(serverName, userId, obsoleteRelationshipGUID, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship/{deletedRelationshipGUID}/purge"})
    public VoidResponse purgeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String deletedRelationshipGUID, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.purgeRelationship(serverName, userId, deletedRelationshipGUID, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/relationship/{deletedRelationshipGUID}/restore"})
    public RelationshipResponse restoreRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String deletedRelationshipGUID) {
        return this.restAPI.restoreRelationship(serverName, userId, deletedRelationshipGUID);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/identity"})
    public EntityDetailResponse reIdentifyEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestParam String newEntityGUID, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.reIdentifyEntity(serverName, userId, entityGUID, newEntityGUID, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/type"})
    public EntityDetailResponse reTypeEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestBody TypeDefChangeRequest typeDefChangeRequest) {
        return this.restAPI.reTypeEntity(serverName, userId, entityGUID, typeDefChangeRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entity/{entityGUID}/home/{homeMetadataCollectionId}"})
    public EntityDetailResponse reHomeEntity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @PathVariable String homeMetadataCollectionId, @RequestParam String newHomeMetadataCollectionId, @RequestParam(required=false) String newHomeMetadataCollectionName, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.reHomeEntity(serverName, userId, entityGUID, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship/{relationshipGUID}/identity"})
    public RelationshipResponse reIdentifyRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestParam String newRelationshipGUID, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.reIdentifyRelationship(serverName, userId, relationshipGUID, newRelationshipGUID, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship/{relationshipGUID}/type"})
    public RelationshipResponse reTypeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestBody TypeDefChangeRequest typeDefChangeRequest) {
        return this.restAPI.reTypeRelationship(serverName, userId, relationshipGUID, typeDefChangeRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationship/{relationshipGUID}/home"})
    public RelationshipResponse reHomeRelationship(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestParam String homeMetadataCollectionId, @RequestParam String newHomeMetadataCollectionId, @RequestParam(required=false) String newHomeMetadataCollectionName, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.reHomeRelationship(serverName, userId, relationshipGUID, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/reference-copy"})
    public VoidResponse saveEntityReferenceCopy(@PathVariable String serverName, @PathVariable String userId, @RequestBody EntityDetail entity) {
        return this.restAPI.saveEntityReferenceCopy(serverName, userId, entity);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/reference-copy/{entityGUID}/purge"})
    public VoidResponse purgeEntityReferenceCopy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestParam String homeMetadataCollectionId, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.purgeEntityReferenceCopy(serverName, userId, entityGUID, homeMetadataCollectionId, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/entities/reference-copy/{entityGUID}/refresh"})
    public VoidResponse refreshEntityReferenceCopy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String entityGUID, @RequestParam String homeMetadataCollectionId, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.refreshEntityReferenceCopy(serverName, userId, entityGUID, homeMetadataCollectionId, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationships/reference-copy"})
    public VoidResponse saveRelationshipReferenceCopy(@PathVariable String serverName, @PathVariable String userId, @RequestBody Relationship relationship) {
        return this.restAPI.saveRelationshipReferenceCopy(serverName, userId, relationship);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationships/reference-copy/{relationshipGUID}/purge"})
    public VoidResponse purgeRelationshipReferenceCopy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestParam String homeMetadataCollectionId, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.purgeRelationshipReferenceCopy(serverName, userId, relationshipGUID, homeMetadataCollectionId, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances/relationships/reference-copy/{relationshipGUID}/refresh"})
    public VoidResponse refreshRelationshipReferenceCopy(@PathVariable String serverName, @PathVariable String userId, @PathVariable String relationshipGUID, @RequestParam String homeMetadataCollectionId, @RequestBody TypeDefValidationForRequest typeDefValidationForRequest) {
        return this.restAPI.refreshRelationshipReferenceCopy(serverName, userId, relationshipGUID, homeMetadataCollectionId, typeDefValidationForRequest);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/instances"})
    public VoidResponse saveInstanceReferenceCopies(@PathVariable String serverName, @PathVariable String userId, @RequestBody InstanceGraphRequest instances) {
        return this.restAPI.saveInstanceReferenceCopies(serverName, userId, instances);
    }
}

