/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server.spring;

import org.odpi.openmetadata.repositoryservices.rest.properties.EntityDetailResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.MetadataCollectionIdResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipResponse;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSRepositoryRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/repository-services"})
public class AnonRepositoryServicesResource {
    private OMRSRepositoryRESTServices restAPI = new OMRSRepositoryRESTServices(true);

    @RequestMapping(method={RequestMethod.GET}, path={"/metadata-collection-id"})
    public MetadataCollectionIdResponse getMetadataCollectionId(@PathVariable String serverName) {
        MetadataCollectionIdResponse response = this.restAPI.getMetadataCollectionId(serverName);
        return response;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/entity/{guid}"})
    public EntityDetailResponse getEntityDetail(@PathVariable String serverName, @PathVariable String guid) {
        return this.restAPI.getEntityDetail(serverName, null, guid);
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/instances/relationship/{guid}"})
    public RelationshipResponse getRelationship(@PathVariable String serverName, @PathVariable String guid) {
        return this.restAPI.getRelationship(serverName, null, guid);
    }
}

