/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server.spring;

import org.odpi.openmetadata.repositoryservices.rest.properties.CohortListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipResponse;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSMetadataHighwayRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/repository-services/users/{userId}/metadata-highway"})
public class MetadataHighwayServicesResource {
    private OMRSMetadataHighwayRESTServices restAPI = new OMRSMetadataHighwayRESTServices();

    @GetMapping(path={"/cohort-descriptions"})
    public CohortListResponse getCohorts(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getCohortList(serverName, userId);
    }

    @GetMapping(path={"/local-registration"})
    public CohortMembershipResponse getLocalRegistration(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getLocalRegistration(serverName, userId);
    }

    @GetMapping(path={"/cohorts/{cohortName}/local-registration"})
    public CohortMembershipResponse getLocalRegistration(@PathVariable String serverName, @PathVariable String userId, @PathVariable String cohortName) {
        return this.restAPI.getLocalRegistration(serverName, userId, cohortName);
    }

    @GetMapping(path={"/cohorts/{cohortName}/remote-members"})
    public CohortMembershipListResponse getRemoteRegistrations(@PathVariable String serverName, @PathVariable String userId, @PathVariable String cohortName) {
        return this.restAPI.getRemoteRegistrations(serverName, userId, cohortName);
    }
}

