/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.repositoryservices.rest.properties.AuditLogReportResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.AuditLogSeveritiesResponse;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSAuditLogRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/repository-services/users/{userId}/audit-log"})
@Tag(name="Repository Services - Audit Log", description="Details of the activity within an OMAG Server are written to the server's configured audit log destinations.  This service retrieves information about the audit log and its contents for a particular server.", externalDocs=@ExternalDocumentation(description="Further information", url="https://egeria-project.org/services/omrs/"))
public class AuditLogServicesResource {
    private final OMRSAuditLogRESTServices restAPI = new OMRSAuditLogRESTServices();

    @GetMapping(path={"/severity-definitions"})
    @Operation(summary="getSeverityList", description="Return the details of the severities that this server supports.", externalDocs=@ExternalDocumentation(description="Audit Log", url="https://egeria-project.org/concepts/audit-log/"))
    public AuditLogSeveritiesResponse getSeverityList(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getSeverityList(serverName, userId);
    }

    @GetMapping(path={"/report"})
    @Operation(summary="getAuditLogReport", description="Return the report from the local server's audit log.", externalDocs=@ExternalDocumentation(description="Audit Log", url="https://egeria-project.org/concepts/audit-log/"))
    public AuditLogReportResponse getAuditLogReport(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getAuditLogReport(serverName, userId);
    }
}

