/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions;

import java.util.Objects;

public abstract class RESTClientCheckedExceptionBase
extends Exception {
    private final int reportedHTTPCode;
    private final String reportingClassName;
    private final String reportingActionDescription;
    private final String reportedErrorMessage;
    private final String reportedSystemAction;
    private final String reportedUserAction;
    private Exception reportedCaughtException = null;

    public RESTClientCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
    }

    public RESTClientCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Exception caughtError) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
    }

    public int getReportedHTTPCode() {
        return this.reportedHTTPCode;
    }

    public String getReportingClassName() {
        return this.reportingClassName;
    }

    public String getReportingActionDescription() {
        return this.reportingActionDescription;
    }

    public String getErrorMessage() {
        return this.reportedErrorMessage;
    }

    public String getReportedSystemAction() {
        return this.reportedSystemAction;
    }

    public String getReportedUserAction() {
        return this.reportedUserAction;
    }

    public Exception getReportedCaughtException() {
        return this.reportedCaughtException;
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof RESTClientCheckedExceptionBase)) {
            return false;
        }
        RESTClientCheckedExceptionBase that = (RESTClientCheckedExceptionBase)objectToCompare;
        return this.getReportedHTTPCode() == that.getReportedHTTPCode() && Objects.equals(this.getReportingClassName(), that.getReportingClassName()) && Objects.equals(this.getReportingActionDescription(), that.getReportingActionDescription()) && Objects.equals(this.getErrorMessage(), that.getErrorMessage()) && Objects.equals(this.getReportedSystemAction(), that.getReportedSystemAction()) && Objects.equals(this.getReportedUserAction(), that.getReportedUserAction()) && Objects.equals(this.getReportedCaughtException(), that.getReportedCaughtException());
    }

    public int hashCode() {
        return Objects.hash(this.getReportedHTTPCode(), this.getReportingClassName(), this.getReportingActionDescription(), this.getErrorMessage(), this.getReportedSystemAction(), this.getReportedUserAction(), this.getReportedCaughtException());
    }
}

