/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.rex.admin;

import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceAdmin;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.viewservices.rex.api.ffdc.RexViewAuditCode;
import org.odpi.openmetadata.viewservices.rex.server.RexViewServicesInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexViewAdmin
extends ViewServiceAdmin {
    private static final Logger log = LoggerFactory.getLogger(RexViewAdmin.class);
    private AuditLog auditLog = null;
    private String serverUserName = null;
    private RexViewServicesInstance instance = null;
    private String serverName = null;

    public void initialize(String serverName, ViewServiceConfig viewServiceConfig, AuditLog auditLog, String serverUserName, int maxPageSize) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", RexViewAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        if (log.isDebugEnabled()) {
            log.debug("==> Method: initialize, userid=" + serverUserName);
        }
        try {
            this.instance = new RexViewServicesInstance(serverName, auditLog, serverUserName, maxPageSize);
            this.serverUserName = serverUserName;
            this.serverName = serverName;
            auditLog.logMessage("initialize", RexViewAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{serverName}), viewServiceConfig.toString());
            if (log.isDebugEnabled()) {
                log.debug("<== Method: initialize,userid=" + serverUserName);
            }
        }
        catch (Throwable error) {
            auditLog.logException("initialize", RexViewAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), viewServiceConfig.toString(), error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.ASSET_OWNER_OMAS.getAccessServiceFullName(), error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        log.debug("==> Method: shutdown, userid=" + this.serverUserName);
        this.auditLog.logMessage("shutdown", RexViewAuditCode.SERVICE_TERMINATING.getMessageDefinition(new String[]{this.serverName}));
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", RexViewAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
        log.debug("<== Method: shutdown, userid=" + this.serverUserName);
    }
}

