/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.rex.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.clients.EnterpriseRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.clients.LocalRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.rex.api.properties.ClassificationExplorer;
import org.odpi.openmetadata.viewservices.rex.api.properties.EntityExplorer;
import org.odpi.openmetadata.viewservices.rex.api.properties.RelationshipExplorer;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexEntityDigest;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexExpandedEntityDetail;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexExpandedRelationship;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexPreTraversal;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexRelationshipDigest;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexTraversal;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexTypeStats;
import org.odpi.openmetadata.viewservices.rex.api.properties.TypeExplorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexViewHandler {
    private static final Logger log = LoggerFactory.getLogger(RexViewHandler.class);
    private static final int TRUNCATED_STRING_LENGTH = 24;

    public TypeExplorer getTypeExplorer(String userId, String repositoryServerName, String repositoryServerURLRoot, boolean enterpriseOption, String methodName) throws RepositoryErrorException, InvalidParameterException, UserNotAuthorizedException {
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot) : this.getEnterpriseRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot);
        TypeExplorer tex = new TypeExplorer();
        TypeDefGallery typeDefGallery = repositoryServicesClient.getAllTypes(userId);
        ArrayList typeDefs = typeDefGallery.getTypeDefs();
        for (TypeDef typeDef : typeDefs) {
            TypeDefCategory tdCat = typeDef.getCategory();
            switch (tdCat) {
                case ENTITY_DEF: {
                    EntityExplorer eex = new EntityExplorer((EntityDef)typeDef);
                    tex.addEntityExplorer(typeDef.getName(), eex);
                    break;
                }
                case RELATIONSHIP_DEF: {
                    RelationshipExplorer rex = new RelationshipExplorer((RelationshipDef)typeDef);
                    tex.addRelationshipExplorer(typeDef.getName(), rex);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    ClassificationExplorer cex = new ClassificationExplorer((ClassificationDef)typeDef);
                    tex.addClassificationExplorer(typeDef.getName(), cex);
                    break;
                }
            }
        }
        List attributeTypeDefs = typeDefGallery.getAttributeTypeDefs();
        for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
            AttributeTypeDefCategory tdCat = attributeTypeDef.getCategory();
            switch (tdCat) {
                case ENUM_DEF: {
                    tex.addEnumExplorer(attributeTypeDef.getName(), (EnumDef)attributeTypeDef);
                    break;
                }
            }
        }
        tex.resolve();
        return tex;
    }

    public RexExpandedEntityDetail getEntity(String userId, String repositoryServerName, String repositoryServerURLRoot, boolean enterpriseOption, String entityGUID, String methodName) throws RepositoryErrorException, InvalidParameterException, UserNotAuthorizedException, EntityNotKnownException, EntityProxyOnlyException {
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot) : this.getEnterpriseRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot);
        EntityDetail entityDetail = repositoryServicesClient.getEntityDetail(userId, entityGUID);
        TypeExplorer typeExplorer = this.getTypeExplorer(userId, repositoryServerName, repositoryServerURLRoot, enterpriseOption, methodName);
        String label = this.chooseLabelForEntity(entityDetail, typeExplorer);
        RexExpandedEntityDetail rexExpEntityDetail = new RexExpandedEntityDetail(entityDetail, label, repositoryServerName);
        return rexExpEntityDetail;
    }

    public RexExpandedRelationship getRelationship(String userId, String repositoryServerName, String repositoryServerURLRoot, boolean enterpriseOption, String relationshipGUID, String methodName) throws RepositoryErrorException, InvalidParameterException, UserNotAuthorizedException, RelationshipNotKnownException {
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot) : this.getEnterpriseRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot);
        Relationship relationship = repositoryServicesClient.getRelationship(userId, relationshipGUID);
        TypeExplorer typeExplorer = this.getTypeExplorer(userId, repositoryServerName, repositoryServerURLRoot, enterpriseOption, methodName);
        EntityProxy entity1 = relationship.getEntityOneProxy();
        EntityProxy entity2 = relationship.getEntityTwoProxy();
        String label1 = this.chooseLabelForEntityProxy(entity1, typeExplorer);
        String label2 = this.chooseLabelForEntityProxy(entity2, typeExplorer);
        RexEntityDigest digest1 = new RexEntityDigest(entity1.getGUID(), label1, Integer.valueOf(0), entity1.getMetadataCollectionName());
        RexEntityDigest digest2 = new RexEntityDigest(entity2.getGUID(), label2, Integer.valueOf(0), entity2.getMetadataCollectionName());
        String label = this.chooseLabelForRelationship(relationship);
        RexExpandedRelationship rexExpRelationship = new RexExpandedRelationship(relationship, label, digest1, digest2, repositoryServerName);
        return rexExpRelationship;
    }

    public Map<String, RexEntityDigest> findEntities(String userId, String repositoryServerName, String repositoryServerURLRoot, boolean enterpriseOption, String searchText, String entityTypeName, List<String> classificationNames, String methodName) throws RepositoryErrorException, InvalidParameterException, UserNotAuthorizedException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot) : this.getEnterpriseRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot);
        TypeExplorer typeExplorer = this.getTypeExplorer(userId, repositoryServerName, repositoryServerURLRoot, enterpriseOption, methodName);
        String entityTypeGUID = typeExplorer.getEntityTypeGUID(entityTypeName);
        List entities = repositoryServicesClient.findEntitiesByPropertyValue(userId, entityTypeGUID, searchText, 0, null, classificationNames, null, null, null, 0);
        if (entities != null) {
            HashMap<String, RexEntityDigest> digestMap = new HashMap<String, RexEntityDigest>();
            for (int e = 0; e < entities.size(); ++e) {
                EntityDetail entityDetail = (EntityDetail)entities.get(e);
                String label = this.chooseLabelForEntity(entityDetail, typeExplorer);
                RexEntityDigest entityDigest = new RexEntityDigest(entityDetail.getGUID(), label, Integer.valueOf(0), entityDetail.getMetadataCollectionName());
                digestMap.put(entityDetail.getGUID(), entityDigest);
            }
            return digestMap;
        }
        return null;
    }

    public Map<String, RexRelationshipDigest> findRelationships(String userId, String repositoryServerName, String repositoryServerURLRoot, boolean enterpriseOption, String searchText, String relationshipTypeName, String methodName) throws RepositoryErrorException, InvalidParameterException, UserNotAuthorizedException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException {
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot) : this.getEnterpriseRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot);
        TypeExplorer typeExplorer = this.getTypeExplorer(userId, repositoryServerName, repositoryServerURLRoot, enterpriseOption, methodName);
        String relationshipTypeGUID = typeExplorer.getEntityTypeGUID(relationshipTypeName);
        List relationships = repositoryServicesClient.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchText, 0, null, null, null, null, 0);
        if (relationships != null) {
            HashMap<String, RexRelationshipDigest> digestMap = new HashMap<String, RexRelationshipDigest>();
            for (int r = 0; r < relationships.size(); ++r) {
                Relationship relationship = (Relationship)relationships.get(r);
                String label = this.chooseLabelForRelationship(relationship);
                RexRelationshipDigest relationshipDigest = new RexRelationshipDigest(relationship.getGUID(), label, relationship.getEntityOneProxy().getGUID(), relationship.getEntityTwoProxy().getGUID(), Integer.valueOf(0), Integer.valueOf(0), relationship.getMetadataCollectionName());
                digestMap.put(relationship.getGUID(), relationshipDigest);
            }
            return digestMap;
        }
        return null;
    }

    public RexPreTraversal preTraversal(String userId, String repositoryServerName, String repositoryServerURLRoot, boolean enterpriseOption, String entityGUID, int depth, String methodName) throws RepositoryErrorException, InvalidParameterException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException, TypeErrorException, PropertyErrorException, FunctionNotSupportedException {
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot) : this.getEnterpriseRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot);
        TypeExplorer typeExplorer = this.getTypeExplorer(userId, repositoryServerName, repositoryServerURLRoot, enterpriseOption, methodName);
        InstanceGraph instGraph = null;
        if (depth > 0) {
            instGraph = repositoryServicesClient.getEntityNeighborhood(userId, entityGUID, null, null, null, null, null, depth);
        } else {
            EntityDetail entityDetail = repositoryServicesClient.getEntityDetail(userId, entityGUID);
            instGraph = new InstanceGraph();
            ArrayList<EntityDetail> entityDetailList = new ArrayList<EntityDetail>();
            entityDetailList.add(entityDetail);
            instGraph.setEntities(entityDetailList);
        }
        RexPreTraversal rexPreTraversal = new RexPreTraversal();
        rexPreTraversal.setEntityGUID(entityGUID);
        rexPreTraversal.setDepth(Integer.valueOf(depth));
        List entities = instGraph.getEntities();
        HashMap<String, RexTypeStats> entityCountsByType = new HashMap<String, RexTypeStats>();
        HashMap<String, RexTypeStats> classificationCountsByType = new HashMap<String, RexTypeStats>();
        if (entities != null) {
            for (EntityDetail ent : entities) {
                List classifications;
                if (ent.getGUID().equals(entityGUID)) continue;
                InstanceType instanceType = ent.getType();
                String typeGUID = instanceType.getTypeDefGUID();
                String typeName = instanceType.getTypeDefName();
                if (entityCountsByType.get(typeName) == null) {
                    RexTypeStats stats = new RexTypeStats(typeGUID, Integer.valueOf(1));
                    entityCountsByType.put(typeName, stats);
                } else {
                    Integer existingCount = ((RexTypeStats)entityCountsByType.get(typeName)).getCount();
                    ((RexTypeStats)entityCountsByType.get(typeName)).setCount(Integer.valueOf(existingCount + 1));
                }
                if ((classifications = ent.getClassifications()) == null) continue;
                for (Classification classification : classifications) {
                    String classificationName = classification.getName();
                    if (classificationCountsByType.get(classificationName) == null) {
                        RexTypeStats stats = new RexTypeStats(null, Integer.valueOf(1));
                        classificationCountsByType.put(classificationName, stats);
                        continue;
                    }
                    Integer existingCount = ((RexTypeStats)classificationCountsByType.get(classificationName)).getCount();
                    ((RexTypeStats)classificationCountsByType.get(classificationName)).setCount(Integer.valueOf(existingCount + 1));
                }
            }
        }
        List relationships = instGraph.getRelationships();
        HashMap<String, RexTypeStats> relationshipCountsByType = new HashMap<String, RexTypeStats>();
        if (relationships != null) {
            for (Relationship rel : relationships) {
                InstanceType instanceType = rel.getType();
                String typeGUID = instanceType.getTypeDefGUID();
                String typeName = instanceType.getTypeDefName();
                if (relationshipCountsByType.get(typeName) == null) {
                    RexTypeStats stats = new RexTypeStats(typeGUID, Integer.valueOf(1));
                    relationshipCountsByType.put(typeName, stats);
                    continue;
                }
                Integer existingCount = ((RexTypeStats)relationshipCountsByType.get(typeName)).getCount();
                ((RexTypeStats)relationshipCountsByType.get(typeName)).setCount(Integer.valueOf(existingCount + 1));
            }
        }
        rexPreTraversal.setEntityInstanceCounts(entityCountsByType);
        rexPreTraversal.setRelationshipInstanceCounts(relationshipCountsByType);
        rexPreTraversal.setClassificationInstanceCounts(classificationCountsByType);
        return rexPreTraversal;
    }

    public RexTraversal traversal(String userId, String repositoryServerName, String repositoryServerURLRoot, boolean enterpriseOption, String entityGUID, int depth, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<String> classificationNames, String methodName) throws RepositoryErrorException, InvalidParameterException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException, TypeErrorException, PropertyErrorException, FunctionNotSupportedException {
        Object repositoryServicesClient = !enterpriseOption ? this.getLocalRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot) : this.getEnterpriseRepositoryServicesClient(repositoryServerName, repositoryServerURLRoot);
        TypeExplorer typeExplorer = this.getTypeExplorer(userId, repositoryServerName, repositoryServerURLRoot, enterpriseOption, methodName);
        InstanceGraph instGraph = null;
        if (depth > 0) {
            instGraph = repositoryServicesClient.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, null, classificationNames, null, depth);
        } else {
            EntityDetail entityDetail = repositoryServicesClient.getEntityDetail(userId, entityGUID);
            instGraph = new InstanceGraph();
            ArrayList<EntityDetail> entityDetailList = new ArrayList<EntityDetail>();
            entityDetailList.add(entityDetail);
            instGraph.setEntities(entityDetailList);
        }
        if (instGraph != null) {
            RexTraversal rt = new RexTraversal();
            List entities = instGraph.getEntities();
            HashMap<Object, RexEntityDigest> entityDigestMap = null;
            if (entities != null && !entities.isEmpty()) {
                entityDigestMap = new HashMap<Object, RexEntityDigest>();
                for (EntityDetail entityDetail : entities) {
                    String entGUID = entityDetail.getGUID();
                    String entLabel = this.chooseLabelForEntity(entityDetail, typeExplorer);
                    RexEntityDigest red = new RexEntityDigest(entGUID, entLabel, Integer.valueOf(0), entityDetail.getMetadataCollectionName());
                    entityDigestMap.put(entGUID, red);
                }
            }
            List relationships = instGraph.getRelationships();
            HashMap<String, RexRelationshipDigest> relationshipDigestMap = null;
            if (relationships != null && !relationships.isEmpty()) {
                relationshipDigestMap = new HashMap<String, RexRelationshipDigest>();
                for (Relationship relationship : relationships) {
                    RexEntityDigest red;
                    String relGUID = relationship.getGUID();
                    String relLabel = this.chooseLabelForRelationship(relationship);
                    String end1GUID = relationship.getEntityOneProxy().getGUID();
                    String end2GUID = relationship.getEntityTwoProxy().getGUID();
                    if (entityDigestMap.get(end1GUID) == null) {
                        EntityProxy end1Proxy = relationship.getEntityOneProxy();
                        String end1Label = this.chooseLabelForEntityProxy(end1Proxy, typeExplorer);
                        red = new RexEntityDigest(end1GUID, end1Label, Integer.valueOf(0), end1Proxy.getMetadataCollectionName());
                        entityDigestMap.put(end1GUID, red);
                    }
                    if (entityDigestMap.get(end2GUID) == null) {
                        EntityProxy end2Proxy = relationship.getEntityTwoProxy();
                        String end2Label = this.chooseLabelForEntityProxy(end2Proxy, typeExplorer);
                        red = new RexEntityDigest(end2GUID, end2Label, Integer.valueOf(0), end2Proxy.getMetadataCollectionName());
                        entityDigestMap.put(end2GUID, red);
                    }
                    int idx = 0;
                    RexRelationshipDigest rrd = new RexRelationshipDigest(relGUID, relLabel, end1GUID, end2GUID, Integer.valueOf(idx), Integer.valueOf(0), relationship.getMetadataCollectionName());
                    relationshipDigestMap.put(relGUID, rrd);
                }
            }
            rt.setEntityGUID(entityGUID);
            rt.setDepth(Integer.valueOf(depth));
            rt.setGen(Integer.valueOf(0));
            ArrayList<String> entityTypeNames = new ArrayList<String>();
            if (entityTypeGUIDs != null && !entityTypeGUIDs.isEmpty()) {
                for (String entityTypeGUID : entityTypeGUIDs) {
                    String entityTypeName = typeExplorer.getEntityTypeName(entityTypeGUID);
                    entityTypeNames.add(entityTypeName);
                }
            }
            rt.setEntityTypeNames(entityTypeNames);
            rt.setRelationshipTypeGUIDs(relationshipTypeGUIDs);
            rt.setClassificationNames(classificationNames);
            rt.setEntities(entityDigestMap);
            rt.setRelationships(relationshipDigestMap);
            rt.setServerName(repositoryServerName);
            return rt;
        }
        String excMsg = "Could not retrieve subgraph for entity with guid" + entityGUID;
        return null;
    }

    private LocalRepositoryServicesClient getLocalRepositoryServicesClient(String serverName, String serverURLRoot) throws InvalidParameterException {
        String restURLRoot = serverURLRoot + "/servers/" + serverName;
        LocalRepositoryServicesClient client = new LocalRepositoryServicesClient(serverName, restURLRoot);
        return client;
    }

    private EnterpriseRepositoryServicesClient getEnterpriseRepositoryServicesClient(String serverName, String serverURLRoot) throws InvalidParameterException {
        String restURLRoot = serverURLRoot + "/servers/" + serverName;
        EnterpriseRepositoryServicesClient client = new EnterpriseRepositoryServicesClient(serverName, restURLRoot);
        return client;
    }

    private String chooseLabelForEntity(EntityDetail entityDetail, TypeExplorer typeExplorer) {
        String effTypeName;
        String label = entityDetail.getGUID();
        String instanceTypeName = null;
        InstanceType instanceType = entityDetail.getType();
        if (instanceType != null) {
            instanceTypeName = instanceType.getTypeDefName();
        }
        if (instanceTypeName == null || instanceTypeName.equals("")) {
            return label;
        }
        Map entityTypes = typeExplorer.getEntities();
        EntityExplorer eex = (EntityExplorer)entityTypes.get(instanceTypeName);
        TypeDefLink superType = eex.getEntityDef().getSuperType();
        while (superType != null) {
            String superTypeName = superType.getName();
            eex = (EntityExplorer)entityTypes.get(superTypeName);
            superType = eex.getEntityDef().getSuperType();
        }
        EntityDef effectiveTypeDef = eex.getEntityDef();
        switch (effTypeName = effectiveTypeDef.getName()) {
            case "InformalTag": {
                if (entityDetail.getProperties() == null || entityDetail.getProperties().getInstanceProperties() == null || entityDetail.getProperties().getInstanceProperties().get("tagName") == null || ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("tagName")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("tagName")).valueAsString();
                break;
            }
            case "Like": 
            case "Rating": {
                if (entityDetail.getCreatedBy() == null) break;
                label = entityDetail.getCreatedBy();
                break;
            }
            case "DataField": {
                if (entityDetail.getProperties() == null || entityDetail.getProperties().getInstanceProperties() == null || entityDetail.getProperties().getInstanceProperties().get("dataFieldName") == null || ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("dataFieldName")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("dataFieldName")).valueAsString();
                break;
            }
            case "Annotation": 
            case "AnnotationReview": {
                if (instanceTypeName == null) break;
                label = instanceTypeName;
                break;
            }
            case "LastAttachment": {
                if (entityDetail.getProperties() == null || entityDetail.getProperties().getInstanceProperties() == null || entityDetail.getProperties().getInstanceProperties().get("attachmentType") == null || ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("attachmentType")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("attachmentType")).valueAsString();
                break;
            }
            default: {
                String tailQN;
                if (entityDetail.getProperties() != null && entityDetail.getProperties().getInstanceProperties() != null && entityDetail.getProperties().getInstanceProperties().get("displayName") != null && ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("displayName")).valueAsString() != null) {
                    label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("displayName")).valueAsString();
                    break;
                }
                if (entityDetail.getProperties() != null && entityDetail.getProperties().getInstanceProperties() != null && entityDetail.getProperties().getInstanceProperties().get("name") != null && ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("name")).valueAsString() != null) {
                    label = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("name")).valueAsString();
                    break;
                }
                if (entityDetail.getProperties() == null || entityDetail.getProperties().getInstanceProperties() == null || entityDetail.getProperties().getInstanceProperties().get("qualifiedName") == null) break;
                String fullQN = ((InstancePropertyValue)entityDetail.getProperties().getInstanceProperties().get("qualifiedName")).valueAsString();
                int lengthQN = fullQN.length();
                label = lengthQN > 24 ? (tailQN = "..." + fullQN.substring(lengthQN - 24, lengthQN)) : fullQN;
            }
        }
        return label;
    }

    private String chooseLabelForEntityProxy(EntityProxy entityProxy, TypeExplorer typeExplorer) {
        String effTypeName;
        String label = entityProxy.getGUID();
        String instanceTypeName = null;
        InstanceType instanceType = entityProxy.getType();
        if (instanceType != null) {
            instanceTypeName = instanceType.getTypeDefName();
        }
        if (instanceTypeName == null || instanceTypeName.equals("")) {
            return label;
        }
        Map entityTypes = typeExplorer.getEntities();
        EntityExplorer eex = (EntityExplorer)entityTypes.get(instanceTypeName);
        TypeDefLink superType = eex.getEntityDef().getSuperType();
        while (superType != null) {
            String superTypeName = superType.getName();
            eex = (EntityExplorer)entityTypes.get(superTypeName);
            superType = eex.getEntityDef().getSuperType();
        }
        EntityDef effectiveTypeDef = eex.getEntityDef();
        switch (effTypeName = effectiveTypeDef.getName()) {
            case "InformalTag": {
                if (entityProxy.getUniqueProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties().get("tagName") == null || ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("tagName")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("tagName")).valueAsString();
                break;
            }
            case "Like": 
            case "Rating": {
                if (entityProxy.getCreatedBy() == null) break;
                label = entityProxy.getCreatedBy();
                break;
            }
            case "DataField": {
                if (entityProxy.getUniqueProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties().get("dataFieldName") == null || ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("dataFieldName")).valueAsString() == null) break;
                label = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("dataFieldName")).valueAsString();
                break;
            }
            case "Annotation": 
            case "AnnotationReview": {
                if (instanceTypeName == null) break;
                label = instanceTypeName;
                break;
            }
            default: {
                String tailQN;
                if (entityProxy.getUniqueProperties() != null && entityProxy.getUniqueProperties().getInstanceProperties() != null && entityProxy.getUniqueProperties().getInstanceProperties().get("displayName") != null && ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("displayName")).valueAsString() != null) {
                    label = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("displayName")).valueAsString();
                    break;
                }
                if (entityProxy.getUniqueProperties() != null && entityProxy.getUniqueProperties().getInstanceProperties() != null && entityProxy.getUniqueProperties().getInstanceProperties().get("name") != null && ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("name")).valueAsString() != null) {
                    label = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("name")).valueAsString();
                    break;
                }
                if (entityProxy.getUniqueProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties() == null || entityProxy.getUniqueProperties().getInstanceProperties().get("qualifiedName") == null) break;
                String fullQN = ((InstancePropertyValue)entityProxy.getUniqueProperties().getInstanceProperties().get("qualifiedName")).valueAsString();
                int lengthQN = fullQN.length();
                label = lengthQN > 24 ? (tailQN = "..." + fullQN.substring(lengthQN - 24, lengthQN)) : fullQN;
            }
        }
        return label;
    }

    private String chooseLabelForRelationship(Relationship relationship) {
        String label = relationship.getGUID();
        String instanceTypeName = null;
        InstanceType instanceType = relationship.getType();
        if (instanceType != null) {
            instanceTypeName = instanceType.getTypeDefName();
        }
        if (instanceTypeName == null || instanceTypeName.equals("")) {
            return label;
        }
        label = instanceTypeName;
        return label;
    }
}

