/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.rex.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexPreTraversal;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexTraversal;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexEntityDetailResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexEntityRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexPreTraversalResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexRelationshipRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexRelationshipResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexSearchBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexSearchResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTraversalRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTraversalResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTypesRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.TypeExplorerResponse;
import org.odpi.openmetadata.viewservices.rex.handlers.RexViewHandler;
import org.odpi.openmetadata.viewservices.rex.server.RexViewInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexViewRESTServices {
    protected static RexViewInstanceHandler instanceHandler = new RexViewInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(RexViewRESTServices.class), instanceHandler.getServiceName());
    private static final Logger log = LoggerFactory.getLogger(RexViewRESTServices.class);

    public TypeExplorerResponse getTypeExplorer(String serverName, String userId, RexTypesRequestBody requestBody) {
        String methodName = "getTypeExplorer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypeExplorer");
        TypeExplorerResponse response = new TypeExplorerResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypeExplorer");
            if (requestBody != null) {
                RexViewHandler handler = instanceHandler.getRexViewHandler(userId, serverName, "getTypeExplorer");
                response.setTypeExplorer(handler.getTypeExplorer(userId, requestBody.getServerName(), requestBody.getServerRootURL(), requestBody.getEnterpriseOption(), "getTypeExplorer"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getTypeExplorer", auditLog);
        }
        log.debug("Returning from method: getTypeExplorer with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexEntityDetailResponse getEntity(String serverName, String userId, RexEntityRequestBody requestBody) {
        String methodName = "getEntity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEntity");
        RexEntityDetailResponse response = new RexEntityDetailResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getEntity");
            if (requestBody != null) {
                RexViewHandler handler = instanceHandler.getRexViewHandler(userId, serverName, "getEntity");
                response.setExpandedEntityDetail(handler.getEntity(userId, requestBody.getServerName(), requestBody.getServerRootURL(), requestBody.getEnterpriseOption(), requestBody.getEntityGUID(), "getEntity"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getEntity", auditLog);
        }
        log.debug("Returning from method: getEntity with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexRelationshipResponse getRelationship(String serverName, String userId, RexRelationshipRequestBody requestBody) {
        String methodName = "getRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelationship");
        RexRelationshipResponse response = new RexRelationshipResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelationship");
            if (requestBody != null) {
                RexViewHandler handler = instanceHandler.getRexViewHandler(userId, serverName, "getRelationship");
                response.setExpandedRelationship(handler.getRelationship(userId, requestBody.getServerName(), requestBody.getServerRootURL(), requestBody.getEnterpriseOption(), requestBody.getRelationshipGUID(), "getRelationship"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getRelationship", auditLog);
        }
        log.debug("Returning from method: getRelationship with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexSearchResponse findEntities(String serverName, String userId, RexSearchBody requestBody) {
        String methodName = "findEntities";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEntities");
        RexSearchResponse response = new RexSearchResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findEntities");
            if (requestBody != null) {
                RexViewHandler handler = instanceHandler.getRexViewHandler(userId, serverName, "findEntities");
                response.setEntities(handler.findEntities(userId, requestBody.getServerName(), requestBody.getServerRootURL(), requestBody.getEnterpriseOption(), requestBody.getSearchText(), requestBody.getTypeName(), requestBody.getClassificationNames(), "findEntities"));
                response.setSearchCategory("Entity");
                response.setSearchText(requestBody.getSearchText());
                response.setServerName(requestBody.getServerName());
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findEntities", auditLog);
        }
        log.debug("Returning from method: findEntities with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexSearchResponse findRelationships(String serverName, String userId, RexSearchBody requestBody) {
        String methodName = "findRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findRelationships");
        RexSearchResponse response = new RexSearchResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelationships");
            if (requestBody != null) {
                RexViewHandler handler = instanceHandler.getRexViewHandler(userId, serverName, "findRelationships");
                response.setRelationships(handler.findRelationships(userId, requestBody.getServerName(), requestBody.getServerRootURL(), requestBody.getEnterpriseOption(), requestBody.getSearchText(), requestBody.getTypeName(), "findRelationships"));
                response.setSearchCategory("Relationship");
                response.setSearchText(requestBody.getSearchText());
                response.setServerName(requestBody.getServerName());
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "findRelationships", auditLog);
        }
        log.debug("Returning from method: findRelationships with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexPreTraversalResponse preTraversal(String serverName, String userId, RexTraversalRequestBody requestBody) {
        String methodName = "preTraversal";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "preTraversal");
        RexPreTraversalResponse response = new RexPreTraversalResponse();
        AuditLog auditLog = null;
        try {
            RexViewHandler handler;
            RexPreTraversal preTraversal;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "preTraversal");
            if (requestBody != null && (preTraversal = (handler = instanceHandler.getRexViewHandler(userId, serverName, "preTraversal")).preTraversal(userId, requestBody.getServerName(), requestBody.getServerRootURL(), requestBody.getEnterpriseOption(), requestBody.getEntityGUID(), requestBody.getDepth(), "preTraversal")) != null) {
                response.setRexPreTraversal(preTraversal);
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "preTraversal", auditLog);
        }
        log.debug("Returning from method: preTraversal with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexTraversalResponse traversal(String serverName, String userId, RexTraversalRequestBody requestBody) {
        String methodName = "traversal";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "traversal");
        RexTraversalResponse response = new RexTraversalResponse();
        AuditLog auditLog = null;
        try {
            RexViewHandler handler;
            RexTraversal traversal;
            auditLog = instanceHandler.getAuditLog(userId, serverName, "traversal");
            if (requestBody != null && (traversal = (handler = instanceHandler.getRexViewHandler(userId, serverName, "traversal")).traversal(userId, requestBody.getServerName(), requestBody.getServerRootURL(), requestBody.getEnterpriseOption(), requestBody.getEntityGUID(), requestBody.getDepth(), requestBody.getEntityTypeGUIDs(), requestBody.getRelationshipTypeGUIDs(), requestBody.getClassificationNames(), "traversal")) != null) {
                response.setRexTraversal(traversal);
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "traversal", auditLog);
        }
        log.debug("Returning from method: traversal with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

