/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.rex.server;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.rex.api.ffdc.RexExceptionHandler;
import org.odpi.openmetadata.viewservices.rex.api.ffdc.RexViewErrorCode;
import org.odpi.openmetadata.viewservices.rex.api.ffdc.RexViewServiceException;
import org.odpi.openmetadata.viewservices.rex.api.properties.ResourceEndpoint;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexPreTraversal;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexRelationshipAndEntitiesDigest;
import org.odpi.openmetadata.viewservices.rex.api.properties.RexTraversal;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexEntityDetailResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexEntityRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexPreTraversalResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexRelationshipRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexRelationshipResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexResourceEndpointListResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexSearchBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexSearchResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTraversalRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTraversalResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTypesRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.TypeExplorerResponse;
import org.odpi.openmetadata.viewservices.rex.handlers.RexViewHandler;
import org.odpi.openmetadata.viewservices.rex.server.RexViewInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RexViewRESTServices {
    protected static final RexViewInstanceHandler instanceHandler = new RexViewInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(RexViewRESTServices.class), instanceHandler.getServiceName());
    private static final Logger log = LoggerFactory.getLogger(RexViewRESTServices.class);
    private static String className = RexViewRESTServices.class.getName();

    public RexResourceEndpointListResponse getResourceEndpointList(String serverName, String userId) {
        String methodName = "getResourceEndpointList";
        RexResourceEndpointListResponse response = new RexResourceEndpointListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceEndpointList");
            RexViewHandler handler = instanceHandler.getRexViewHandler(userId, serverName, "getResourceEndpointList");
            Map<String, List<ResourceEndpoint>> lists = handler.getResourceEndpoints(userId, "getResourceEndpointList");
            List<ResourceEndpoint> platformList = null;
            List<ResourceEndpoint> serverList = null;
            if (lists != null) {
                platformList = lists.get("platformList");
                serverList = lists.get("serverList");
            }
            response.setPlatformList(platformList);
            response.setServerList(serverList);
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Exception exception) {
            restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getResourceEndpointList", auditLog);
        }
        log.debug("Returning from method: getResourceEndpointList with response: " + response.toString());
        return response;
    }

    public TypeExplorerResponse getTypeExplorer(String serverName, String userId, RexTypesRequestBody requestBody) {
        String methodName = "getTypeExplorer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getTypeExplorer");
        TypeExplorerResponse response = new TypeExplorerResponse();
        if (requestBody != null) {
            AuditLog auditLog = null;
            RexViewHandler handler = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getTypeExplorer");
                handler = instanceHandler.getRexViewHandler(userId, serverName, "getTypeExplorer");
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getTypeExplorer", auditLog);
            }
            try {
                response.setTypeExplorer(handler.getTypeExplorer(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEnterpriseOption(), "getTypeExplorer"));
            }
            catch (RexViewServiceException exception) {
                RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getTypeExplorer", auditLog);
            }
        } else {
            RexViewServiceException exception = new RexViewServiceException(RexViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "getTypeExplorer");
            RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
        }
        log.debug("Returning from method: getTypeExplorer with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexEntityDetailResponse getEntity(String serverName, String userId, RexEntityRequestBody requestBody) {
        String methodName = "getEntity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getEntity");
        RexEntityDetailResponse response = new RexEntityDetailResponse();
        if (requestBody != null) {
            AuditLog auditLog = null;
            RexViewHandler handler = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getEntity");
                handler = instanceHandler.getRexViewHandler(userId, serverName, "getEntity");
            }
            catch (InvalidParameterException exception) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, exception);
            }
            catch (PropertyServerException exception) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, exception);
            }
            catch (UserNotAuthorizedException exception) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, exception);
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getEntity", auditLog);
            }
            try {
                if (handler == null) {
                    throw new RexViewServiceException(RexViewErrorCode.HANDLER_INVALID.getMessageDefinition(new String[]{"getEntity"}), className, "getEntity");
                }
                long asOfTime = requestBody.getAsOfTime();
                Date asOfTimeDate = null;
                if (asOfTime != 0L && (asOfTimeDate = new Date(asOfTime)).after(new Date())) {
                    throw new RexViewServiceException(RexViewErrorCode.INVALID_AS_OF_DATETIME.getMessageDefinition(new String[]{"getEntity"}), className, "getEntity");
                }
                response.setExpandedEntityDetail(handler.getEntity(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEnterpriseOption(), requestBody.getEntityGUID(), asOfTimeDate, "getEntity"));
            }
            catch (RexViewServiceException exception) {
                RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getEntity", auditLog);
            }
        } else {
            RexViewServiceException exception = new RexViewServiceException(RexViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "getEntity");
            RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
        }
        log.debug("Returning from method: getEntity with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexRelationshipResponse getRelationship(String serverName, String userId, RexRelationshipRequestBody requestBody) {
        String methodName = "getRelationship";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelationship");
        RexRelationshipResponse response = new RexRelationshipResponse();
        if (requestBody != null) {
            AuditLog auditLog = null;
            RexViewHandler handler = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelationship");
                handler = instanceHandler.getRexViewHandler(userId, serverName, "getRelationship");
            }
            catch (InvalidParameterException exception) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, exception);
            }
            catch (PropertyServerException exception) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, exception);
            }
            catch (UserNotAuthorizedException exception) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, exception);
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getRelationship", auditLog);
            }
            try {
                if (handler == null) {
                    throw new RexViewServiceException(RexViewErrorCode.HANDLER_INVALID.getMessageDefinition(new String[]{"getRelationship"}), className, "getRelationship");
                }
                long asOfTime = requestBody.getAsOfTime();
                Date asOfTimeDate = null;
                if (asOfTime != 0L && (asOfTimeDate = new Date(asOfTime)).after(new Date())) {
                    throw new RexViewServiceException(RexViewErrorCode.INVALID_AS_OF_DATETIME.getMessageDefinition(new String[]{"getRelationship"}), className, "getRelationship");
                }
                response.setExpandedRelationship(handler.getRelationship(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEnterpriseOption(), requestBody.getRelationshipGUID(), asOfTimeDate, "getRelationship"));
            }
            catch (RexViewServiceException exception) {
                RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "getRelationship", auditLog);
            }
        } else {
            RexViewServiceException exception = new RexViewServiceException(RexViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "getRelationship");
            RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
        }
        log.debug("Returning from method: getRelationship with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexSearchResponse findEntities(String serverName, String userId, RexSearchBody requestBody) {
        String methodName = "findEntities";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findEntities");
        RexSearchResponse response = new RexSearchResponse();
        if (requestBody != null) {
            AuditLog auditLog = null;
            RexViewHandler handler = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findEntities");
                handler = instanceHandler.getRexViewHandler(userId, serverName, "findEntities");
            }
            catch (InvalidParameterException exception) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, exception);
            }
            catch (PropertyServerException exception) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, exception);
            }
            catch (UserNotAuthorizedException exception) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, exception);
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "findEntities", auditLog);
            }
            try {
                if (handler == null) {
                    throw new RexViewServiceException(RexViewErrorCode.HANDLER_INVALID.getMessageDefinition(new String[]{"findEntities"}), className, "findEntities");
                }
                long asOfTime = requestBody.getAsOfTime();
                Date asOfTimeDate = null;
                if (asOfTime != 0L && (asOfTimeDate = new Date(asOfTime)).after(new Date())) {
                    throw new RexViewServiceException(RexViewErrorCode.INVALID_AS_OF_DATETIME.getMessageDefinition(new String[]{"findEntities"}), className, "findEntities");
                }
                response.setEntities(handler.findEntities(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEnterpriseOption(), requestBody.getSearchText(), requestBody.getTypeName(), requestBody.getClassificationNames(), asOfTimeDate, "findEntities"));
                response.setSearchCategory("Entity");
                response.setSearchText(requestBody.getSearchText());
                response.setServerName(requestBody.getServerName());
            }
            catch (RexViewServiceException exception) {
                RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "findEntities", auditLog);
            }
        } else {
            RexViewServiceException exception = new RexViewServiceException(RexViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "findEntities");
            RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
        }
        log.debug("Returning from method: findEntities with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexSearchResponse findRelationships(String serverName, String userId, RexSearchBody requestBody) {
        String methodName = "findRelationships";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findRelationships");
        RexSearchResponse response = new RexSearchResponse();
        if (requestBody != null) {
            AuditLog auditLog = null;
            RexViewHandler handler = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findRelationships");
                handler = instanceHandler.getRexViewHandler(userId, serverName, "findRelationships");
            }
            catch (InvalidParameterException exception) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, exception);
            }
            catch (PropertyServerException exception) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, exception);
            }
            catch (UserNotAuthorizedException exception) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, exception);
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "findRelationships", auditLog);
            }
            try {
                if (handler == null) {
                    throw new RexViewServiceException(RexViewErrorCode.HANDLER_INVALID.getMessageDefinition(new String[]{"findRelationships"}), className, "findRelationships");
                }
                long asOfTime = requestBody.getAsOfTime();
                Date asOfTimeDate = null;
                if (asOfTime != 0L && (asOfTimeDate = new Date(asOfTime)).after(new Date())) {
                    throw new RexViewServiceException(RexViewErrorCode.INVALID_AS_OF_DATETIME.getMessageDefinition(new String[]{"findRelationships"}), className, "findRelationships");
                }
                Map<String, RexRelationshipAndEntitiesDigest> superDigests = handler.findRelationships(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEnterpriseOption(), requestBody.getSearchText(), requestBody.getTypeName(), asOfTimeDate, "findRelationships");
                response.setRelationships(superDigests);
                response.setSearchCategory("Relationship");
                response.setSearchText(requestBody.getSearchText());
                response.setServerName(requestBody.getServerName());
            }
            catch (RexViewServiceException exception) {
                RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "findRelationships", auditLog);
            }
        } else {
            RexViewServiceException exception = new RexViewServiceException(RexViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "findRelationships");
            RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
        }
        log.debug("Returning from method: findRelationships with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexPreTraversalResponse preTraversal(String serverName, String userId, RexTraversalRequestBody requestBody) {
        String methodName = "preTraversal";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "preTraversal");
        RexPreTraversalResponse response = new RexPreTraversalResponse();
        if (requestBody != null) {
            AuditLog auditLog = null;
            RexViewHandler handler = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "preTraversal");
                handler = instanceHandler.getRexViewHandler(userId, serverName, "preTraversal");
            }
            catch (InvalidParameterException exception) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, exception);
            }
            catch (PropertyServerException exception) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, exception);
            }
            catch (UserNotAuthorizedException exception) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, exception);
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "preTraversal", auditLog);
            }
            try {
                RexPreTraversal preTraversal = handler.preTraversal(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEnterpriseOption(), requestBody.getEntityGUID(), requestBody.getDepth(), requestBody.getAsOfTime(), "preTraversal");
                if (preTraversal != null) {
                    response.setRexPreTraversal(preTraversal);
                }
            }
            catch (RexViewServiceException exception) {
                RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "preTraversal", auditLog);
            }
        } else {
            RexViewServiceException exception = new RexViewServiceException(RexViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "preTraversal");
            RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
        }
        log.debug("Returning from method: preTraversal with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RexTraversalResponse traversal(String serverName, String userId, RexTraversalRequestBody requestBody) {
        String methodName = "traversal";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "traversal");
        RexTraversalResponse response = new RexTraversalResponse();
        if (requestBody != null) {
            AuditLog auditLog = null;
            RexViewHandler handler = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "traversal");
                handler = instanceHandler.getRexViewHandler(userId, serverName, "traversal");
            }
            catch (InvalidParameterException exception) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, exception);
            }
            catch (PropertyServerException exception) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, exception);
            }
            catch (UserNotAuthorizedException exception) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, exception);
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "traversal", auditLog);
            }
            try {
                RexTraversal traversal = handler.traversal(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEnterpriseOption(), requestBody.getEntityGUID(), requestBody.getDepth(), requestBody.getEntityTypeGUIDs(), requestBody.getRelationshipTypeGUIDs(), requestBody.getClassificationNames(), requestBody.getAsOfTime(), "traversal");
                if (traversal != null) {
                    response.setRexTraversal(traversal);
                }
            }
            catch (RexViewServiceException exception) {
                RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
            }
            catch (Exception exception) {
                restExceptionHandler.captureExceptions((FFDCResponse)response, exception, "traversal", auditLog);
            }
        } else {
            RexViewServiceException exception = new RexViewServiceException(RexViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "traversal");
            RexExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)exception, (String)((Object)((Object)exception)).getClass().getName());
        }
        log.debug("Returning from method: traversal with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

