/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.rex.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexEntityDetailResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexEntityRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexPreTraversalResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexRelationshipRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexRelationshipResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexSearchBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexSearchResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTraversalRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTraversalResponse;
import org.odpi.openmetadata.viewservices.rex.api.rest.RexTypesRequestBody;
import org.odpi.openmetadata.viewservices.rex.api.rest.TypeExplorerResponse;
import org.odpi.openmetadata.viewservices.rex.server.RexViewRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/view-services/rex/users/{userId}"})
@Tag(name="Rex OMVS", description="Explore instance data in a repository or cohort for visualization of graphs of related items.", externalDocs=@ExternalDocumentation(description="Rex View Services (OMVS)", url="https://egeria.odpi.org/open-metadata-implementation/view-services/rex-view/"))
public class RexViewRESTResource {
    private RexViewRESTServices restAPI = new RexViewRESTServices();

    @PostMapping(value={"/types"})
    public TypeExplorerResponse getTypeExplorer(@PathVariable String serverName, @PathVariable String userId, @RequestBody RexTypesRequestBody body) {
        return this.restAPI.getTypeExplorer(serverName, userId, body);
    }

    @PostMapping(value={"/instances/entity"})
    public RexEntityDetailResponse getEntity(@PathVariable String serverName, @PathVariable String userId, @RequestBody RexEntityRequestBody body) {
        return this.restAPI.getEntity(serverName, userId, body);
    }

    @PostMapping(value={"/instances/relationship"})
    public RexRelationshipResponse getRelationship(@PathVariable String serverName, @PathVariable String userId, @RequestBody RexRelationshipRequestBody body) {
        return this.restAPI.getRelationship(serverName, userId, body);
    }

    @PostMapping(value={"/instances/entities/by-property-value"})
    public RexSearchResponse findEntities(@PathVariable String serverName, @PathVariable String userId, @RequestBody RexSearchBody body) {
        return this.restAPI.findEntities(serverName, userId, body);
    }

    @PostMapping(value={"/instances/relationships/by-property-value"})
    public RexSearchResponse findRelationships(@PathVariable String serverName, @PathVariable String userId, @RequestBody RexSearchBody body) {
        return this.restAPI.findRelationships(serverName, userId, body);
    }

    @PostMapping(value={"/instances/pre-traversal"})
    public RexPreTraversalResponse rexPreTraversal(@PathVariable String serverName, @PathVariable String userId, @RequestBody RexTraversalRequestBody body) {
        return this.restAPI.preTraversal(serverName, userId, body);
    }

    @PostMapping(value={"/instances/traversal"})
    public RexTraversalResponse rexTraversal(@PathVariable String serverName, @PathVariable String userId, @RequestBody RexTraversalRequestBody body) {
        return this.restAPI.traversal(serverName, userId, body);
    }
}

