/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.runtimemanager.server;

import org.odpi.openmetadata.accessservices.itinfrastructure.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.PlatformManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ServerManagerClient;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.commonservices.multitenant.OMVSServiceInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;

public class RuntimeManagerInstance
extends OMVSServiceInstance {
    private static final ViewServiceDescription myDescription = ViewServiceDescription.RUNTIME_MANAGER;
    private final PlatformManagerClient platformManagerClient;
    private final ServerManagerClient serverManagerClient;
    private final ConnectedAssetClient connectedAssetClient;
    private final OpenMetadataStoreClient openMetadataStoreClient;

    public RuntimeManagerInstance(String serverName, AuditLog auditLog, String localServerUserId, int maxPageSize, String remoteServerName, String remoteServerURL) throws InvalidParameterException {
        super(serverName, myDescription.getViewServiceName(), auditLog, localServerUserId, maxPageSize, remoteServerName, remoteServerURL);
        this.platformManagerClient = new PlatformManagerClient(remoteServerName, remoteServerURL, maxPageSize);
        this.serverManagerClient = new ServerManagerClient(remoteServerName, remoteServerURL, maxPageSize);
        this.connectedAssetClient = new ConnectedAssetClient(remoteServerName, remoteServerURL, maxPageSize);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(remoteServerName, remoteServerURL, maxPageSize);
    }

    public PlatformManagerClient getPlatformManagerClient() {
        return this.platformManagerClient;
    }

    public ServerManagerClient getServerManagerClient() {
        return this.serverManagerClient;
    }

    public ConnectedAssetClient getConnectedAssetClient() {
        return this.connectedAssetClient;
    }

    public OpenMetadataStoreClient getOpenMetadataStoreClient() {
        return this.openMetadataStoreClient;
    }
}

