/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.runtimemanager.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ConnectedAssetClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.PlatformManagerClient;
import org.odpi.openmetadata.accessservices.itinfrastructure.client.ServerManagerClient;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.platform.OMAGServerPlatformConnector;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.EngineHostConnector;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.IntegrationDaemonConnector;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.MetadataAccessServerConnector;
import org.odpi.openmetadata.adapters.connectors.egeriainfrastructure.servers.OMAGServerConnectorBase;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareServerPlatformResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareServerPlatformsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareServerResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareServersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareServerElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SoftwareServerPlatformElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.ConnectorConfigPropertiesRequestBody;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.serveroperations.rest.SuccessMessageResponse;
import org.odpi.openmetadata.tokencontroller.TokenController;
import org.odpi.openmetadata.viewservices.runtimemanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.runtimemanager.rest.PlatformReportResponse;
import org.odpi.openmetadata.viewservices.runtimemanager.rest.ServerReportResponse;
import org.odpi.openmetadata.viewservices.runtimemanager.server.RuntimeManagerInstanceHandler;
import org.slf4j.LoggerFactory;

public class RuntimeManagerRESTServices
extends TokenController {
    private static final RuntimeManagerInstanceHandler instanceHandler = new RuntimeManagerInstanceHandler();
    private static final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(RuntimeManagerRESTServices.class), instanceHandler.getServiceName());

    public SoftwareServerPlatformsResponse getPlatformsByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getPlatformsByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getPlatformsByName");
        SoftwareServerPlatformsResponse response = new SoftwareServerPlatformsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getPlatformsByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPlatformsByName");
            PlatformManagerClient handler = instanceHandler.getPlatformManagerClient(userId, serverName, "getPlatformsByName");
            if (requestBody != null) {
                response.setElements(handler.getSoftwareServerPlatformsByName(userId, requestBody.getFilter(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getPlatformsByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getPlatformsByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SoftwareServerPlatformsResponse getPlatformsByDeployedImplType(String serverName, int startFrom, int pageSize, boolean getTemplates, FilterRequestBody requestBody) {
        String methodName = "getPlatformsByDeployedImplType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getPlatformsByDeployedImplType");
        SoftwareServerPlatformsResponse response = new SoftwareServerPlatformsResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getPlatformsByDeployedImplType");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPlatformsByDeployedImplType");
            PlatformManagerClient handler = instanceHandler.getPlatformManagerClient(userId, serverName, "getPlatformsByDeployedImplType");
            List platforms = requestBody != null ? handler.getSoftwareServerPlatformsByDeployedImplType(userId, requestBody.getFilter(), requestBody.getEffectiveTime(), startFrom, pageSize) : handler.getSoftwareServerPlatformsByDeployedImplType(userId, null, new Date(), startFrom, pageSize);
            if (platforms != null) {
                ArrayList<SoftwareServerPlatformElement> filteredPlatforms = new ArrayList<SoftwareServerPlatformElement>();
                for (SoftwareServerPlatformElement platformElement : platforms) {
                    if (platformElement == null) continue;
                    if (this.isTemplate(platformElement.getElementHeader()) && getTemplates) {
                        filteredPlatforms.add(platformElement);
                    }
                    if (this.isTemplate(platformElement.getElementHeader()) || getTemplates) continue;
                    filteredPlatforms.add(platformElement);
                }
                if (!filteredPlatforms.isEmpty()) {
                    response.setElements(filteredPlatforms);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getPlatformsByDeployedImplType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private boolean isTemplate(ElementHeader elementHeader) {
        if (elementHeader.getClassifications() != null) {
            for (ElementClassification classification : elementHeader.getClassifications()) {
                if (classification == null || !classification.getClassificationName().equals(OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName)) continue;
                return true;
            }
        }
        return false;
    }

    public SoftwareServerPlatformResponse getPlatformByGUID(String serverName, String platformGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getPlatformByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getPlatformByGUID");
        SoftwareServerPlatformResponse response = new SoftwareServerPlatformResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getPlatformByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPlatformByGUID");
            PlatformManagerClient handler = instanceHandler.getPlatformManagerClient(userId, serverName, "getPlatformByGUID");
            response.setElement(handler.getSoftwareServerPlatformByGUID(userId, platformGUID));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getPlatformByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PlatformReportResponse getPlatformReport(String serverName, String platformGUID) {
        String methodName = "getPlatformReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getPlatformReport");
        PlatformReportResponse response = new PlatformReportResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getPlatformReport");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPlatformReport");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "getPlatformReport");
            AssetUniverse asset = handler.getAssetProperties(userId, platformGUID);
            Connector connector = handler.getConnectorForAsset(userId, platformGUID, auditLog);
            if (connector instanceof OMAGServerPlatformConnector) {
                OMAGServerPlatformConnector omagServerPlatformConnector = (OMAGServerPlatformConnector)connector;
                if (asset != null) {
                    omagServerPlatformConnector.setPlatformName(asset.getResourceName());
                }
                omagServerPlatformConnector.setClientUserId(userId);
                omagServerPlatformConnector.start();
                response.setElement(omagServerPlatformConnector.getPlatformReport());
                omagServerPlatformConnector.disconnect();
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getPlatformReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SoftwareServersResponse getServersByName(String serverName, int startFrom, int pageSize, FilterRequestBody requestBody) {
        String methodName = "getServersByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getServersByName");
        SoftwareServersResponse response = new SoftwareServersResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getServersByName");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServersByName");
            ServerManagerClient handler = instanceHandler.getServerManagerClient(userId, serverName, "getServersByName");
            if (requestBody != null) {
                response.setElements(handler.getSoftwareServersByName(userId, requestBody.getFilter(), requestBody.getEffectiveTime(), startFrom, pageSize));
            } else {
                restExceptionHandler.handleNoRequestBody(userId, "getServersByName", serverName);
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServersByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SoftwareServersResponse getServersByDeployedImplType(String serverName, int startFrom, int pageSize, boolean getTemplates, FilterRequestBody requestBody) {
        String methodName = "getServersByDeployedImplType";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getServersByDeployedImplType");
        SoftwareServersResponse response = new SoftwareServersResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getServersByDeployedImplType");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServersByDeployedImplType");
            ServerManagerClient handler = instanceHandler.getServerManagerClient(userId, serverName, "getServersByDeployedImplType");
            List servers = requestBody != null ? handler.getSoftwareServersByDeployedImplType(userId, requestBody.getFilter(), requestBody.getEffectiveTime(), startFrom, pageSize) : handler.getSoftwareServersByDeployedImplType(userId, null, new Date(), startFrom, pageSize);
            if (servers != null) {
                ArrayList<SoftwareServerElement> filteredServers = new ArrayList<SoftwareServerElement>();
                for (SoftwareServerElement serverElement : servers) {
                    if (serverElement == null) continue;
                    if (this.isTemplate(serverElement.getElementHeader()) && getTemplates) {
                        filteredServers.add(serverElement);
                    }
                    if (this.isTemplate(serverElement.getElementHeader()) || getTemplates) continue;
                    filteredServers.add(serverElement);
                }
                if (!filteredServers.isEmpty()) {
                    response.setElements(filteredServers);
                }
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServersByDeployedImplType", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SoftwareServerResponse getServerByGUID(String serverName, String serverGUID, EffectiveTimeQueryRequestBody requestBody) {
        String methodName = "getServerByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getServerByGUID");
        SoftwareServerResponse response = new SoftwareServerResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getServerByGUID");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServerByGUID");
            ServerManagerClient handler = instanceHandler.getServerManagerClient(userId, serverName, "getServerByGUID");
            response.setElement(handler.getSoftwareServerByGUID(userId, serverGUID));
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServerByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ServerReportResponse getServerReport(String serverName, String serverGUID) {
        String methodName = "getServerReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getServerReport");
        ServerReportResponse response = new ServerReportResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getServerReport");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServerReport");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "getServerReport");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof OMAGServerConnectorBase) {
                OMAGServerConnectorBase omagServerConnector = (OMAGServerConnectorBase)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                response.setElement(omagServerConnector.getServerReport());
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "getServerReport", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServerReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SuccessMessageResponse activateWithStoredConfig(String serverName, String serverGUID) {
        String methodName = "activateWithStoredConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "activateWithStoredConfig");
        SuccessMessageResponse response = new SuccessMessageResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "activateWithStoredConfig");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "activateWithStoredConfig");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "activateWithStoredConfig");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof OMAGServerConnectorBase) {
                OMAGServerConnectorBase omagServerConnector = (OMAGServerConnectorBase)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                response.setSuccessMessage(omagServerConnector.activateServer());
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "activateWithStoredConfig", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "activateWithStoredConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse shutdownServer(String serverName, String serverGUID) {
        String methodName = "shutdownServer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "shutdownServer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "shutdownServer");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "shutdownServer");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "shutdownServer");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof OMAGServerConnectorBase) {
                OMAGServerConnectorBase omagServerConnector = (OMAGServerConnectorBase)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.shutdownServer();
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "shutdownServer", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "shutdownServer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse shutdownAndUnregisterServer(String serverName, String serverGUID) {
        String methodName = "shutdownAndUnregisterServer";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "shutdownAndUnregisterServer");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "shutdownAndUnregisterServer");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "shutdownAndUnregisterServer");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "shutdownAndUnregisterServer");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof OMAGServerConnectorBase) {
                OMAGServerConnectorBase omagServerConnector = (OMAGServerConnectorBase)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.shutdownAndUnregisterServer();
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "shutdownAndUnregisterServer", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "shutdownAndUnregisterServer", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOpenMetadataArchiveFile(String serverName, String serverGUID, String fileName) {
        String methodName = "addOpenMetadataArchiveFile";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addOpenMetadataArchiveFile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addOpenMetadataArchiveFile");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addOpenMetadataArchiveFile");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "addOpenMetadataArchiveFile");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof MetadataAccessServerConnector) {
                MetadataAccessServerConnector omagServerConnector = (MetadataAccessServerConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.addOpenMetadataArchiveFile(fileName);
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(MetadataAccessServerConnector.class.getName(), "addOpenMetadataArchiveFile", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addOpenMetadataArchiveFile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addOpenMetadataArchiveContent(String serverName, String serverGUID, OpenMetadataArchive openMetadataArchive) {
        String methodName = "addOpenMetadataArchive";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "addOpenMetadataArchive");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "addOpenMetadataArchive");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addOpenMetadataArchive");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "addOpenMetadataArchive");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof MetadataAccessServerConnector) {
                MetadataAccessServerConnector omagServerConnector = (MetadataAccessServerConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.addOpenMetadataArchiveContent(openMetadataArchive);
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(MetadataAccessServerConnector.class.getName(), "addOpenMetadataArchive", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "addOpenMetadataArchive", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshConfig(String serverName, String serverGUID, String governanceEngineName) {
        String methodName = "refreshConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "refreshConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "refreshConfig");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConfig");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "refreshConfig");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof EngineHostConnector) {
                EngineHostConnector omagServerConnector = (EngineHostConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.refreshEngineConfig(governanceEngineName);
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "refreshConfig", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "refreshConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshConfig(String serverName, String serverGUID) {
        String methodName = "refreshConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "refreshConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "refreshConfig");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConfig");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "refreshConfig");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof EngineHostConnector) {
                EngineHostConnector omagServerConnector = (EngineHostConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.refreshEngineConfig();
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "refreshConfig", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "refreshConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PropertiesResponse getConfigurationProperties(String serverName, String serverGUID, String connectorName) {
        String methodName = "getConfigurationProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "getConfigurationProperties");
        PropertiesResponse response = new PropertiesResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "getConfigurationProperties");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConfigurationProperties");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "getConfigurationProperties");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof IntegrationDaemonConnector) {
                IntegrationDaemonConnector omagServerConnector = (IntegrationDaemonConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                response.setProperties(omagServerConnector.getConfigurationProperties(connectorName));
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "getConfigurationProperties", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getConfigurationProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConfigurationProperties(String serverName, String serverGUID, ConnectorConfigPropertiesRequestBody requestBody) {
        String methodName = "updateConfigurationProperties";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateConfigurationProperties");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateConfigurationProperties");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConfigurationProperties");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "updateConfigurationProperties");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof IntegrationDaemonConnector) {
                IntegrationDaemonConnector omagServerConnector = (IntegrationDaemonConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.updateConfigurationProperties(requestBody.getConnectorName(), requestBody.getMergeUpdate(), requestBody.getConfigurationProperties());
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "updateConfigurationProperties", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateConfigurationProperties", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateEndpointNetworkAddress(String serverName, String serverGUID, String connectorName, StringRequestBody requestBody) {
        String methodName = "updateEndpointNetworkAddress";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateEndpointNetworkAddress");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateEndpointNetworkAddress");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateEndpointNetworkAddress");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "updateEndpointNetworkAddress");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof IntegrationDaemonConnector) {
                IntegrationDaemonConnector omagServerConnector = (IntegrationDaemonConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                if (requestBody == null || requestBody.getString() == null) {
                    restExceptionHandler.handleNoRequestBody(userId, "updateEndpointNetworkAddress", serverName);
                } else {
                    omagServerConnector.updateEndpointNetworkAddress(connectorName, requestBody.getString());
                }
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "updateEndpointNetworkAddress", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateEndpointNetworkAddress", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateConnectorConnection(String serverName, String serverGUID, String connectorName, Connection requestBody) {
        String methodName = "updateConnectorConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "updateConnectorConnection");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "updateConnectorConnection");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateConnectorConnection");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "updateConnectorConnection");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof IntegrationDaemonConnector) {
                IntegrationDaemonConnector omagServerConnector = (IntegrationDaemonConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.updateConnectorConnection(connectorName, requestBody);
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "updateConnectorConnection", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "updateConnectorConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshConnectors(String serverName, String serverGUID, NameRequestBody requestBody) {
        String methodName = "refreshConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "refreshConnectors");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "refreshConnectors");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshConnectors");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "refreshConnectors");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof IntegrationDaemonConnector) {
                IntegrationDaemonConnector omagServerConnector = (IntegrationDaemonConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                if (requestBody == null || requestBody.getName() == null) {
                    omagServerConnector.refreshConnectors();
                } else {
                    omagServerConnector.refreshConnector(requestBody.getName());
                }
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "refreshConnectors", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "refreshConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse restartConnectors(String serverName, String serverGUID, NameRequestBody requestBody) {
        String methodName = "restartConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "restartConnectors");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "restartConnectors");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "restartConnectors");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "restartConnectors");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof IntegrationDaemonConnector) {
                IntegrationDaemonConnector omagServerConnector = (IntegrationDaemonConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                if (requestBody == null || requestBody.getName() == null) {
                    omagServerConnector.restartConnectors();
                } else {
                    omagServerConnector.restartConnector(requestBody.getName());
                }
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "restartConnectors", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "restartConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse refreshIntegrationGroupConfig(String serverName, String serverGUID, String integrationGroupName) {
        String methodName = "refreshIntegrationGroupConfig";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "refreshIntegrationGroupConfig");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "refreshIntegrationGroupConfig");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "refreshIntegrationGroupConfig");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "refreshIntegrationGroupConfig");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof IntegrationDaemonConnector) {
                IntegrationDaemonConnector omagServerConnector = (IntegrationDaemonConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.refreshIntegrationGroupConfig(integrationGroupName);
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "refreshIntegrationGroupConfig", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "refreshIntegrationGroupConfig", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishOpenLineageEvent(String serverName, String serverGUID, String event) {
        String methodName = "publishOpenLineageEvent";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "publishOpenLineageEvent");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "publishOpenLineageEvent");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishOpenLineageEvent");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "publishOpenLineageEvent");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof IntegrationDaemonConnector) {
                IntegrationDaemonConnector omagServerConnector = (IntegrationDaemonConnector)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                omagServerConnector.publishOpenLineageEvent(event);
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "publishOpenLineageEvent", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "publishOpenLineageEvent", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse connectToCohort(String serverName, String serverGUID, String cohortName, NullRequestBody requestBody) {
        String methodName = "connectToCohort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "connectToCohort");
        BooleanResponse response = new BooleanResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "connectToCohort");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "connectToCohort");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "connectToCohort");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof OMAGServerConnectorBase) {
                OMAGServerConnectorBase omagServerConnector = (OMAGServerConnectorBase)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                response.setFlag(omagServerConnector.connectToCohort(userId, cohortName));
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "connectToCohort", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "connectToCohort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse disconnectFromCohort(String serverName, String serverGUID, String cohortName, NullRequestBody requestBody) {
        String methodName = "disconnectFromCohort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "disconnectFromCohort");
        BooleanResponse response = new BooleanResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "disconnectFromCohort");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "disconnectFromCohort");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "disconnectFromCohort");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof OMAGServerConnectorBase) {
                OMAGServerConnectorBase omagServerConnector = (OMAGServerConnectorBase)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                response.setFlag(omagServerConnector.disconnectFromCohort(userId, cohortName));
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "disconnectFromCohort", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "disconnectFromCohort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public BooleanResponse unregisterFromCohort(String serverName, String serverGUID, String cohortName, NullRequestBody requestBody) {
        String methodName = "unregisterFromCohort";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, "unregisterFromCohort");
        BooleanResponse response = new BooleanResponse();
        AuditLog auditLog = null;
        try {
            String userId = super.getUser(instanceHandler.getServiceName(), "unregisterFromCohort");
            restCallLogger.setUserId(token, userId);
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterFromCohort");
            ConnectedAssetClient handler = instanceHandler.getConnectedAssetClient(userId, serverName, "unregisterFromCohort");
            Connector connector = handler.getConnectorForAsset(userId, serverGUID, auditLog);
            if (connector instanceof OMAGServerConnectorBase) {
                OMAGServerConnectorBase omagServerConnector = (OMAGServerConnectorBase)connector;
                omagServerConnector.setClientUserId(userId);
                omagServerConnector.start();
                response.setFlag(omagServerConnector.unregisterFromCohort(userId, cohortName));
                omagServerConnector.disconnect();
            } else {
                restExceptionHandler.handleInvalidCallToServer(OMAGServerConnectorBase.class.getName(), "unregisterFromCohort", serverGUID, connector.getClass().getName());
            }
        }
        catch (Throwable error) {
            restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "unregisterFromCohort", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

