/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.runtimemanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.BooleanResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PropertiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareServerPlatformResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareServerPlatformsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareServerResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SoftwareServersResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.rest.ConnectorConfigPropertiesRequestBody;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.serveroperations.rest.SuccessMessageResponse;
import org.odpi.openmetadata.viewservices.runtimemanager.rest.EffectiveTimeQueryRequestBody;
import org.odpi.openmetadata.viewservices.runtimemanager.rest.PlatformReportResponse;
import org.odpi.openmetadata.viewservices.runtimemanager.rest.ServerReportResponse;
import org.odpi.openmetadata.viewservices.runtimemanager.server.RuntimeManagerRESTServices;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/runtime-manager"})
@Tag(name="API: Runtime Manager OMVS", description="The Runtime Manager OMVS provides APIs for retrieving and updating code values and reference data.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/runtime-manager/overview/"))
public class RuntimeManagerResource {
    private final RuntimeManagerRESTServices restAPI = new RuntimeManagerRESTServices();

    @PostMapping(value={"/platforms/by-name"})
    @Operation(summary="getPlatformsByName", description="Returns the list of platforms with a particular name.  The name is specified in the filter.", externalDocs=@ExternalDocumentation(description="Software Server Platforms", url="https://egeria-project.org/types/0/0037-Software-Server-Platforms/"))
    public SoftwareServerPlatformsResponse getPlatformsByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getPlatformsByName(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(value={"/platforms/by-deployed-implementation-type"})
    @Operation(summary="getPlatformsByDeployedImplementationType", description="Returns the list of platforms with a particular deployed implementation type.  The value is specified in the filter.  If it is null, or no request body is supplied, all platforms are returned.", externalDocs=@ExternalDocumentation(description="Software Server Platforms", url="https://egeria-project.org/types/0/0037-Software-Server-Platforms/"))
    public SoftwareServerPlatformsResponse getPlatformsByDeployedImplType(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean getTemplates, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getPlatformsByDeployedImplType(serverName, startFrom, pageSize, getTemplates, requestBody);
    }

    @PostMapping(value={"/platforms/{platformGUID}"})
    @Operation(summary="getPlatformByGUID", description="Returns details about the platform's catalog entry (asset).", externalDocs=@ExternalDocumentation(description="Software Server Platforms", url="https://egeria-project.org/types/0/0037-Software-Server-Platforms/"))
    public SoftwareServerPlatformResponse getPlatformByGUID(@PathVariable String serverName, @PathVariable String platformGUID, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getPlatformByGUID(serverName, platformGUID, requestBody);
    }

    @GetMapping(value={"/platforms/{platformGUID}/report"})
    @Operation(summary="getPlatformReport", description="Returns details about the running OMAG Server Platform.", externalDocs=@ExternalDocumentation(description="Software Server Platforms", url="https://egeria-project.org/types/0/0037-Software-Server-Platforms/"))
    public PlatformReportResponse getPlatformReport(@PathVariable String serverName, @PathVariable String platformGUID) {
        return this.restAPI.getPlatformReport(serverName, platformGUID);
    }

    @PostMapping(value={"/software-servers/by-name"})
    @Operation(summary="getServersByName", description="Returns the list of servers with a particular name.  The name is specified in the filter.", externalDocs=@ExternalDocumentation(description="Software Servers", url="https://egeria-project.org/types/0/0040-Software-Servers/"))
    public SoftwareServersResponse getServersByName(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getServersByName(serverName, startFrom, pageSize, requestBody);
    }

    @PostMapping(value={"/software-servers/by-deployed-implementation-type"})
    @Operation(summary="getServersByDeployedImplementationType", description="Returns the list of servers with a particular deployed implementation type.   The value is specified in the filter.  If it is null, or no request body is supplied, all servers are returned.", externalDocs=@ExternalDocumentation(description="Software Servers", url="https://egeria-project.org/types/0/0040-Software-Servers/"))
    public SoftwareServersResponse getServersByDeployedImplType(@PathVariable String serverName, @RequestParam int startFrom, @RequestParam int pageSize, @RequestParam(required=false, defaultValue="false") boolean getTemplates, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getServersByDeployedImplType(serverName, startFrom, pageSize, getTemplates, requestBody);
    }

    @PostMapping(value={"/software-servers/{serverGUID}"})
    @Operation(summary="getServerByGUID", description="Returns details about the server's catalog entry (asset).", externalDocs=@ExternalDocumentation(description="Software Servers", url="https://egeria-project.org/types/0/0040-Software-Servers/"))
    public SoftwareServerResponse getServerByGUID(@PathVariable String serverName, @PathVariable String serverGUID, @RequestBody(required=false) EffectiveTimeQueryRequestBody requestBody) {
        return this.restAPI.getServerByGUID(serverName, serverGUID, requestBody);
    }

    @GetMapping(value={"/omag-servers/{serverGUID}/instance/report"})
    @Operation(summary="getOMAGServerReport", description="Returns details about the running OMAG Server.", externalDocs=@ExternalDocumentation(description="OMAG Servers", url="https://egeria-project.org/concepts/omag-server/"))
    public ServerReportResponse getServerReport(@PathVariable String serverName, @PathVariable String serverGUID) {
        return this.restAPI.getServerReport(serverName, serverGUID);
    }

    @PostMapping(path={"/omag-servers/{serverGUID}/instance"})
    @Operation(summary="activateWithStoredConfig", description="Activate the named OMAG server using the appropriate configuration document found in the configuration store.", externalDocs=@ExternalDocumentation(description="Configuration Documents", url="https://egeria-project.org/concepts/configuration-document"))
    public SuccessMessageResponse activateWithStoredConfig(@PathVariable String serverName, @PathVariable String serverGUID) {
        return this.restAPI.activateWithStoredConfig(serverName, serverGUID);
    }

    @DeleteMapping(path={"/omag-servers/{serverGUID}/instance"})
    @Operation(summary="shutdownServer", description="Temporarily shutdown the named OMAG server.  This server can be restarted as a later time.")
    public VoidResponse shutdownServer(@PathVariable String serverName, @PathVariable String serverGUID) {
        return this.restAPI.shutdownServer(serverName, serverGUID);
    }

    @DeleteMapping(path={"/omag-servers/{serverGUID}"})
    @Operation(summary="shutdownAndUnregisterServer", description="Shutdown the named OMAG server.  The server will also be removed from any open metadata repository cohorts it has registered with.")
    public VoidResponse shutdownAndUnregisterServer(@PathVariable String serverName, @PathVariable String serverGUID) {
        return this.restAPI.shutdownAndUnregisterServer(serverName, serverGUID);
    }

    @PostMapping(path={"/omag-servers/{serverGUID}/instance/load/open-metadata-archives/file", "/metadata-access-stores/{serverGUID}/instance/load/open-metadata-archives/file"})
    @Operation(summary="addOpenMetadataArchiveFile", description="An open metadata archive contains metadata types and instances.  This operation loads an open metadata archive that is readable through the connector identified by the connection.  It can be used with OMAG servers that are of type Open Metadata Store.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/open-metadata-archives/"))
    public VoidResponse addOpenMetadataArchiveFile(@PathVariable String serverName, @PathVariable String serverGUID, @RequestBody String fileName) {
        return this.restAPI.addOpenMetadataArchiveFile(serverName, serverGUID, fileName);
    }

    @PostMapping(path={"/omag-servers/{serverGUID}/instance/load/open-metadata-archives/archive-content", "/metadata-access-stores/{serverGUID}/instance/load/open-metadata-archives/archive-content"})
    @Operation(summary="addOpenMetadataArchiveContent", description="An open metadata archive contains metadata types and instances.  This operation loads the supplied open metadata archive into the local repository.  It can be used with OMAG servers that are of type Open Metadata Store.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/open-metadata-archives/"))
    public VoidResponse addOpenMetadataArchive(@PathVariable String serverName, @PathVariable String serverGUID, @RequestBody OpenMetadataArchive openMetadataArchive) {
        return this.restAPI.addOpenMetadataArchiveContent(serverName, serverGUID, openMetadataArchive);
    }

    @GetMapping(path={"/engine-hosts/{serverGUID}/governance-engines/{governanceEngineName}/refresh-config"})
    @Operation(summary="refreshConfig", description="Request that the governance engine refresh its configuration by calling the metadata server. This request is useful if the metadata server has an outage, particularly while the governance server is initializing.  This request just ensures that the latest configuration is in use.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine-definition/"))
    public VoidResponse refreshConfig(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String governanceEngineName) {
        return this.restAPI.refreshConfig(serverName, serverGUID, governanceEngineName);
    }

    @GetMapping(path={"/engine-hosts/{serverGUID}/governance-engines/refresh-config"})
    @Operation(summary="refreshConfig", description="Request that all governance engines refresh their configuration by calling the metadata server. This request is useful if the metadata server has an outage, particularly while the governance server is initializing.  This request just ensures that the latest configuration is in use.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/governance-engine-definition/"))
    public VoidResponse refreshConfig(@PathVariable String serverName, @PathVariable String serverGUID) {
        return this.restAPI.refreshConfig(serverName, serverGUID);
    }

    @GetMapping(path={"/integration-daemons/{serverGUID}/integration-connectors/{connectorName}/configuration-properties"})
    @Operation(summary="getConfigurationProperties", description="Retrieve the configuration properties of the named integration connector running in the integration daemon.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public PropertiesResponse getConfigurationProperties(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String connectorName) {
        return this.restAPI.getConfigurationProperties(serverName, serverGUID, connectorName);
    }

    @PostMapping(path={"/integration-daemons/{serverGUID}/integration-connectors/configuration-properties"})
    @Operation(summary="updateConfigurationProperties", description="Update the configuration properties of the integration connectors, or specific integration connector if a connector name is supplied.  This update is in memory and will not persist over a server restart.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateConfigurationProperties(@PathVariable String serverName, @PathVariable String serverGUID, @RequestBody ConnectorConfigPropertiesRequestBody requestBody) {
        return this.restAPI.updateConfigurationProperties(serverName, serverGUID, requestBody);
    }

    @PostMapping(path={"/integration-daemons/{serverGUID}/integration-connectors/{connectorName}/endpoint-network-address"})
    @Operation(summary="updateEndpointNetworkAddress", description="Update the endpoint network address for a specific integration connector.  This update is in memory and will not persist over a server restart.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateEndpointNetworkAddress(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String connectorName, @RequestBody StringRequestBody requestBody) {
        return this.restAPI.updateEndpointNetworkAddress(serverName, serverGUID, connectorName, requestBody);
    }

    @PostMapping(path={"/integration-daemons/{serverGUID}/integration-connectors/{connectorName}/connection"})
    @Operation(summary="updateConnectorConnection", description="Update the connection for a specific integration connector.  This update is in memory and will not persist over a server restart.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateConnectorConnection(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String connectorName, @RequestBody Connection requestBody) {
        return this.restAPI.updateConnectorConnection(serverName, serverGUID, connectorName, requestBody);
    }

    @PostMapping(path={"/integration-daemons/{serverGUID}/integration-connectors/refresh"})
    @Operation(summary="refreshConnectors", description="Issue a refresh() request on all connectors running in the integration daemon, or a specific connector if the connector name is specified.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public VoidResponse refreshConnectors(@PathVariable String serverName, @PathVariable String serverGUID, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.refreshConnectors(serverName, serverGUID, requestBody);
    }

    @PostMapping(path={"/integration-daemons/{serverGUID}/integration-connectors/restart"})
    @Operation(summary="restartConnectors", description="Restart all connectors running in the integration daemon, or restart a specific connector if the connector name is specified.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-daemon/"))
    public VoidResponse restartConnectors(@PathVariable String serverName, @PathVariable String serverGUID, @RequestBody(required=false) NameRequestBody requestBody) {
        return this.restAPI.restartConnectors(serverName, serverGUID, requestBody);
    }

    @GetMapping(path={"/integration-daemons/{serverGUID}/integration-groups/{integrationGroupName}/refresh-config"})
    @Operation(summary="refreshIntegrationGroupConfig", description="Request that the integration group refresh its configuration by calling the metadata access server. Changes to the connector configuration will result in the affected connectors being restarted. This request is useful if the metadata access server has an outage, particularly while the integration daemon is initializing.  This request just ensures that the latest configuration is in use.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse refreshIntegrationGroupConfig(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String integrationGroupName) {
        return this.restAPI.refreshIntegrationGroupConfig(serverName, serverGUID, integrationGroupName);
    }

    @PostMapping(path={"/integration-daemons/{serverGUID}/open-lineage-events/publish"})
    @Operation(summary="publishOpenLineageEvent", description="Send an Open Lineage event to the integration daemon.  It will pass it on to the integration connectors that have registered a listener for open lineage events.", externalDocs=@ExternalDocumentation(description="Open Lineage Standard", url="https://egeria-project.org/features/lineage-management/overview/#the-openlineage-standard"))
    public VoidResponse publishOpenLineageEvent(@PathVariable String serverName, @PathVariable String serverGUID, @RequestBody String event) {
        return this.restAPI.publishOpenLineageEvent(serverName, serverGUID, event);
    }

    @GetMapping(path={"/cohort-members/{serverGUID}/cohorts/{cohortName}/connect"})
    @Operation(summary="connectToCohort", description="A new server needs to register the metadataCollectionId for its metadata repository with the other servers in the open metadata repository.  It only needs to do this once and uses a timestamp to record that the registration event has been sent. If the server has already registered in the past, it sends a reregistration request.", externalDocs=@ExternalDocumentation(description="Cohort Member", url="https://egeria-project.org/concepts/cohort-member/"))
    public BooleanResponse connectToCohortGet(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String cohortName) {
        return this.restAPI.connectToCohort(serverName, serverGUID, cohortName, null);
    }

    @PostMapping(path={"/cohort-members/{serverGUID}/cohorts/{cohortName}/connect"})
    @Operation(summary="connectToCohort", description="A new server needs to register the metadataCollectionId for its metadata repository with the other servers in the open metadata repository.  It only needs to do this once and uses a timestamp to record that the registration event has been sent. If the server has already registered in the past, it sends a reregistration request.", externalDocs=@ExternalDocumentation(description="Cohort Member", url="https://egeria-project.org/concepts/cohort-member/"))
    public BooleanResponse connectToCohortPost(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String cohortName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.connectToCohort(serverName, serverGUID, cohortName, requestBody);
    }

    @GetMapping(path={"/cohort-members/{serverGUID}/cohorts/{cohortName}/disconnect"})
    @Operation(summary="disconnectFromCohort", description="Disconnect communications from a specific cohort.", externalDocs=@ExternalDocumentation(description="Cohort Member", url="https://egeria-project.org/concepts/cohort-member/"))
    public BooleanResponse disconnectFromCohortGet(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String cohortName) {
        return this.restAPI.disconnectFromCohort(serverName, serverGUID, cohortName, null);
    }

    @PostMapping(path={"/cohort-members/{serverGUID}/cohorts/{cohortName}/disconnect"})
    @Operation(summary="disconnectFromCohort", description="Disconnect communications from a specific cohort.", externalDocs=@ExternalDocumentation(description="Cohort Member", url="https://egeria-project.org/concepts/cohort-member/"))
    public BooleanResponse disconnectFromCohortPost(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String cohortName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.disconnectFromCohort(serverName, serverGUID, cohortName, requestBody);
    }

    @GetMapping(path={"/cohort-members/{serverGUID}/cohorts/{cohortName}/unregister"})
    @Operation(summary="unregisterFromCohort", description="Unregister from a specific cohort and disconnect from cohort communications.", externalDocs=@ExternalDocumentation(description="Cohort Member", url="https://egeria-project.org/concepts/cohort-member/"))
    public BooleanResponse unregisterFromCohortGet(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String cohortName) {
        return this.restAPI.unregisterFromCohort(serverName, serverGUID, cohortName, null);
    }

    @PostMapping(path={"/cohort-members/{serverGUID}/cohorts/{cohortName}/unregister"})
    @Operation(summary="unregisterFromCohort", description="Unregister from a specific cohort and disconnect from cohort communications.", externalDocs=@ExternalDocumentation(description="Cohort Member", url="https://egeria-project.org/concepts/cohort-member/"))
    public BooleanResponse unregisterFromCohortPost(@PathVariable String serverName, @PathVariable String serverGUID, @PathVariable String cohortName, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unregisterFromCohort(serverName, serverGUID, cohortName, requestBody);
    }
}

