/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.search.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum SearchIntegratorAuditCode implements AuditLogMessageSet
{
    CONTEXT_INITIALIZING("OMIS-SEARCH-INTEGRATOR-0001", OMRSAuditLogRecordSeverity.STARTUP, "The search integrator context manager is being initialized for calls to server {0} on platform {1}", "The search Integrator OMIS is initializing its context manager.", "Verify that the start up sequence goes on to initialize the context for each connector configured for this service."),
    CONNECTOR_CONTEXT_INITIALIZING("OMIS-SEARCH-INTEGRATOR-0002", OMRSAuditLogRecordSeverity.STARTUP, "Creating context for integration connector {0} ({1}) connecting to third party technology {2} and service options of {3}", "A new context is created for an integration connector.  This acts as a client to the open metadata repositories enabling the integration connector to synchronize open metadata with the third party technology's metadata", "Verify that this connector is being started with the correct configuration."),
    NULL_CONTEXT("OMIS-SEARCH-INTEGRATOR-0003", OMRSAuditLogRecordSeverity.ERROR, "Integration connector {0} has a null context", "The integration connector is running but does not have a context.  This is a timing issue in the integration daemon.", "Gather information about the connector's configuration, the types of metadata it was integrating, the audit log messages from the integration daemon and its partner metadata server.  Then contact the Egeria community to get help."),
    REGISTER_CATALOG_LISTENER_ERROR("OMIS-SEARCH-INTEGRATOR-0004", OMRSAuditLogRecordSeverity.ERROR, "Integration connector {0} has an exception while attempting to register an Asset Catalog event listener", "The integration connector is running, but does not have a listener", "Gather information about the connector's configuration, the types of metadata it was integrating, the audit log messages from the integration daemon and its partner metadata server.  Then contact the Egeria community to get help.");

    AuditLogMessageDefinition messageDefinition;

    private SearchIntegratorAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "SearchIntegratorAuditCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

