/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.search.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalog;
import org.odpi.openmetadata.accessservices.assetcatalog.api.AssetCatalogEventListener;
import org.odpi.openmetadata.accessservices.assetcatalog.eventclient.AssetCatalogEventClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.ExternalAssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.search.client.AssetCatalogOutTopicEventListener;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorConnector;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorContext;
import org.odpi.openmetadata.integrationservices.search.ffdc.SearchIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.search.ffdc.SearchIntegratorErrorCode;

public class SearchIntegratorContextManager
extends IntegrationContextManager {
    private ExternalAssetManagerClient assetManagerClient = null;
    private AssetCatalogEventClient assetCatalogEventClient;
    private AssetCatalogOutTopicEventListener eventListener;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", SearchIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        AssetCatalog restClient = this.localServerPassword == null ? new AssetCatalog(this.partnerOMASServerName, this.partnerOMASPlatformRootURL) : new AssetCatalog(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword);
        this.assetCatalogEventClient = new AssetCatalogEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, (OCFRESTClient)restClient, this.maxPageSize, this.auditLog, this.localServerUserId);
        this.eventListener = new AssetCatalogOutTopicEventListener();
        try {
            this.assetCatalogEventClient.registerListener(this.localServerUserId, (AssetCatalogEventListener)this.eventListener);
        }
        catch (ConnectionCheckedException | ConnectorCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            e.printStackTrace();
        }
        AssetManagerRESTClient assetManagerRestClient = this.localServerPassword == null ? new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.assetManagerClient = new ExternalAssetManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, assetManagerRestClient, this.maxPageSize, this.auditLog);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        String metadataSourceGUID = this.assetManagerClient.getExternalAssetManagerGUID(this.localServerUserId, metadataSourceQualifiedName);
        if (metadataSourceGUID == null) {
            AssetManagerProperties properties = new AssetManagerProperties();
            properties.setQualifiedName(metadataSourceQualifiedName);
            metadataSourceGUID = this.assetManagerClient.createExternalAssetManager(this.localServerUserId, properties);
        }
        return metadataSourceGUID;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (!(integrationConnector instanceof SearchIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(SearchIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.SEARCH_INTEGRATOR_OMIS.getIntegrationServiceFullName(), SearchIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", SearchIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        SearchIntegratorConnector serviceSpecificConnector = (SearchIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        this.eventListener.setSearchIntegratorConnector(serviceSpecificConnector);
        serviceSpecificConnector.setContext(new SearchIntegratorContext(this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName, connectorName, this.assetCatalogEventClient, IntegrationServiceDescription.SEARCH_INTEGRATOR_OMIS.getIntegrationServiceFullName(), this.auditLog));
    }
}

