/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.search.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetmanager.client.AssetManagerClient;
import org.odpi.openmetadata.accessservices.assetmanager.client.rest.AssetManagerRESTClient;
import org.odpi.openmetadata.accessservices.assetmanager.properties.AssetManagerProperties;
import org.odpi.openmetadata.adminservices.configuration.properties.PermittedSynchronization;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.connectors.IntegrationConnector;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorConnector;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorContext;
import org.odpi.openmetadata.integrationservices.search.ffdc.SearchIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.search.ffdc.SearchIntegratorErrorCode;

public class SearchIntegratorContextManager
extends IntegrationContextManager {
    AssetManagerClient assetManagerClient;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", SearchIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        AssetManagerRESTClient restClient = this.localServerPassword == null ? new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.auditLog) : new AssetManagerRESTClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword, this.auditLog);
        this.assetManagerClient = new AssetManagerClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, restClient, this.maxPageSize, this.auditLog);
    }

    private String setUpMetadataSource(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataSourceQualifiedNameParameterName = "metadataSourceQualifiedName";
        String methodName = "setUpMetadataSource";
        InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
        invalidParameterHandler.validateName(metadataSourceQualifiedName, "metadataSourceQualifiedName", "setUpMetadataSource");
        String metadataSourceGUID = this.assetManagerClient.getExternalAssetManagerGUID(this.localServerUserId, metadataSourceQualifiedName);
        if (metadataSourceGUID == null) {
            AssetManagerProperties properties = new AssetManagerProperties();
            properties.setQualifiedName(metadataSourceQualifiedName);
            metadataSourceGUID = this.assetManagerClient.createExternalAssetManager(this.localServerUserId, properties);
        }
        return metadataSourceGUID;
    }

    public void setContext(String connectorId, String connectorName, String metadataSourceQualifiedName, IntegrationConnector integrationConnector, PermittedSynchronization permittedSynchronization, Map<String, Object> serviceOptions) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (serviceOptions != null) {
            serviceOptionsString = serviceOptions.toString();
        }
        if (!(integrationConnector instanceof SearchIntegratorConnector)) {
            String parameterName = "integrationConnector";
            throw new InvalidParameterException(SearchIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.SEARCH_INTEGRATOR_OMIS.getIntegrationServiceFullName(), SearchIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
        }
        this.auditLog.logMessage("setContext", SearchIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
        SearchIntegratorConnector serviceSpecificConnector = (SearchIntegratorConnector)integrationConnector;
        String metadataSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName);
        serviceSpecificConnector.setContext(new SearchIntegratorContext(this.localServerUserId, metadataSourceGUID, metadataSourceQualifiedName, connectorName, IntegrationServiceDescription.SEARCH_INTEGRATOR_OMIS.getIntegrationServiceFullName(), this.auditLog));
    }
}

