/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.integrationservices.search.contextmanager;

import java.util.Map;
import org.odpi.openmetadata.accessservices.assetcatalog.AssetCatalog;
import org.odpi.openmetadata.accessservices.assetcatalog.OpenIntegrationServiceClient;
import org.odpi.openmetadata.accessservices.assetcatalog.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.assetcatalog.api.AssetCatalogEventListener;
import org.odpi.openmetadata.accessservices.assetcatalog.eventclient.AssetCatalogEventClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.IntegrationContextManager;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.governanceservers.integrationdaemonservices.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorConnector;
import org.odpi.openmetadata.integrationservices.search.connector.SearchIntegratorContext;
import org.odpi.openmetadata.integrationservices.search.contextmanager.AssetCatalogOutTopicEventListener;
import org.odpi.openmetadata.integrationservices.search.ffdc.SearchIntegratorAuditCode;
import org.odpi.openmetadata.integrationservices.search.ffdc.SearchIntegratorErrorCode;

public class SearchIntegratorContextManager
extends IntegrationContextManager {
    private AssetCatalogEventClient assetCatalogEventClient;
    private AssetCatalogOutTopicEventListener eventListener;

    public void initializeContextManager(String partnerOMASServerName, String partnerOMASPlatformRootURL, String userId, String password, Map<String, Object> serviceOptions, int maxPageSize, AuditLog auditLog) {
        super.initializeContextManager(partnerOMASServerName, partnerOMASPlatformRootURL, userId, password, serviceOptions, maxPageSize, auditLog);
        String methodName = "initializeContextManager";
        auditLog.logMessage("initializeContextManager", SearchIntegratorAuditCode.CONTEXT_INITIALIZING.getMessageDefinition(new String[]{partnerOMASServerName, partnerOMASPlatformRootURL}));
    }

    public void createClients() throws InvalidParameterException {
        String methodName = "createClients";
        this.openIntegrationClient = new OpenIntegrationServiceClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL);
        this.openMetadataStoreClient = new OpenMetadataStoreClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL);
        AssetCatalog restClient = this.localServerPassword == null ? new AssetCatalog(this.partnerOMASServerName, this.partnerOMASPlatformRootURL) : new AssetCatalog(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, this.localServerUserId, this.localServerPassword);
        this.assetCatalogEventClient = new AssetCatalogEventClient(this.partnerOMASServerName, this.partnerOMASPlatformRootURL, (OCFRESTClient)restClient, this.maxPageSize, this.auditLog, this.localServerUserId);
        this.eventListener = new AssetCatalogOutTopicEventListener();
        try {
            this.assetCatalogEventClient.registerListener(this.localServerUserId, (AssetCatalogEventListener)this.eventListener);
        }
        catch (ConnectionCheckedException | ConnectorCheckedException | PropertyServerException | UserNotAuthorizedException e) {
            this.auditLog.logException("createClients", SearchIntegratorAuditCode.REGISTER_CATALOG_LISTENER_ERROR.getMessageDefinition(new String[]{IntegrationServiceDescription.SEARCH_INTEGRATOR_OMIS.getIntegrationServiceFullName()}), e);
        }
    }

    public IntegrationContext setContext(String connectorId, String connectorName, String connectorUserId, IntegrationConnector integrationConnector, String integrationConnectorGUID, PermittedSynchronization permittedSynchronization, boolean generateIntegrationReport, String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "setContext";
        String permittedSynchronizationName = PermittedSynchronization.BOTH_DIRECTIONS.getName();
        String serviceOptionsString = "null";
        if (permittedSynchronization != null) {
            permittedSynchronizationName = permittedSynchronization.getName();
        }
        if (this.serviceOptions != null) {
            serviceOptionsString = this.serviceOptions.toString();
        }
        if (integrationConnector instanceof SearchIntegratorConnector) {
            this.auditLog.logMessage("setContext", SearchIntegratorAuditCode.CONNECTOR_CONTEXT_INITIALIZING.getMessageDefinition(new String[]{connectorName, connectorId, metadataSourceQualifiedName, permittedSynchronizationName, serviceOptionsString}));
            SearchIntegratorConnector serviceSpecificConnector = (SearchIntegratorConnector)integrationConnector;
            String externalSourceGUID = this.setUpMetadataSource(metadataSourceQualifiedName, null, null);
            String externalSourceName = metadataSourceQualifiedName;
            if (externalSourceGUID == null) {
                externalSourceName = null;
            }
            this.eventListener.setSearchIntegratorConnector(serviceSpecificConnector);
            SearchIntegratorContext integratorContext = new SearchIntegratorContext(connectorId, connectorName, connectorUserId, this.partnerOMASServerName, this.openIntegrationClient, this.openMetadataStoreClient, this.assetCatalogEventClient, generateIntegrationReport, permittedSynchronization, integrationConnectorGUID, externalSourceGUID, externalSourceName, IntegrationServiceDescription.SEARCH_INTEGRATOR_OMIS.getIntegrationServiceFullName(), this.maxPageSize, this.auditLog);
            serviceSpecificConnector.setContext(integratorContext);
            integrationConnector.setConnectorName(connectorName);
            return integratorContext;
        }
        String parameterName = "integrationConnector";
        throw new InvalidParameterException(SearchIntegratorErrorCode.INVALID_CONNECTOR.getMessageDefinition(new String[]{connectorName, IntegrationServiceDescription.SEARCH_INTEGRATOR_OMIS.getIntegrationServiceFullName(), SearchIntegratorConnector.class.getCanonicalName()}), ((Object)((Object)this)).getClass().getName(), "setContext", "integrationConnector");
    }
}

