/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.securitymanager.properties.FileSystemProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class FileSystemRequestBody
extends FileSystemProperties {
    private static final long serialVersionUID = 1L;
    private String externalSourceGUID = null;
    private String externalSourceName = null;

    public FileSystemRequestBody() {
    }

    public FileSystemRequestBody(FileSystemRequestBody template) {
        super(template);
        if (template != null) {
            this.externalSourceGUID = template.getExternalSourceGUID();
            this.externalSourceName = template.getExternalSourceName();
        }
    }

    public FileSystemRequestBody(FileSystemProperties template) {
        super(template);
    }

    public String getExternalSourceGUID() {
        return this.externalSourceGUID;
    }

    public void setExternalSourceGUID(String externalSourceGUID) {
        this.externalSourceGUID = externalSourceGUID;
    }

    public String getExternalSourceName() {
        return this.externalSourceName;
    }

    public void setExternalSourceName(String externalSourceName) {
        this.externalSourceName = externalSourceName;
    }

    @Override
    public String toString() {
        return "FileSystemRequestBody{externalSourceGUID='" + this.externalSourceGUID + '\'' + ", externalSourceName='" + this.externalSourceName + '\'' + ", format='" + this.getFormat() + '\'' + ", encryption='" + this.getEncryption() + '\'' + ", displayName='" + this.getDisplayName() + '\'' + ", description='" + this.getDescription() + '\'' + ", typeDescription='" + this.getTypeDescription() + '\'' + ", version='" + this.getVersion() + '\'' + ", patchLevel='" + this.getPatchLevel() + '\'' + ", source='" + this.getSource() + '\'' + ", qualifiedName='" + this.getQualifiedName() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", vendorProperties=" + this.getVendorProperties() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        FileSystemRequestBody that = (FileSystemRequestBody)objectToCompare;
        return Objects.equals(this.externalSourceGUID, that.externalSourceGUID) && Objects.equals(this.externalSourceName, that.externalSourceName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.externalSourceGUID, this.externalSourceName);
    }
}

