/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum SecurityManagerEventType implements Serializable
{
    UNKNOWN_SECURITY_MANAGER_EVENT(0, "Unknown Event", "An event that is not recognized by the local server."),
    NEW_SECURITY_GROUP_EVENT(1, "New Security Group Event", "A new security group definition has been created."),
    UPDATED_SECURITY_GROUP_EVENT(2, "Updated Security Group Event", "The properties of a security group definition have been updated. "),
    DELETED_SECURITY_GROUP_EVENT(3, "Deleted Security Group Event", "A security group definition has been deleted. "),
    NEW_USER_IDENTITY_EVENT(11, "New User Identity Event", "A new user identity has been created."),
    UPDATED_USER_IDENTITY_EVENT(12, "Updated User Identity Event", "The properties of a user identity have been updated. "),
    GROUP_CHANGE_USER_IDENTITY_EVENT(13, "Group Change User Identity Event", "The groups of a user identity have been updated. "),
    DELETED_USER_IDENTITY_EVENT(14, "Deleted User Identity Event", "A user identity has been deleted. "),
    NEW_SECURITY_TAG_EVENT(21, "New Security Tag Event", "A new security tag definition has been attached to an element."),
    UPDATED_SECURITY_TAG_EVENT(22, "Updated Security Tag Event", "The properties of a security tag classification have been updated. "),
    DELETED_SECURITY_TAG_EVENT(23, "Deleted Security Tag Event", "A security tag classification has been removed from an element. ");

    private static final long serialVersionUID = 1L;
    private final int eventTypeCode;
    private final String eventTypeName;
    private final String eventTypeDescription;

    private SecurityManagerEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public String toString() {
        return "SecurityManagerEventType{eventTypeCode=" + this.eventTypeCode + ", eventTypeName='" + this.eventTypeName + "', eventTypeDescription='" + this.eventTypeDescription + "'}";
    }
}

