/* SPDX-License-Identifier: Apache-2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.securitymanager.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.NONE;
import static com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility.PUBLIC_ONLY;

/**
 * ProfileLocationProperties describes the properties for the ProfileLocation relationship between a profile
 * and a location.
 */
@JsonAutoDetect(getterVisibility=PUBLIC_ONLY, setterVisibility=PUBLIC_ONLY, fieldVisibility=NONE)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProfileLocationProperties implements Serializable
{
    private static final long serialVersionUID = 1L;

    private String associationType = null;


    /**
     * Default constructor
     */
    public ProfileLocationProperties()
    {
        super();
    }


    /**
     * Copy/clone constructor
     *
     * @param template object to copy
     */
    public ProfileLocationProperties(ProfileLocationProperties template)
    {
        if (template != null)
        {
            associationType = template.getAssociationType();
        }
    }


    /**
     * Return the type of the association.
     *
     * @return string
     */
    public String getAssociationType()
    {
        return associationType;
    }


    /**
     * Set up the type of the association.
     *
     * @param associationType string
     */
    public void setAssociationType(String associationType)
    {
        this.associationType = associationType;
    }


    /**
     * JSON-style toString.
     *
     * @return list of properties and their values.
     */
    @Override
    public String toString()
    {
        return "ProfileLocationProperties{" +
                       "associationType='" + associationType + '\'' +
                       '}';
    }


    /**
     * Equals method that returns true if containing properties are the same.
     *
     * @param objectToCompare object to compare
     * @return boolean result of comparison
     */
    @Override
    public boolean equals(Object objectToCompare)
    {
        if (this == objectToCompare)
        {
            return true;
        }
        if (objectToCompare == null || getClass() != objectToCompare.getClass())
        {
            return false;
        }
        ProfileLocationProperties that = (ProfileLocationProperties) objectToCompare;
        return Objects.equals(associationType, that.associationType);
    }


    /**
     * Hash code for this object
     *
     * @return int
     */
    @Override
    public int hashCode()
    {
        return Objects.hash(associationType);
    }
}
