/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum SecurityManagerEventType {
    UNKNOWN_EVENT(0, "Unknown Event", "An event that is not recognized by the local server."),
    REFRESH_ELEMENT_EVENT(1, "Refresh Element", "An element has been distributed around the cohort - could be for the first time."),
    NEW_ELEMENT_CREATED(2, "New Element", "A new element has been created."),
    ELEMENT_UPDATED(3, "Element Updated", "An element's properties has been updated."),
    ELEMENT_DELETED(4, "Element Deleted", "An element and all its anchored elements have been deleted."),
    ELEMENT_CLASSIFIED(5, "Element Classified", "A classification has been added to an element."),
    ELEMENT_RECLASSIFIED(6, "Element Reclassified", "The properties for a classification attached to an element have been updated."),
    ELEMENT_DECLASSIFIED(7, "Element Declassified", "A classification has been removed from an element."),
    ELEMENT_RESTORED(8, "Element Restored", "An element that was once deleted has been restored."),
    ELEMENT_GUID_CHANGED(9, "Element GUID Changed", "An element's GUID has changed."),
    ELEMENT_TYPE_CHANGED(10, "Element Type Changed", "An element's type has changed."),
    ELEMENT_HOME_CHANGED(11, "Element Home Changed", "An element's home has changed.");

    private final int eventTypeCode;
    private final String eventTypeName;
    private final String eventTypeDescription;

    private SecurityManagerEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public String toString() {
        return "SecurityManagerEventType{eventTypeCode=" + this.eventTypeCode + ", eventTypeName='" + this.eventTypeName + "', eventTypeDescription='" + this.eventTypeDescription + "'}";
    }
}

