/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.client.rest.SecurityManagerRESTClient;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.RelatedElement;
import org.odpi.openmetadata.accessservices.securitymanager.properties.ClassificationProperties;
import org.odpi.openmetadata.accessservices.securitymanager.properties.ReferenceableProperties;
import org.odpi.openmetadata.accessservices.securitymanager.properties.RelationshipProperties;
import org.odpi.openmetadata.accessservices.securitymanager.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.securitymanager.rest.ClassificationRequestBody;
import org.odpi.openmetadata.accessservices.securitymanager.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.accessservices.securitymanager.rest.ReferenceableRequestBody;
import org.odpi.openmetadata.accessservices.securitymanager.rest.RelatedElementListResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.RelationshipRequestBody;
import org.odpi.openmetadata.accessservices.securitymanager.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class SecurityManagerBaseClient {
    final String serverName;
    final String serverPlatformURLRoot;
    final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    final SecurityManagerRESTClient restClient;

    public SecurityManagerBaseClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public SecurityManagerBaseClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public SecurityManagerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public SecurityManagerBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public SecurityManagerBaseClient(String serverName, String serverPlatformURLRoot, SecurityManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    String createReferenceable(String userId, String externalSourceGUID, String externalSourceName, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    String createReferenceableFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, TemplateProperties templateProperties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String propertiesParameterName = "templateProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)templateProperties, "templateProperties", methodName);
        this.invalidParameterHandler.validateName(templateProperties.getQualifiedName(), "qualifiedName", methodName);
        TemplateRequestBody requestBody = new TemplateRequestBody(templateProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, templateGUID});
        return restResult.getGUID();
    }

    void updateReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, boolean isMergeUpdate, ReferenceableProperties properties, String propertiesParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)properties, propertiesParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", methodName);
        }
        ReferenceableRequestBody requestBody = new ReferenceableRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID, isMergeUpdate});
    }

    void setReferenceableClassification(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameter, ClassificationProperties properties, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ClassificationRequestBody requestBody = new ClassificationRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void removeReferenceableClassification(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameter, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameter, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    void setupRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, RelationshipProperties properties, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        RelationshipRequestBody requestBody = new RelationshipRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    void clearRelationship(String userId, String externalSourceGUID, String externalSourceName, String primaryElementGUID, String primaryElementGUIDParameterName, String secondaryElementGUID, String secondaryElementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryElementGUID, primaryElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(secondaryElementGUID, secondaryElementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, primaryElementGUID, secondaryElementGUID});
    }

    List<RelatedElement> getRelatedElements(String userId, String startingElementGUID, String startingElementGUIDParameterName, String urlTemplate, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(startingElementGUID, startingElementGUIDParameterName, methodName);
        RelatedElementListResponse restResult = this.restClient.callRelatedElementListGetRESTCall(methodName, urlTemplate, this.serverName, userId, startingElementGUID, Integer.toString(startFrom), Integer.toString(pageSize));
        return restResult.getElementList();
    }

    public void removeReferenceable(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String urlTemplate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(elementGUID, elementGUIDParameterName, methodName);
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall(methodName, urlTemplate, requestBody, new Object[]{this.serverName, userId, elementGUID});
    }
}

