/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.client;

import org.odpi.openmetadata.accessservices.securitymanager.api.MetadataSourceInterface;
import org.odpi.openmetadata.accessservices.securitymanager.client.rest.SecurityManagerRESTClient;
import org.odpi.openmetadata.accessservices.securitymanager.properties.SecurityManagerProperties;
import org.odpi.openmetadata.accessservices.securitymanager.rest.SecurityManagerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class MetadataSourceClient
extends ConnectedAssetClientBase
implements MetadataSourceInterface {
    private SecurityManagerRESTClient restClient;
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/metadata-sources";

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public MetadataSourceClient(String serverName, String serverPlatformURLRoot, SecurityManagerRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
        this.restClient = restClient;
    }

    public String createExternalSecurityManager(String userId, String externalSourceGUID, String externalSourceName, String typeName, SecurityManagerProperties securityManagerProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createExternalSecurityManager";
        String propertiesParameterName = "fileSystemProperties";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createExternalSecurityManager");
        this.invalidParameterHandler.validateObject((Object)securityManagerProperties, "fileSystemProperties", "createExternalSecurityManager");
        this.invalidParameterHandler.validateName(securityManagerProperties.getQualifiedName(), "qualifiedName", "createExternalSecurityManager");
        SecurityManagerRequestBody requestBody = new SecurityManagerRequestBody(securityManagerProperties);
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/metadata-sources/security-managers";
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createExternalSecurityManager", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public String getExternalSecurityManagerGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExternalSecurityManagerGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getExternalSecurityManagerGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getExternalSecurityManagerGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/metadata-sources/by-name/{2}";
        GUIDResponse restResult = this.restClient.callGUIDGetRESTCall("getExternalSecurityManagerGUID", urlTemplate, new Object[]{this.serverName, userId, qualifiedName});
        return restResult.getGUID();
    }
}

