/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.api.SecurityManagerInterface;
import org.odpi.openmetadata.accessservices.securitymanager.client.rest.SecurityManagerRESTClient;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ActorProfileResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ActorProfilesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AppointeesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonRoleResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityGroupResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityGroupsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentitiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentityResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.Appointee;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SecurityGroupElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityGroupProperties;

public class SecurityManagerClient
implements SecurityManagerInterface {
    private final String serverName;
    private final String serverPlatformURLRoot;
    private final SecurityManagerRESTClient restClient;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final NullRequestBody nullRequestBody = new NullRequestBody();
    private final String urlTemplatePrefix = "/servers/{0}/open-metadata/access-services/security-manager/users/{1}";

    public SecurityManagerClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot);
    }

    public SecurityManagerClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public SecurityManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public SecurityManagerClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new SecurityManagerRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public SecurityManagerClient(String serverName, String serverPlatformURLRoot, SecurityManagerRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
    }

    public String createSecurityGroup(String userId, SecurityGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createSecurityGroup";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/security-groups";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "createSecurityGroup");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createSecurityGroup");
        this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "createSecurityGroup");
        this.invalidParameterHandler.validateName(properties.getTitle(), "title", "createSecurityGroup");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createSecurityGroup", urlTemplate, properties, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateSecurityGroup(String userId, String securityGroupGUID, boolean isMergeUpdate, SecurityGroupProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateSecurityGroup";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/security-groups/{2}/update?isMergeUpdate={3}";
        String guidParameterName = "securityGroupGUID";
        String docIdParameterName = "documentIdentifier";
        String titleParameterName = "title";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateSecurityGroup");
        this.invalidParameterHandler.validateGUID(securityGroupGUID, "securityGroupGUID", "updateSecurityGroup");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateSecurityGroup");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getDocumentIdentifier(), "documentIdentifier", "updateSecurityGroup");
            this.invalidParameterHandler.validateName(properties.getTitle(), "title", "updateSecurityGroup");
        }
        this.restClient.callVoidPostRESTCall("updateSecurityGroup", urlTemplate, properties, new Object[]{this.serverName, userId, securityGroupGUID, isMergeUpdate});
    }

    public void deleteSecurityGroup(String userId, String securityGroupGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteSecurityGroup";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/security-groups/{2}/delete";
        String guidParameterName = "securityGroupGUID";
        this.invalidParameterHandler.validateGUID(securityGroupGUID, "securityGroupGUID", "deleteSecurityGroup");
        this.invalidParameterHandler.validateUserId(userId, "deleteSecurityGroup");
        this.restClient.callVoidPostRESTCall("deleteSecurityGroup", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, userId, securityGroupGUID});
    }

    public List<SecurityGroupElement> getSecurityGroupsForDistinguishedName(String userId, String distinguishedName, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSecurityGroupsForDistinguishedName";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/security-groups/for-distinguished-name/{2}?startFrom={3}&pageSize={4}";
        String parameterName = "distinguishedName";
        this.invalidParameterHandler.validateUserId(userId, "getSecurityGroupsForDistinguishedName");
        this.invalidParameterHandler.validateName("distinguishedName", "distinguishedName", "getSecurityGroupsForDistinguishedName");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getSecurityGroupsForDistinguishedName");
        SecurityGroupsResponse restResult = this.restClient.callSecurityGroupsGetRESTCall("getSecurityGroupsForDistinguishedName", urlTemplate, new Object[]{this.serverName, userId, distinguishedName, startFrom, queryPageSize});
        return restResult.getElements();
    }

    public List<ElementStub> getElementsGovernedBySecurityGroup(String userId, String securityGroupGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getElementsGovernedBySecurityGroup";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/security-groups/{2}/governed-by/elements?startFrom={3}&pageSize={4}";
        String guidParameterName = "securityGroupGUID";
        this.invalidParameterHandler.validateUserId(userId, "getElementsGovernedBySecurityGroup");
        this.invalidParameterHandler.validateGUID(securityGroupGUID, "securityGroupGUID", "getElementsGovernedBySecurityGroup");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getElementsGovernedBySecurityGroup");
        ElementStubsResponse restResult = this.restClient.callElementStubsGetRESTCall("getElementsGovernedBySecurityGroup", urlTemplate, new Object[]{this.serverName, userId, securityGroupGUID, startFrom, queryPageSize});
        return restResult.getElements();
    }

    public List<SecurityGroupElement> findSecurityGroups(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findSecurityGroups";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/security-groups/by-search-string?startFrom={2}&pageSize={3}";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(this.serverPlatformURLRoot, this.serverName, "findSecurityGroups");
        this.invalidParameterHandler.validateUserId(userId, "findSecurityGroups");
        this.invalidParameterHandler.validateSearchString(searchString, searchString, "findSecurityGroups");
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findSecurityGroups");
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        SecurityGroupsResponse restResult = this.restClient.callSecurityGroupsPostRESTCall("findSecurityGroups", urlTemplate, requestBody, new Object[]{this.serverName, userId, startFrom, queryPageSize});
        return restResult.getElements();
    }

    public SecurityGroupElement getSecurityGroupByGUID(String userId, String securityGroupGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSecurityGroupByGUID";
        String userIdentityGUIDParameterName = "securityGroupGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSecurityGroupByGUID");
        this.invalidParameterHandler.validateGUID(securityGroupGUID, "securityGroupGUID", "getSecurityGroupByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/security-groups/{2}";
        SecurityGroupResponse restResult = this.restClient.callSecurityGroupGetRESTCall("getSecurityGroupByGUID", urlTemplate, new Object[]{this.serverName, userId, securityGroupGUID});
        return restResult.getElement();
    }

    public String createUserIdentity(String userId, String externalSourceGUID, String externalSourceName, UserIdentityProperties newIdentity) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createUserIdentity";
        String propertiesParameterName = "newIdentity";
        String qualifiedNameParameterName = "newIdentity.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createUserIdentity");
        this.invalidParameterHandler.validateObject((Object)newIdentity, "newIdentity", "createUserIdentity");
        this.invalidParameterHandler.validateName(newIdentity.getQualifiedName(), "newIdentity.qualifiedName", "createUserIdentity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/user-identities";
        UserIdentityRequestBody requestBody = new UserIdentityRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(newIdentity);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId});
        return restResult.getGUID();
    }

    public void updateUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID, boolean isMergeUpdate, UserIdentityProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateUserIdentity";
        String guidParameterName = "userIdentityGUID";
        String propertiesParameterName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateUserIdentity");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "updateUserIdentity");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateUserIdentity");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateUserIdentity");
        }
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/user-identities/{2}?isMergeUpdate={3}";
        UserIdentityRequestBody requestBody = new UserIdentityRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        requestBody.setProperties(properties);
        this.restClient.callVoidPostRESTCall("updateUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID, isMergeUpdate});
    }

    public void deleteUserIdentity(String userId, String externalSourceGUID, String externalSourceName, String userIdentityGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteUserIdentity";
        String guidParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteUserIdentity");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "deleteUserIdentity");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/user-identities/{2}";
        ExternalSourceRequestBody requestBody = new ExternalSourceRequestBody();
        requestBody.setExternalSourceGUID(externalSourceGUID);
        requestBody.setExternalSourceName(externalSourceName);
        this.restClient.callVoidPostRESTCall("deleteUserIdentity", urlTemplate, requestBody, new Object[]{this.serverName, userId, userIdentityGUID});
    }

    public List<UserIdentityElement> findUserIdentities(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "findUserIdentities";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findUserIdentities");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findUserIdentities");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/user-identities/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        UserIdentitiesResponse restResult = this.restClient.callUserIdentitiesPostRESTCall("findUserIdentities", urlTemplate, requestBody, new Object[]{this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public List<UserIdentityElement> getUserIdentitiesByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getUserIdentitiesByName";
        String namePropertyName = "qualifiedName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getUserIdentitiesByName");
        this.invalidParameterHandler.validateName(name, "name", "getUserIdentitiesByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/user-identities/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("qualifiedName");
        requestBody.setNameParameterName("name");
        UserIdentitiesResponse restResult = this.restClient.callUserIdentitiesPostRESTCall("getUserIdentitiesByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public UserIdentityElement getUserIdentityByGUID(String userId, String userIdentityGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getUserIdentityByGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        this.invalidParameterHandler.validateUserId(userId, "getUserIdentityByGUID");
        this.invalidParameterHandler.validateGUID(userIdentityGUID, "userIdentityGUID", "getUserIdentityByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/user-identities/{2}";
        UserIdentityResponse restResult = this.restClient.callUserIdentityGetRESTCall("getUserIdentityByGUID", urlTemplate, new Object[]{this.serverName, userId, userIdentityGUID});
        return restResult.getElement();
    }

    public ActorProfileElement getActorProfileByGUID(String userId, String actorProfileGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActorProfileByGUID";
        String guidParameterName = "actorProfileGUID";
        this.invalidParameterHandler.validateUserId(userId, "getActorProfileByGUID");
        this.invalidParameterHandler.validateGUID(actorProfileGUID, "actorProfileGUID", "getActorProfileByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/profiles/{2}";
        ActorProfileResponse restResult = this.restClient.callActorProfileGetRESTCall("getActorProfileByGUID", urlTemplate, new Object[]{this.serverName, userId, actorProfileGUID});
        return restResult.getElement();
    }

    public ActorProfileElement getActorProfileByUserId(String userId, String actorProfileUserId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActorProfileByGUID";
        String nameParameterName = "actorProfileUserId";
        this.invalidParameterHandler.validateUserId(userId, "getActorProfileByGUID");
        this.invalidParameterHandler.validateName(actorProfileUserId, "actorProfileUserId", "getActorProfileByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/profiles/user-ids/{2}";
        ActorProfileResponse restResult = this.restClient.callActorProfileGetRESTCall("getActorProfileByGUID", urlTemplate, new Object[]{this.serverName, userId, actorProfileUserId});
        return restResult.getElement();
    }

    public List<ActorProfileElement> getActorProfileByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getActorProfileByName";
        String namePropertyName = "name";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getActorProfileByName");
        this.invalidParameterHandler.validateName(name, "name", "getActorProfileByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/profiles/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        requestBody.setNameParameterName("name");
        ActorProfilesResponse restResult = this.restClient.callActorProfilesPostRESTCall("getActorProfileByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public List<ActorProfileElement> findActorProfile(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findActorProfile";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findActorProfile");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findActorProfile");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/profiles/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        ActorProfilesResponse restResult = this.restClient.callActorProfilesPostRESTCall("findActorProfile", urlTemplate, requestBody, new Object[]{this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public List<Appointee> getAppointees(String userId, String personRoleGUID, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAppointees";
        String personRoleGUIDParameterName = "personRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAppointees");
        this.invalidParameterHandler.validateGUID(personRoleGUID, "personRoleGUID", "getAppointees");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/person-roles/{2}/appointees?startFrom={3}&pageSize={4}";
        ResultsRequestBody requestBody = new ResultsRequestBody();
        requestBody.setEffectiveTime(effectiveTime);
        AppointeesResponse restResult = this.restClient.callAppointeesPostRESTCall("getAppointees", urlTemplate, requestBody, new Object[]{this.serverName, userId, personRoleGUID, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public PersonRoleElement getPersonRoleByGUID(String userId, String personRoleGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPersonRoleByGUID";
        String guidParameterName = "personRoleGUID";
        this.invalidParameterHandler.validateUserId(userId, "getPersonRoleByGUID");
        this.invalidParameterHandler.validateGUID(personRoleGUID, "personRoleGUID", "getPersonRoleByGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/person-roles/{2}";
        PersonRoleResponse restResult = this.restClient.callPersonRoleGetRESTCall("getPersonRoleByGUID", urlTemplate, new Object[]{this.serverName, userId, personRoleGUID});
        return restResult.getElement();
    }

    public List<PersonRoleElement> getPersonRoleByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPersonRoleByName";
        String namePropertyName = "name";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getPersonRoleByName");
        this.invalidParameterHandler.validateName(name, "name", "getPersonRoleByName");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/person-roles/by-name?startFrom={2}&pageSize={3}";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(name);
        requestBody.setNamePropertyName("name");
        requestBody.setNameParameterName("name");
        PersonRolesResponse restResult = this.restClient.callPersonRolesPostRESTCall("getPersonRoleByName", urlTemplate, requestBody, new Object[]{this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }

    public List<PersonRoleElement> findPersonRole(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findPersonRole";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findPersonRole");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findPersonRole");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/security-manager/users/{1}/person-roles/by-search-string?startFrom={2}&pageSize={3}";
        SearchStringRequestBody requestBody = new SearchStringRequestBody();
        requestBody.setSearchString(searchString);
        requestBody.setSearchStringParameterName("searchString");
        PersonRolesResponse restResult = this.restClient.callPersonRolesPostRESTCall("findPersonRole", urlTemplate, requestBody, new Object[]{this.serverName, userId, Integer.toString(startFrom), Integer.toString(pageSize)});
        return restResult.getElements();
    }
}

