/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.converters;

import org.odpi.openmetadata.accessservices.securitymanager.converters.SecurityManagerOMASConverter;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.DataFileElement;
import org.odpi.openmetadata.accessservices.securitymanager.properties.DataFileProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DataFileConverter<B>
extends SecurityManagerOMASConverter<B> {
    public DataFileConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof DataFileElement) {
                DataFileElement bean = (DataFileElement)returnBean;
                DataFileProperties dataFileProperties = new DataFileProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    dataFileProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    dataFileProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    dataFileProperties.setDisplayName(this.removeName(instanceProperties));
                    dataFileProperties.setDescription(this.removeDescription(instanceProperties));
                    dataFileProperties.setPathName(this.removePathName(instanceProperties));
                    dataFileProperties.setCreateTime(this.removeStoreCreateTime(instanceProperties));
                    dataFileProperties.setModifiedTime(this.removeStoreUpdateTime(instanceProperties));
                    dataFileProperties.setOwner(this.removeOwner(instanceProperties));
                    dataFileProperties.setOwnerCategory(this.removeOwnerCategoryFromProperties(instanceProperties));
                    dataFileProperties.setZoneMembership(this.removeZoneMembership(instanceProperties));
                    dataFileProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    dataFileProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetZoneMembership", entity);
                    dataFileProperties.setZoneMembership(this.getZoneMembership(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOwnership", entity);
                    dataFileProperties.setOwner(this.getOwner(instanceProperties));
                    dataFileProperties.setOwnerCategory(this.getOwnerCategoryFromProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOrigin", entity);
                    dataFileProperties.setOriginOrganizationGUID(this.getOriginOrganizationGUID(instanceProperties));
                    dataFileProperties.setOriginBusinessCapabilityGUID(this.getOriginBusinessCapabilityGUID(instanceProperties));
                    dataFileProperties.setOtherOriginValues(this.getOtherOriginValues(instanceProperties));
                    instanceProperties = super.getClassificationProperties("DataStoreEncoding", entity);
                    dataFileProperties.setEncodingType(this.getDataStoreEncodingType(instanceProperties));
                    dataFileProperties.setEncodingLanguage(this.getDataStoreEncodingLanguage(instanceProperties));
                    dataFileProperties.setEncodingDescription(this.getDataStoreEncodingDescription(instanceProperties));
                    dataFileProperties.setEncodingProperties(this.getEncodingProperties(instanceProperties));
                    bean.setDataFileProperties(dataFileProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

