/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.converters;

import org.odpi.openmetadata.accessservices.securitymanager.converters.SecurityManagerOMASConverter;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.DatabaseSchemaElement;
import org.odpi.openmetadata.accessservices.securitymanager.properties.DatabaseSchemaProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseSchemaConverter<B>
extends SecurityManagerOMASConverter<B> {
    public DatabaseSchemaConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof DatabaseSchemaElement) {
                DatabaseSchemaElement bean = (DatabaseSchemaElement)returnBean;
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    DatabaseSchemaProperties databaseSchemaProperties = new DatabaseSchemaProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    databaseSchemaProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    databaseSchemaProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    databaseSchemaProperties.setDisplayName(this.removeName(instanceProperties));
                    databaseSchemaProperties.setDescription(this.removeDescription(instanceProperties));
                    databaseSchemaProperties.setOwner(this.removeOwner(instanceProperties));
                    databaseSchemaProperties.setOwnerCategory(this.removeOwnerCategoryFromProperties(instanceProperties));
                    databaseSchemaProperties.setZoneMembership(this.removeZoneMembership(instanceProperties));
                    databaseSchemaProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    databaseSchemaProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetZoneMembership", entity);
                    databaseSchemaProperties.setZoneMembership(this.getZoneMembership(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOwnership", entity);
                    databaseSchemaProperties.setOwner(this.getOwner(instanceProperties));
                    databaseSchemaProperties.setOwnerCategory(this.getOwnerCategoryFromProperties(instanceProperties));
                    instanceProperties = super.getClassificationProperties("AssetOrigin", entity);
                    databaseSchemaProperties.setOriginOrganizationGUID(this.getOriginOrganizationGUID(instanceProperties));
                    databaseSchemaProperties.setOriginBusinessCapabilityGUID(this.getOriginBusinessCapabilityGUID(instanceProperties));
                    databaseSchemaProperties.setOtherOriginValues(this.getOtherOriginValues(instanceProperties));
                    bean.setDatabaseSchemaProperties(databaseSchemaProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

