/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.converters;

import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.converters.SecurityManagerOMASConverter;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.DatabaseTableElement;
import org.odpi.openmetadata.accessservices.securitymanager.properties.DatabaseTableProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DatabaseTableConverter<B>
extends SecurityManagerOMASConverter<B> {
    public DatabaseTableConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.newInstance();
            if (returnBean instanceof DatabaseTableElement) {
                DatabaseTableElement bean = (DatabaseTableElement)returnBean;
                DatabaseTableProperties databaseTableProperties = new DatabaseTableProperties();
                if (schemaAttributeEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaAttributeEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(schemaAttributeEntity.getProperties());
                    databaseTableProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    databaseTableProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    databaseTableProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    databaseTableProperties.setDescription(this.removeDescription(instanceProperties));
                    databaseTableProperties.setAliases(this.removeAliases(instanceProperties));
                    databaseTableProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    databaseTableProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setDatabaseTableProperties(databaseTableProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

