/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.connectors.outtopic.SecurityManagerOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.securitymanager.connectors.outtopic.SecurityManagerOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.securitymanager.ffdc.SecurityManagerAuditCode;
import org.odpi.openmetadata.accessservices.securitymanager.listener.SecurityManagerOMRSTopicListener;
import org.odpi.openmetadata.accessservices.securitymanager.outtopic.SecurityManagerOutTopicPublisher;
import org.odpi.openmetadata.accessservices.securitymanager.server.SecurityManagerServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceAdmin;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SecurityManagerAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private SecurityManagerServicesInstance instance = null;
    private OpenMetadataTopicConnector inTopicConnector = null;
    private String serverName = null;
    private SecurityManagerOutTopicPublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "Initialize Security Manager OMAS service.";
        auditLog.logMessage("Initialize Security Manager OMAS service.", SecurityManagerAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = this.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = this.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new SecurityManagerServicesInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), accessServiceConfig.getAccessServiceOutTopic());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.SECURITY_MANAGER_OMAS.getAccessServiceFullName(), SecurityManagerOutTopicServerProvider.class.getName(), auditLog);
                SecurityManagerOutTopicServerConnector outTopicServerConnector = (SecurityManagerOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, SecurityManagerOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.SECURITY_MANAGER_OMAS.getAccessServiceFullName(), "Initialize Security Manager OMAS service.");
                this.eventPublisher = new SecurityManagerOutTopicPublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog, repositoryConnector.getRepositoryHelper(), AccessServiceDescription.SECURITY_MANAGER_OMAS.getAccessServiceFullName(), this.serverName);
                this.registerWithEnterpriseTopic(AccessServiceDescription.SECURITY_MANAGER_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new SecurityManagerOMRSTopicListener(AccessServiceDescription.SECURITY_MANAGER_OMAS.getAccessServiceFullName(), this.eventPublisher, supportedZones, repositoryConnector.getRepositoryHelper(), outTopicAuditLog), auditLog);
            }
            if (accessServiceConfig.getAccessServiceInTopic() != null) {
                this.inTopicConnector = super.getInTopicEventBusConnector(accessServiceConfig.getAccessServiceInTopic(), AccessServiceDescription.SECURITY_MANAGER_OMAS.getAccessServiceFullName(), auditLog);
            }
            auditLog.logMessage("Initialize Security Manager OMAS service.", SecurityManagerAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("Initialize Security Manager OMAS service.", SecurityManagerAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("Initialize Security Manager OMAS service.", AccessServiceDescription.SECURITY_MANAGER_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        try {
            if (this.inTopicConnector != null) {
                this.inTopicConnector.disconnect();
            }
        }
        catch (ConnectorCheckedException error) {
            this.auditLog.logException("shutdown", SecurityManagerAuditCode.SERVICE_INSTANCE_TERMINATION_FAILURE.getMessageDefinition(new String[]{this.serverName}), (Throwable)error);
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", SecurityManagerAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

