/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.converters;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ElementClassification;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ElementHeader;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ElementOrigin;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ElementOriginCategory;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ElementStatus;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ElementType;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ElementVersions;
import org.odpi.openmetadata.accessservices.securitymanager.properties.ContactMethodType;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SecurityManagerOMASConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    public SecurityManagerOMASConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    ElementHeader getMetadataElementHeader(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            return this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName);
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementHeader getMetadataElementHeader(Class<B> beanClass, InstanceHeader header, List<Classification> entityClassifications, String methodName) throws PropertyServerException {
        if (header != null) {
            ElementHeader elementHeader = new ElementHeader();
            elementHeader.setGUID(header.getGUID());
            elementHeader.setStatus(this.getElementStatus(header.getStatus()));
            elementHeader.setClassifications(this.getEntityClassifications(entityClassifications));
            elementHeader.setType(this.getElementType((InstanceAuditHeader)header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            elementHeader.setVersions(this.getElementVersions((InstanceAuditHeader)header));
            return elementHeader;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    public ElementStub getElementStub(Class<B> beanClass, EntityProxy entityProxy, String methodName) throws PropertyServerException {
        if (entityProxy != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            elementStub.setUniqueName(this.repositoryHelper.getStringProperty(this.serviceName, "qualifiedName", entityProxy.getUniqueProperties(), methodName));
            return elementStub;
        }
        super.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    private List<ElementClassification> getEntityClassifications(EntityDetail entity) {
        if (entity != null) {
            return this.getEntityClassifications(entity.getClassifications());
        }
        return null;
    }

    private List<ElementClassification> getEntityClassifications(List<Classification> entityClassifications) {
        ArrayList<ElementClassification> beanClassifications = null;
        if (entityClassifications != null) {
            beanClassifications = new ArrayList<ElementClassification>();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification();
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    protected ElementClassification getClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || !classification.getClassificationName().equals(classificationName)) continue;
                return classification;
            }
        }
        return null;
    }

    protected List<ElementClassification> removeClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            ArrayList<ElementClassification> results = new ArrayList<ElementClassification>();
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || classification.getClassificationName().equals(classificationName)) continue;
                results.add(classification);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    ElementType getElementType(InstanceAuditHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            elementType.setTypeId(instanceType.getTypeDefGUID());
            elementType.setTypeName(instanceType.getTypeDefName());
            elementType.setTypeVersion(instanceType.getTypeDefVersion());
            elementType.setTypeDescription(instanceType.getTypeDefDescription());
            List typeDefSuperTypes = instanceType.getTypeDefSuperTypes();
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    ElementVersions getElementVersions(InstanceAuditHeader header) {
        ElementVersions elementVersions = new ElementVersions();
        elementVersions.setCreatedBy(header.getCreatedBy());
        elementVersions.setCreateTime(header.getCreateTime());
        elementVersions.setUpdatedBy(header.getUpdatedBy());
        elementVersions.setUpdateTime(header.getUpdateTime());
        elementVersions.setMaintainedBy(header.getMaintainedBy());
        elementVersions.setVersion(header.getVersion());
        return elementVersions;
    }

    ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            switch (instanceProvenanceType) {
                case DEREGISTERED_REPOSITORY: {
                    return ElementOriginCategory.DEREGISTERED_REPOSITORY;
                }
                case EXTERNAL_SOURCE: {
                    return ElementOriginCategory.EXTERNAL_SOURCE;
                }
                case EXPORT_ARCHIVE: {
                    return ElementOriginCategory.EXPORT_ARCHIVE;
                }
                case LOCAL_COHORT: {
                    return ElementOriginCategory.LOCAL_COHORT;
                }
                case CONTENT_PACK: {
                    return ElementOriginCategory.CONTENT_PACK;
                }
                case CONFIGURATION: {
                    return ElementOriginCategory.CONFIGURATION;
                }
                case UNKNOWN: {
                    return ElementOriginCategory.UNKNOWN;
                }
            }
        }
        return ElementOriginCategory.UNKNOWN;
    }

    ContactMethodType getContactMethodTypeFromProperties(InstanceProperties properties) {
        String methodName = "getContactMethodTypeFromProperties";
        ContactMethodType contactMethodType = ContactMethodType.OTHER;
        if (properties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, "contactMethodType", properties, "getContactMethodTypeFromProperties");
            switch (ordinal) {
                case 0: {
                    contactMethodType = ContactMethodType.EMAIL;
                    break;
                }
                case 1: {
                    contactMethodType = ContactMethodType.PHONE;
                    break;
                }
                case 2: {
                    contactMethodType = ContactMethodType.CHAT;
                    break;
                }
                case 3: {
                    contactMethodType = ContactMethodType.PROFILE;
                    break;
                }
                case 4: {
                    contactMethodType = ContactMethodType.ACCOUNT;
                    break;
                }
                case 99: {
                    contactMethodType = ContactMethodType.OTHER;
                }
            }
        }
        return contactMethodType;
    }
}

