/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.server;

import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.connectors.outtopic.SecurityManagerOutTopicClientProvider;
import org.odpi.openmetadata.accessservices.securitymanager.converters.ActorProfileConverter;
import org.odpi.openmetadata.accessservices.securitymanager.converters.ContactMethodConverter;
import org.odpi.openmetadata.accessservices.securitymanager.converters.PersonRoleConverter;
import org.odpi.openmetadata.accessservices.securitymanager.converters.SecurityGroupConverter;
import org.odpi.openmetadata.accessservices.securitymanager.converters.SecurityManagerConverter;
import org.odpi.openmetadata.accessservices.securitymanager.converters.UserIdentityConverter;
import org.odpi.openmetadata.accessservices.securitymanager.ffdc.SecurityManagerErrorCode;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.ContactMethodElement;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.SecurityGroupElement;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.SecurityManagerElement;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ContactDetailsHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityHandler;
import org.odpi.openmetadata.commonservices.multitenant.OMASServiceInstance;
import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class SecurityManagerServicesInstance
extends OMASServiceInstance {
    private static final AccessServiceDescription myDescription = AccessServiceDescription.SECURITY_MANAGER_OMAS;
    private final SoftwareCapabilityHandler<SecurityManagerElement> softwareCapabilityHandler;
    private final GovernanceDefinitionHandler<SecurityGroupElement> securityGroupHandler;
    private final UserIdentityHandler<UserIdentityElement> userIdentityHandler;
    private final ContactDetailsHandler<ContactMethodElement> contactDetailsHandler;
    private final ActorProfileHandler<ActorProfileElement> actorProfileHandler;
    private final PersonRoleHandler<PersonRoleElement> personRoleHandler;

    public SecurityManagerServicesInstance(OMRSRepositoryConnector repositoryConnector, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog, String localServerUserId, int maxPageSize, Connection outTopicEventBusConnection) throws NewInstanceException {
        super(myDescription.getAccessServiceFullName(), repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, localServerUserId, maxPageSize, null, null, SecurityManagerOutTopicClientProvider.class.getName(), outTopicEventBusConnection);
        if (this.repositoryHandler == null) {
            String methodName = "new ServiceInstance";
            throw new NewInstanceException(SecurityManagerErrorCode.OMRS_NOT_INITIALIZED.getMessageDefinition(new String[]{"new ServiceInstance"}), ((Object)((Object)this)).getClass().getName(), "new ServiceInstance");
        }
        this.softwareCapabilityHandler = new SoftwareCapabilityHandler(new SecurityManagerConverter(this.repositoryHelper, this.serviceName, this.serverName), SecurityManagerElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.userIdentityHandler = new UserIdentityHandler(new UserIdentityConverter(this.repositoryHelper, this.serviceName, this.serverName), UserIdentityElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.securityGroupHandler = new GovernanceDefinitionHandler(new SecurityGroupConverter(this.repositoryHelper, this.serviceName, this.serverName), SecurityGroupElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.actorProfileHandler = new ActorProfileHandler(new ActorProfileConverter(this.repositoryHelper, this.serviceName, this.serverName), ActorProfileElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.personRoleHandler = new PersonRoleHandler(new PersonRoleConverter(this.repositoryHelper, this.serviceName, this.serverName), PersonRoleElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.contactDetailsHandler = new ContactDetailsHandler(new ContactMethodConverter(this.repositoryHelper, this.serviceName, this.serverName), ContactMethodElement.class, this.serviceName, this.serverName, this.invalidParameterHandler, this.repositoryHandler, this.repositoryHelper, localServerUserId, this.securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    SoftwareCapabilityHandler<SecurityManagerElement> getSoftwareCapabilityHandler() throws PropertyServerException {
        String methodName = "getSoftwareCapabilityHandler";
        this.validateActiveRepository("getSoftwareCapabilityHandler");
        return this.softwareCapabilityHandler;
    }

    public UserIdentityHandler<UserIdentityElement> getUserIdentityHandler() throws PropertyServerException {
        String methodName = "getUserIdentityHandler";
        this.validateActiveRepository("getUserIdentityHandler");
        return this.userIdentityHandler;
    }

    public GovernanceDefinitionHandler<SecurityGroupElement> getSecurityGroupHandler() throws PropertyServerException {
        String methodName = "getSecurityGroupHandler";
        this.validateActiveRepository("getSecurityGroupHandler");
        return this.securityGroupHandler;
    }

    public ActorProfileHandler<ActorProfileElement> getActorProfileHandler() throws PropertyServerException {
        String methodName = "getActorProfileHandler";
        this.validateActiveRepository("getActorProfileHandler");
        return this.actorProfileHandler;
    }

    public PersonRoleHandler<PersonRoleElement> getPersonRoleHandler() throws PropertyServerException {
        String methodName = "getPersonRoleHandler";
        this.validateActiveRepository("getPersonRoleHandler");
        return this.personRoleHandler;
    }
}

