/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.converters.SecurityManagerOMASConverter;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.accessservices.securitymanager.properties.PersonRoleProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStub;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PersonRoleConverter<B>
extends SecurityManagerOMASConverter<B> {
    public PersonRoleConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof PersonRoleElement) {
                PersonRoleElement bean = (PersonRoleElement)returnBean;
                PersonRoleProperties roleProperties = new PersonRoleProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    roleProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    roleProperties.setRoleId(this.removeIdentifier(instanceProperties));
                    roleProperties.setTitle(this.removeTitle(instanceProperties));
                    roleProperties.setDescription(this.removeDescription(instanceProperties));
                    roleProperties.setScope(this.removeScope(instanceProperties));
                    roleProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    roleProperties.setHeadCountLimitSet(instanceProperties.getPropertyValue("headCount") != null);
                    roleProperties.setHeadCount(this.removeHeadCount(instanceProperties));
                    roleProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    roleProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    roleProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    roleProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    roleProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    if (relationships != null) {
                        ArrayList<ElementStub> appointees = new ArrayList<ElementStub>();
                        for (Relationship relationship : relationships) {
                            InstanceType instanceType;
                            if (relationship == null || (instanceType = relationship.getType()) == null || !this.repositoryHelper.isTypeOf(this.serviceName, instanceType.getTypeDefName(), "PersonRoleAppointment")) continue;
                            EntityProxy entityProxy = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                            ElementStub elementStub = super.getElementStub(beanClass, entityProxy, methodName);
                            appointees.add(elementStub);
                        }
                        if (!appointees.isEmpty()) {
                            bean.setAppointees(appointees);
                        }
                    }
                    bean.setProperties(roleProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

