/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.securitymanager.converters.SecurityManagerOMASConverter;
import org.odpi.openmetadata.accessservices.securitymanager.metadataelements.SecurityManagerElement;
import org.odpi.openmetadata.accessservices.securitymanager.properties.SecurityManagerProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SecurityManagerConverter<B>
extends SecurityManagerOMASConverter<B> {
    public SecurityManagerConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SecurityManagerElement) {
                SecurityManagerElement bean = (SecurityManagerElement)returnBean;
                SecurityManagerProperties securityManagerProperties = new SecurityManagerProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    securityManagerProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    securityManagerProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    securityManagerProperties.setDisplayName(this.removeName(instanceProperties));
                    securityManagerProperties.setDescription(this.removeDescription(instanceProperties));
                    securityManagerProperties.setDeployedImplementationType(this.removeCapabilityType(instanceProperties));
                    securityManagerProperties.setVersion(this.removeCapabilityVersion(instanceProperties));
                    securityManagerProperties.setPatchLevel(this.removePatchLevel(instanceProperties));
                    securityManagerProperties.setSource(this.removeSource(instanceProperties));
                    securityManagerProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    securityManagerProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setSecurityManagerProperties(securityManagerProperties);
                } else {
                    this.handleMissingMetadataInstance(SecurityManagerProperties.class.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

