/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.converters.SecurityManagerOMASConverter;
import org.odpi.openmetadata.accessservices.securitymanager.server.SecurityManagerInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.ActorProfileResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ActorProfilesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.AppointeesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ExternalSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.OCFConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonRoleResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.PersonRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityGroupResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityGroupsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SecurityManagerRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentitiesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UserIdentityResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.ActorProfileHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PersonRoleHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.generichandlers.UserIdentityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorProfileElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.Appointee;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.PersonRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SecurityGroupElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SecurityManagerElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.UserIdentityElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.UserIdentityProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityGroupProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class SecurityManagerRESTServices {
    private static final SecurityManagerInstanceHandler instanceHandler = new SecurityManagerInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SecurityManagerRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public OCFConnectionResponse getOutTopicConnection(String serverName, String userId, String callerId) {
        String methodName = "getOutTopicConnection";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getOutTopicConnection");
        OCFConnectionResponse response = new OCFConnectionResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getOutTopicConnection");
            response.setConnection(instanceHandler.getOutTopicConnection(userId, serverName, "getOutTopicConnection", callerId));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getOutTopicConnection", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSecurityManagerInCatalog(String serverName, String userId, SecurityManagerRequestBody requestBody) {
        String methodName = "createSecurityManagerInCatalog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSecurityManagerInCatalog");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createSecurityManagerInCatalog");
            if (requestBody != null) {
                SoftwareCapabilityHandler<SecurityManagerElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "createSecurityManagerInCatalog");
                response.setGUID(handler.createSoftwareCapability(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), requestBody.getTypeName(), null, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getDeployedImplementationType(), requestBody.getVersion(), requestBody.getPatchLevel(), requestBody.getSource(), requestBody.getAdditionalProperties(), requestBody.getExtendedProperties(), requestBody.getVendorProperties(), null, null, false, false, new Date(), "createSecurityManagerInCatalog"));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSecurityManagerInCatalog", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getMetadataSourceGUID(String serverName, String userId, String qualifiedName) {
        String methodName = "getMetadataSourceGUID";
        String parameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSourceGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSourceGUID");
            SoftwareCapabilityHandler<SecurityManagerElement> handler = instanceHandler.getSoftwareCapabilityHandler(userId, serverName, "getMetadataSourceGUID");
            response.setGUID(handler.getBeanGUIDByQualifiedName(userId, OpenMetadataType.SOFTWARE_CAPABILITY.typeGUID, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, qualifiedName, "qualifiedName", false, false, new Date(), "getMetadataSourceGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataSourceGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createSecurityGroup(String serverName, String userId, SecurityGroupProperties requestBody) {
        String methodName = "createSecurityGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createSecurityGroup");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "createSecurityGroup");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createSecurityGroup");
                String groupGUID = handler.createGovernanceDefinition(userId, requestBody.getDocumentIdentifier(), requestBody.getTitle(), requestBody.getSummary(), requestBody.getDescription(), requestBody.getScope(), requestBody.getDomainIdentifier(), requestBody.getPriority(), requestBody.getImplications(), requestBody.getOutcomes(), requestBody.getResults(), null, null, null, null, null, requestBody.getDistinguishedName(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), null, null, new Date(), "createSecurityGroup");
                response.setGUID(groupGUID);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createSecurityGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createSecurityGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateSecurityGroup(String serverName, String userId, String securityGroupGUID, boolean isMergeUpdate, SecurityGroupProperties requestBody) {
        String methodName = "updateSecurityGroup";
        String guidParameterName = "securityGroupGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateSecurityGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "updateSecurityGroup");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateSecurityGroup");
                handler.updateGovernanceDefinition(userId, securityGroupGUID, "securityGroupGUID", requestBody.getDocumentIdentifier(), requestBody.getTitle(), requestBody.getSummary(), requestBody.getDescription(), requestBody.getScope(), requestBody.getDomainIdentifier(), requestBody.getPriority(), requestBody.getImplications(), requestBody.getOutcomes(), requestBody.getResults(), null, null, null, null, null, requestBody.getDistinguishedName(), requestBody.getAdditionalProperties(), requestBody.getTypeName(), requestBody.getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateSecurityGroup");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateSecurityGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateSecurityGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteSecurityGroup(String serverName, String userId, String securityGroupGUID, NullRequestBody requestBody) {
        String methodName = "deleteSecurityGroup";
        String guidParameterName = "securityGroupGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteSecurityGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "deleteSecurityGroup");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteSecurityGroup");
                handler.removeGovernanceDefinition(userId, securityGroupGUID, "securityGroupGUID", false, false, new Date(), "deleteSecurityGroup");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteSecurityGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteSecurityGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SecurityGroupsResponse getSecurityGroupsForDistinguishedName(String serverName, String userId, String distinguishedName, int startFrom, int pageSize) {
        String methodName = "getSecurityGroupsForDistinguishedName";
        String distinguishedNameParameterName = "distinguishedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSecurityGroupsForDistinguishedName");
        SecurityGroupsResponse response = new SecurityGroupsResponse();
        AuditLog auditLog = null;
        try {
            GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "getSecurityGroupsForDistinguishedName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityGroupsForDistinguishedName");
            response.setElements(handler.getGovernanceDefinitionsByStringParameter(userId, "042d9b5c-677e-477b-811f-1c39bf716759", "SecurityGroup", distinguishedName, "distinguishedName", OpenMetadataProperty.DISTINGUISHED_NAME.name, startFrom, pageSize, false, false, new Date(), "getSecurityGroupsForDistinguishedName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSecurityGroupsForDistinguishedName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ElementStubsResponse getElementsGovernedBySecurityGroup(String serverName, String userId, String securityGroupGUID, int startFrom, int pageSize) {
        String methodName = "getElementsGovernedBySecurityGroup";
        String guidParameterName = "securityGroupGUID";
        return null;
    }

    public SecurityGroupsResponse findSecurityGroups(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findSecurityGroups";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findSecurityGroups");
        SecurityGroupsResponse response = new SecurityGroupsResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "findSecurityGroups");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findSecurityGroups");
                response.setElements(handler.findGovernanceDefinitions(userId, "SecurityGroup", requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findSecurityGroups"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findSecurityGroups", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findSecurityGroups", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SecurityGroupResponse getSecurityGroupByGUID(String serverName, String userId, String securityGroupGUID) {
        String methodName = "getSecurityGroupByGUID";
        String guidParameterName = "securityGroupGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSecurityGroupByGUID");
        SecurityGroupResponse response = new SecurityGroupResponse();
        AuditLog auditLog = null;
        try {
            GovernanceDefinitionHandler<SecurityGroupElement> handler = instanceHandler.getSecurityGroupHandler(userId, serverName, "getSecurityGroupByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSecurityGroupByGUID");
            response.setElement((SecurityGroupElement)handler.getGovernanceDefinitionByGUID(userId, securityGroupGUID, "securityGroupGUID", false, false, new Date(), "getSecurityGroupByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSecurityGroupByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createUserIdentity(String serverName, String userId, UserIdentityRequestBody requestBody) {
        String methodName = "createUserIdentity";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createUserIdentity");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "createUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createUserIdentity");
                if (requestBody.getProperties() instanceof UserIdentityProperties) {
                    String userIdentityGUID = handler.createUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), null, null, requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getUserId(), requestBody.getProperties().getDistinguishedName(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), false, false, new Date(), "createUserIdentity");
                    response.setGUID(userIdentityGUID);
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(UserIdentityProperties.class.getName(), "createUserIdentity");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateUserIdentity(String serverName, String userId, String userIdentityGUID, boolean isMergeUpdate, UserIdentityRequestBody requestBody) {
        String methodName = "updateUserIdentity";
        String guidParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "updateUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "updateUserIdentity");
                if (requestBody.getProperties() instanceof UserIdentityProperties) {
                    handler.updateUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", requestBody.getProperties().getQualifiedName(), requestBody.getProperties().getUserId(), requestBody.getProperties().getDistinguishedName(), requestBody.getProperties().getAdditionalProperties(), requestBody.getProperties().getTypeName(), requestBody.getProperties().getExtendedProperties(), isMergeUpdate, null, null, false, false, new Date(), "updateUserIdentity");
                } else {
                    this.restExceptionHandler.handleInvalidPropertiesObject(UserIdentityProperties.class.getName(), "updateUserIdentity");
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteUserIdentity(String serverName, String userId, String userIdentityGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "deleteUserIdentity";
        String guidParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteUserIdentity");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "deleteUserIdentity");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteUserIdentity");
                handler.deleteUserIdentity(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", false, false, new Date(), "deleteUserIdentity");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteUserIdentity", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteUserIdentity", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addIdentityToProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "addIdentityToProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addIdentityToProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "addIdentityToProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "addIdentityToProfile");
                handler.addIdentityToProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", null, null, null, null, null, false, false, new Date(), "addIdentityToProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addIdentityToProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addIdentityToProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeIdentityFromProfile(String serverName, String userId, String userIdentityGUID, String profileGUID, ExternalSourceRequestBody requestBody) {
        String methodName = "removeIdentityFromProfile";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        String profileGUIDParameterName = "profileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeIdentityFromProfile");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "removeIdentityFromProfile");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "removeIdentityFromProfile");
                handler.removeIdentifyFromProfile(userId, requestBody.getExternalSourceGUID(), requestBody.getExternalSourceName(), userIdentityGUID, "userIdentityGUID", profileGUID, "profileGUID", false, false, new Date(), "removeIdentityFromProfile");
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "removeIdentityFromProfile", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeIdentityFromProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentitiesResponse findUserIdentities(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findUserIdentities";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findUserIdentities");
        UserIdentitiesResponse response = new UserIdentitiesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "findUserIdentities");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "findUserIdentities");
                List elements = handler.findBeans(userId, requestBody.getSearchString(), "searchString", OpenMetadataType.USER_IDENTITY.typeGUID, OpenMetadataType.USER_IDENTITY.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, new Date(), "findUserIdentities");
                response.setElements(elements);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "findUserIdentities", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findUserIdentities", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentitiesResponse getUserIdentitiesByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getUserIdentitiesByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getUserIdentitiesByName");
        UserIdentitiesResponse response = new UserIdentitiesResponse();
        AuditLog auditLog = null;
        try {
            if (requestBody != null) {
                UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "getUserIdentitiesByName");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "getUserIdentitiesByName");
                List elements = handler.getUserIdentitiesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getUserIdentitiesByName");
                response.setElements(elements);
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getUserIdentitiesByName", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getUserIdentitiesByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public UserIdentityResponse getUserIdentityByGUID(String serverName, String userId, String userIdentityGUID) {
        String methodName = "getUserIdentityByGUID";
        String userIdentityGUIDParameterName = "userIdentityGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getUserIdentityByGUID");
        UserIdentityResponse response = new UserIdentityResponse();
        AuditLog auditLog = null;
        try {
            UserIdentityHandler<UserIdentityElement> handler = instanceHandler.getUserIdentityHandler(userId, serverName, "getUserIdentityByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getUserIdentityByGUID");
            UserIdentityElement element = (UserIdentityElement)handler.getUserIdentityByGUID(userId, userIdentityGUID, "userIdentityGUID", false, false, new Date(), "getUserIdentityByGUID");
            response.setElement(element);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getUserIdentityByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfileResponse getActorProfileByGUID(String serverName, String userId, String actorProfileGUID) {
        String methodName = "getActorProfileByGUID";
        String guidParameterName = "actorProfileGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActorProfileByGUID");
        ActorProfileResponse response = new ActorProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getActorProfileByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActorProfileByGUID");
            response.setElement((ActorProfileElement)handler.getActorProfileByGUID(userId, actorProfileGUID, "actorProfileGUID", OpenMetadataType.ACTOR_PROFILE.typeName, false, false, new Date(), "getActorProfileByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActorProfileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfileResponse getActorProfileByUserId(String serverName, String userId, String actorProfileUserId) {
        String methodName = "getActorProfileByGUID";
        String nameParameterName = "actorProfileUserId";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActorProfileByGUID");
        ActorProfileResponse response = new ActorProfileResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getActorProfileByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActorProfileByGUID");
            response.setElement((ActorProfileElement)handler.getActorProfileForUser(userId, actorProfileUserId, "actorProfileUserId", OpenMetadataType.ACTOR_PROFILE.typeName, false, false, new Date(), "getActorProfileByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActorProfileByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfilesResponse getActorProfileByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getActorProfileByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getActorProfileByName");
        ActorProfilesResponse response = new ActorProfilesResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "getActorProfileByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getActorProfileByName");
            response.setElements(handler.getActorProfilesByName(userId, requestBody.getName(), "name", OpenMetadataType.ACTOR_PROFILE.typeGUID, OpenMetadataType.ACTOR_PROFILE.typeName, startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "getActorProfileByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getActorProfileByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ActorProfilesResponse findActorProfile(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findActorProfile";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findActorProfile");
        ActorProfilesResponse response = new ActorProfilesResponse();
        AuditLog auditLog = null;
        try {
            ActorProfileHandler<ActorProfileElement> handler = instanceHandler.getActorProfileHandler(userId, serverName, "findActorProfile");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findActorProfile");
            response.setElements(handler.findActorProfiles(userId, requestBody.getSearchString(), "searchString", OpenMetadataType.ACTOR_PROFILE.typeGUID, OpenMetadataType.ACTOR_PROFILE.typeName, startFrom, pageSize, false, false, requestBody.getEffectiveTime(), "findActorProfile"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findActorProfile", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AppointeesResponse getAppointees(String serverName, String userId, String personRoleGUID, int startFrom, int pageSize, ResultsRequestBody requestBody) {
        String methodName = "getAppointees";
        String personRoleGUIDParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAppointees");
        AppointeesResponse response = new AppointeesResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> roleHandler = instanceHandler.getPersonRoleHandler(userId, serverName, "getAppointees");
            ActorProfileHandler<ActorProfileElement> profileHandler = instanceHandler.getActorProfileHandler(userId, serverName, "getAppointees");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAppointees");
            if (requestBody != null) {
                List appointmentRelationships = roleHandler.getAttachmentLinks(userId, personRoleGUID, "personRoleGUID", OpenMetadataType.PERSON_ROLE.typeName, OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeGUID, OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName, null, OpenMetadataType.ACTOR_PROFILE.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, startFrom, pageSize, requestBody.getEffectiveTime(), "getAppointees");
                if (appointmentRelationships != null) {
                    ArrayList<Appointee> appointees = new ArrayList<Appointee>();
                    OMRSRepositoryHelper repositoryHelper = roleHandler.getRepositoryHelper();
                    String serviceName = roleHandler.getServiceName();
                    SecurityManagerOMASConverter<Appointee> converter = new SecurityManagerOMASConverter<Appointee>(repositoryHelper, serviceName, serverName);
                    RepositoryErrorHandler errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
                    for (Relationship relationship : appointmentRelationships) {
                        if (relationship != null && relationship.getProperties() != null) {
                            if (requestBody.getEffectiveTime() == null) {
                                Appointee appointee = this.getAppointeeFromRelationship(userId, relationship, profileHandler, converter, repositoryHelper, serviceName, errorHandler, "getAppointees");
                                appointees.add(appointee);
                                continue;
                            }
                            InstanceProperties properties = relationship.getProperties();
                            Date effectiveTime = requestBody.getEffectiveTime();
                            if (properties.getEffectiveFromTime() != null && !properties.getEffectiveFromTime().before(effectiveTime) || properties.getEffectiveToTime() != null && !properties.getEffectiveToTime().after(effectiveTime)) continue;
                            Appointee appointee = this.getAppointeeFromRelationship(userId, relationship, profileHandler, converter, repositoryHelper, serviceName, errorHandler, "getAppointees");
                            appointees.add(appointee);
                            continue;
                        }
                        errorHandler.logBadRelationship(OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName, relationship, "getAppointees");
                    }
                    if (!appointees.isEmpty()) {
                        response.setElements(appointees);
                    }
                }
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getAppointees", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAppointees", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private Appointee getAppointeeFromRelationship(String userId, Relationship relationship, ActorProfileHandler<ActorProfileElement> profileHandler, SecurityManagerOMASConverter<Appointee> converter, OMRSRepositoryHelper repositoryHelper, String serviceName, RepositoryErrorHandler errorHandler, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String profileGUIDParameterName = "profileGUID";
        if (relationship != null && relationship.getProperties() != null && relationship.getEntityOneProxy() != null && relationship.getEntityTwoProxy() != null) {
            Appointee appointee = new Appointee();
            InstanceProperties properties = relationship.getProperties();
            ElementHeader elementHeader = converter.getMetadataElementHeader(Appointee.class, (InstanceHeader)relationship, null, methodName);
            appointee.setElementHeader(elementHeader);
            appointee.setStartDate(properties.getEffectiveFromTime());
            appointee.setEndDate(properties.getEffectiveToTime());
            appointee.setIsPublic(repositoryHelper.getBooleanProperty(serviceName, OpenMetadataProperty.IS_PUBLIC.name, relationship.getProperties(), methodName));
            ActorProfileElement profile = (ActorProfileElement)profileHandler.getActorProfileByGUID(userId, relationship.getEntityOneProxy().getGUID(), "profileGUID", OpenMetadataType.ACTOR_PROFILE.typeName, false, false, new Date(), methodName);
            appointee.setProfile(profile);
            return appointee;
        }
        errorHandler.logBadRelationship(OpenMetadataType.PERSON_ROLE_APPOINTMENT_RELATIONSHIP.typeName, relationship, methodName);
        return null;
    }

    public PersonRoleResponse getPersonRoleByGUID(String serverName, String userId, String personRoleGUID) {
        String methodName = "getPersonRoleByGUID";
        String guidParameterName = "personRoleGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPersonRoleByGUID");
        PersonRoleResponse response = new PersonRoleResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "getPersonRoleByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonRoleByGUID");
            response.setElement((PersonRoleElement)handler.getPersonRoleByGUID(userId, personRoleGUID, "personRoleGUID", false, false, new Date(), "getPersonRoleByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPersonRoleByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRolesResponse getPersonRoleByName(String serverName, String userId, int startFrom, int pageSize, NameRequestBody requestBody) {
        String methodName = "getPersonRoleByName";
        String nameParameterName = "name";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getPersonRoleByName");
        PersonRolesResponse response = new PersonRolesResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "getPersonRoleByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getPersonRoleByName");
            response.setElements(handler.getPersonRolesByName(userId, requestBody.getName(), "name", startFrom, pageSize, false, false, new Date(), "getPersonRoleByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getPersonRoleByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public PersonRolesResponse findPersonRole(String serverName, String userId, int startFrom, int pageSize, SearchStringRequestBody requestBody) {
        String methodName = "findPersonRole";
        String searchStringParameterName = "searchString";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "findPersonRole");
        PersonRolesResponse response = new PersonRolesResponse();
        AuditLog auditLog = null;
        try {
            PersonRoleHandler<PersonRoleElement> handler = instanceHandler.getPersonRoleHandler(userId, serverName, "findPersonRole");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "findPersonRole");
            response.setElements(handler.findPersonRoles(userId, requestBody.getSearchString(), "searchString", startFrom, pageSize, false, false, new Date(), "findPersonRole"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "findPersonRole", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

