/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.securitymanager.properties.SecurityGroupProperties;
import org.odpi.openmetadata.accessservices.securitymanager.rest.ActorProfileListResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.ActorProfileResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.EffectiveTimeRequestBody;
import org.odpi.openmetadata.accessservices.securitymanager.rest.ElementStubsResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.accessservices.securitymanager.rest.PersonRoleAppointeeListResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.PersonRoleListResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.PersonRoleResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.SecurityGroupResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.SecurityGroupsResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.SecurityManagerRequestBody;
import org.odpi.openmetadata.accessservices.securitymanager.rest.UserIdentitiesResponse;
import org.odpi.openmetadata.accessservices.securitymanager.rest.UserIdentityRequestBody;
import org.odpi.openmetadata.accessservices.securitymanager.rest.UserIdentityResponse;
import org.odpi.openmetadata.accessservices.securitymanager.server.SecurityManagerRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/security-manager/users/{userId}"})
@Tag(name="Security Manager OMAS", description="The Security Manager OMAS provides APIs for tools and applications wishing to manage metadata relating to security managers.", externalDocs=@ExternalDocumentation(description="Security Manager Open Metadata Access Service (OMAS)", url="https://egeria-project.org/services/omas/security-manager/overview/"))
public class SecurityManagerOMASResource {
    private SecurityManagerRESTServices restAPI = new SecurityManagerRESTServices();

    @GetMapping(path={"/topics/out-topic-connection/{callerId}"})
    public ConnectionResponse getOutTopicConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String callerId) {
        return this.restAPI.getOutTopicConnection(serverName, userId, callerId);
    }

    @PostMapping(path={"/metadata-sources/security-managers"})
    public GUIDResponse createSecurityManagerInCatalog(@PathVariable String serverName, @PathVariable String userId, @RequestBody SecurityManagerRequestBody requestBody) {
        return this.restAPI.createSecurityManagerInCatalog(serverName, userId, requestBody);
    }

    @GetMapping(path={"metadata-sources/by-name/{qualifiedName}"})
    public GUIDResponse getMetadataSourceGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String qualifiedName) {
        return this.restAPI.getMetadataSourceGUID(serverName, userId, qualifiedName);
    }

    @PostMapping(value={"/security-groups"})
    public GUIDResponse createSecurityGroup(@PathVariable String serverName, @PathVariable String userId, @RequestBody SecurityGroupProperties requestBody) {
        return this.restAPI.createSecurityGroup(serverName, userId, requestBody);
    }

    @PostMapping(value={"/security-groups/{securityGroupGUID}/update"})
    public VoidResponse updateSecurityGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String securityGroupGUID, @RequestParam boolean isMergeUpdate, @RequestBody SecurityGroupProperties requestBody) {
        return this.restAPI.updateSecurityGroup(serverName, userId, securityGroupGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(value={"/security-groups/{securityGroupGUID}/delete"})
    public VoidResponse deleteSecurityGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String securityGroupGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.deleteSecurityGroup(serverName, userId, securityGroupGUID, requestBody);
    }

    @GetMapping(value={"/security-groups/for-distinguished-name/{distinguishedName}"})
    public SecurityGroupsResponse getSecurityGroupsForDistinguishedName(@PathVariable String serverName, @PathVariable String userId, @PathVariable String distinguishedName, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSecurityGroupsForDistinguishedName(serverName, userId, distinguishedName, startFrom, pageSize);
    }

    @GetMapping(value={"/security-groups/{securityGroupGUID}/governed-by/elements"})
    public ElementStubsResponse getElementsGovernedBySecurityGroup(@PathVariable String serverName, @PathVariable String userId, @PathVariable String securityGroupGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getElementsGovernedBySecurityGroup(serverName, userId, securityGroupGUID, startFrom, pageSize);
    }

    @PostMapping(value={"/security-groups/by-search-string"})
    public SecurityGroupsResponse findSecurityGroups(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findSecurityGroups(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(value={"/security-groups/{securityGroupGUID}"})
    public SecurityGroupResponse getSecurityGroupByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String securityGroupGUID) {
        return this.restAPI.getSecurityGroupByGUID(serverName, userId, securityGroupGUID);
    }

    @PostMapping(path={"/user-identities"})
    public GUIDResponse createUserIdentity(@PathVariable String serverName, @PathVariable String userId, @RequestBody UserIdentityRequestBody requestBody) {
        return this.restAPI.createUserIdentity(serverName, userId, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}"})
    public VoidResponse updateUserIdentity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @RequestParam boolean isMergeUpdate, @RequestBody UserIdentityRequestBody requestBody) {
        return this.restAPI.updateUserIdentity(serverName, userId, userIdentityGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/delete"})
    public VoidResponse deleteUserIdentity(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteUserIdentity(serverName, userId, userIdentityGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/profiles/{profileGUID}/link"})
    public VoidResponse addIdentityToProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @PathVariable String profileGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.addIdentityToProfile(serverName, userId, userIdentityGUID, profileGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/{userIdentityGUID}/profiles/{profileGUID}/unlink"})
    public VoidResponse removeIdentityFromProfile(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID, @PathVariable String profileGUID, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.removeIdentityFromProfile(serverName, userId, userIdentityGUID, profileGUID, requestBody);
    }

    @PostMapping(path={"/user-identities/by-search-string"})
    public UserIdentitiesResponse findUserIdentities(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findUserIdentities(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/user-identities/by-name"})
    public UserIdentitiesResponse getUserIdentitiesByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getUserIdentitiesByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/user-identities/{userIdentityGUID}"})
    public UserIdentityResponse getUserIdentityByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String userIdentityGUID) {
        return this.restAPI.getUserIdentityByGUID(serverName, userId, userIdentityGUID);
    }

    @GetMapping(path={"/profiles/{actorProfileGUID}"})
    public ActorProfileResponse getActorProfileByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileGUID) {
        return this.restAPI.getActorProfileByGUID(serverName, userId, actorProfileGUID);
    }

    @GetMapping(path={"/profiles/user-ids/{actorProfileUserId}"})
    public ActorProfileResponse getActorProfileByUserId(@PathVariable String serverName, @PathVariable String userId, @PathVariable String actorProfileUserId) {
        return this.restAPI.getActorProfileByUserId(serverName, userId, actorProfileUserId);
    }

    @PostMapping(path={"/profiles/by-name"})
    public ActorProfileListResponse getActorProfileByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getActorProfileByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/profiles/by-search-string"})
    public ActorProfileListResponse findActorProfile(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findActorProfile(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/person-roles/{personRoleGUID}/appointees"})
    public PersonRoleAppointeeListResponse getAppointees(@PathVariable String serverName, @PathVariable String userId, @PathVariable String personRoleGUID, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody EffectiveTimeRequestBody requestBody) {
        return this.restAPI.getAppointees(serverName, userId, personRoleGUID, startFrom, pageSize, requestBody);
    }

    @GetMapping(path={"/person-roles/{personRoleGUID}"})
    public PersonRoleResponse getPersonRoleByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String personRoleGUID) {
        return this.restAPI.getPersonRoleByGUID(serverName, userId, personRoleGUID);
    }

    @PostMapping(path={"/person-roles/by-name"})
    public PersonRoleListResponse getPersonRoleByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getPersonRoleByName(serverName, userId, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/person-roles/by-search-string"})
    public PersonRoleListResponse findPersonRole(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findPersonRole(serverName, userId, startFrom, pageSize, requestBody);
    }
}

