/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.securitymanager.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.securitymanager.api.SecurityManagerEventInterface;
import org.odpi.openmetadata.accessservices.securitymanager.api.SecurityManagerEventListener;
import org.odpi.openmetadata.accessservices.securitymanager.events.SecurityManagerOutTopicEvent;
import org.odpi.openmetadata.accessservices.securitymanager.ffdc.SecurityManagerErrorCode;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityManagerOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements SecurityManagerEventInterface {
    private static final Logger log = LoggerFactory.getLogger(SecurityManagerOutTopicClientConnector.class);
    private List<SecurityManagerEventListener> internalEventListeners = new ArrayList<SecurityManagerEventListener>();

    public synchronized void registerListener(String userId, SecurityManagerEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(SecurityManagerErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                SecurityManagerOutTopicEvent eventObject = (SecurityManagerOutTopicEvent)super.getEventBean(event, SecurityManagerOutTopicEvent.class);
                for (SecurityManagerEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

